/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.method.unihan;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipInputStream;
import me.shedaniel.rei.impl.common.InternalLogger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class UniHanManager {
    private final Path unihanPath;

    public UniHanManager(Path unihanPath) {
        this.unihanPath = unihanPath;
    }

    public boolean downloaded() {
        return Files.exists(this.unihanPath, new LinkOption[0]);
    }

    public void download() {
        if (this.downloaded()) {
            return;
        }
        try {
            int x;
            URL url = new URL("https://www.unicode.org/Public/UCD/latest/ucd/Unihan.zip");
            Files.deleteIfExists(this.unihanPath);
            Path parent = this.unihanPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            long completeFileSize = httpConnection.getContentLength();
            BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream, 1024);
            byte[] data = new byte[1024];
            long downloadedFileSize = 0L;
            int lastPercent = 0;
            while ((x = inputStream.read(data, 0, 1024)) >= 0) {
                double progress = (double)(downloadedFileSize += (long)x) / (double)completeFileSize;
                int percent = (int)(progress * 100.0);
                if (percent > lastPercent) {
                    lastPercent = percent;
                    InternalLogger.getInstance().debug("Downloading UniHan Progress: %d%%".formatted(percent));
                }
                bufferedStream.write(data, 0, x);
            }
            bufferedStream.close();
            inputStream.close();
            Files.write(this.unihanPath, outputStream.toByteArray(), StandardOpenOption.CREATE);
            InternalLogger.getInstance().debug("Downloaded UniHan");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Path getUnihanPath() {
        return this.unihanPath;
    }

    public void load(DataConsumer consumer) throws IOException {
        try (ZipInputStream inputStream = new ZipInputStream(Files.newInputStream(this.getUnihanPath(), new OpenOption[0]));){
            while (inputStream.getNextEntry() != null) {
                this.read(IOUtils.lineIterator((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), consumer);
            }
        }
    }

    private void read(LineIterator lines, DataConsumer consumer) {
        int i = 0;
        while (lines.hasNext()) {
            ++i;
            String line = lines.nextLine();
            if (line.startsWith("#") || line.isEmpty()) continue;
            if (!line.startsWith("U+")) {
                throw new IllegalArgumentException("Invalid line: " + i + ", " + line);
            }
            int firstTab = line.indexOf(9);
            String code = line.substring(2, firstTab);
            int codePoint = Integer.parseInt(code, 16);
            int secondTab = line.indexOf(9, firstTab + 1);
            String fieldKey = line.substring(firstTab + 1, secondTab);
            String data = line.substring(secondTab + 1);
            consumer.read(codePoint, fieldKey, data);
        }
    }

    @FunctionalInterface
    public static interface DataConsumer {
        public void read(int var1, String var2, String var3);
    }
}

