/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.search;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchFieldSyntaxHighlighter;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.argument.type.TextArgumentType;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.glfw.GLFW;

@ApiStatus.Internal
public class OverlaySearchField
extends TextFieldWidget
implements TextFieldWidget.TextFormatter {
    public static boolean isHighlighting = false;
    private static final class_2583 SPLITTER_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final class_2583 QUOTES_STYLE = class_2583.field_24360.method_10977(class_124.field_1065);
    private static final class_2583 ERROR_STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF5555));
    private boolean previouslyClicking = false;
    private final OverlaySearchFieldSyntaxHighlighter highlighter = new OverlaySearchFieldSyntaxHighlighter(this.getText());
    public long keybindFocusTime = -1L;
    public int keybindFocusKey = -1;
    public boolean isMain = true;
    protected class_3545<Long, Point> lastClickedDetails = null;
    private List<String> history = Lists.newArrayListWithCapacity((int)100);
    private final NumberAnimator<Double> progress = ValueAnimator.ofDouble();

    public OverlaySearchField(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setMaxLength(10000);
        this.setFormatter(this);
        super.setResponder(this.highlighter);
    }

    @Override
    public class_5481 format(TextFieldWidget widget, String text, int index) {
        boolean isPlain = ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.PLAIN || ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.PLAIN_UNDERSCORED;
        boolean hasUnderscore = ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.PLAIN_UNDERSCORED || ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.COLORFUL_UNDERSCORED;
        return TextTransformations.forwardWithTransformation(text, (s, charIndex, c) -> {
            byte arg = this.highlighter.highlighted[charIndex + index];
            class_2583 style = class_2583.field_24360;
            if (this.isMain && ScreenOverlayImpl.getEntryListWidget().isEmpty() && !this.getText().isEmpty()) {
                style = ERROR_STYLE;
            }
            if (arg > 0) {
                ArgumentType<?, ?> argumentType = ArgumentTypesRegistry.ARGUMENT_TYPE_LIST.get((arg - 1) / 2);
                if (!isPlain) {
                    style = argumentType.getHighlightedStyle();
                }
                if (!(argumentType instanceof TextArgumentType) && hasUnderscore && arg % 2 == 1) {
                    style = style.method_30938(Boolean.valueOf(true));
                }
            } else if (!isPlain) {
                if (arg == -1) {
                    style = SPLITTER_STYLE;
                } else if (arg == -2) {
                    style = QUOTES_STYLE;
                }
            }
            if (this.containsMouse(PointHelper.ofMouse()) || this.isFocused()) {
                return style;
            }
            return style.method_27703(class_5251.method_27717((int)Color.ofOpaque((int)(style.method_10973() == null ? -1 : style.method_10973().method_27716())).brighter(0.75).getColor()));
        });
    }

    @Override
    public void setResponder(Consumer<String> responder) {
        super.setResponder(this.highlighter.andThen(responder));
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.isFocused() != focused && this.isMain) {
            this.addToHistory(this.getText());
        }
        super.setFocused(focused);
    }

    @ApiStatus.Internal
    public void addToHistory(String text) {
        if (!text.isEmpty()) {
            this.history.removeIf(str -> str.equalsIgnoreCase(text));
            if (this.history.size() > 100) {
                this.history.remove(0);
            }
            this.history.add(text);
        }
    }

    public void laterRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.progress.update((double)delta);
        RenderSystem.disableDepthTest();
        if (this.isMain) {
            this.drawHint(matrices, mouseX, mouseY);
        }
        this.setSuggestion(!this.isFocused() && this.getText().isEmpty() ? class_1074.method_4662((String)"text.rei.search.field.suggestion", (Object[])new Object[0]) : null);
        super.method_25394(matrices, mouseX, mouseY, delta);
        RenderSystem.enableDepthTest();
    }

    private void drawHint(class_4587 poses, int mouseX, int mouseY) {
        List<HintProvider> hintProviders;
        List hints;
        boolean mouseDown = GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) != 0;
        boolean clicking = false;
        if (mouseDown != this.previouslyClicking) {
            this.previouslyClicking = mouseDown;
            clicking = mouseDown;
        }
        if ((hints = CollectionUtils.flatMap(hintProviders = REIRuntimeImpl.getInstance().getHintProviders(), provider -> CollectionUtils.map(provider.provide(), component -> new Pair(provider, component)))).isEmpty()) {
            return;
        }
        int width = this.getBounds().getWidth() - 4;
        List sequences = CollectionUtils.flatMap(hints, pair -> CollectionUtils.map(this.font.method_1728((class_5348)pair.getSecond(), width - 6), sequence -> new Pair((Object)((HintProvider)pair.getFirst()), sequence)));
        OptionalDouble progress = hintProviders.stream().map(HintProvider::getProgress).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average();
        List buttons = hints.stream().map(Pair::getFirst).distinct().map(HintProvider::getButtons).flatMap(Collection::stream).toList();
        boolean hasProgress = progress.isPresent();
        if (!hasProgress) {
            this.progress.setAs(0);
        } else {
            this.progress.setTo(progress.getAsDouble(), 200L);
        }
        Color color = hints.stream().map(Pair::getFirst).distinct().map(HintProvider::getColor).reduce((color1, color2) -> {
            int r = color1.getRed() - (color1.getRed() - color2.getRed()) / 2;
            int g = color1.getGreen() - (color1.getGreen() - color2.getGreen()) / 2;
            int b = color1.getBlue() - (color1.getBlue() - color2.getBlue()) / 2;
            return Color.ofRGBA((int)r, (int)g, (int)b, (int)((color1.getAlpha() + color2.getAlpha()) / 2));
        }).orElse(Color.ofTransparent((int)0x50000000));
        Objects.requireNonNull(this.font);
        int height = 6 + 9 * sequences.size() + (hasProgress ? 2 : 0) + (buttons.isEmpty() ? 0 : (int)Math.ceil((double)buttons.size() / 3.0) * 20);
        int x = this.getBounds().getX() + 2;
        int y = this.getBounds().getY() - height;
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 pose = poses.method_23760().method_23761();
        int background = -267386864;
        int color12 = color.getColor();
        int color22 = color.darker(2.0).getColor();
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)x, (int)(y - 1), (int)(x + width), (int)y, (int)400, (int)background, (int)background);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)x, (int)(y + height), (int)(x + width), (int)(y + height + 1), (int)400, (int)background, (int)background);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)400, (int)background, (int)background);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)(x - 1), (int)y, (int)x, (int)(y + height), (int)400, (int)background, (int)background);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)(x + width), (int)y, (int)(x + width + 1), (int)(y + height), (int)400, (int)background, (int)background);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)400, (int)color12, (int)color22);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)400, (int)color12, (int)color22);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)400, (int)color12, (int)color12);
        OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)400, (int)color22, (int)color22);
        if (hasProgress) {
            int progressWidth = (int)Math.round((double)width * this.progress.doubleValue());
            OverlaySearchField.method_27533((class_1159)pose, (class_287)bufferBuilder, (int)(x + 1), (int)(y + height - 3), (int)(x + progressWidth - 1), (int)(y + height - 1), (int)400, (int)-1, (int)-1);
        }
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        poses.method_22903();
        poses.method_22904(0.0, 0.0, 450.0);
        for (int i = 0; i < sequences.size(); ++i) {
            Tooltip tooltip;
            Pair pair2 = (Pair)sequences.get(i);
            class_5481 class_54812 = (class_5481)pair2.getSecond();
            float f = x + 3;
            Objects.requireNonNull(this.font);
            int lineWidth = this.font.method_27517(poses, class_54812, f, (float)(y + 3 + 9 * i), -1);
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            if (!new Rectangle(x + 3, y + 3 + 9 * i, lineWidth, 9).contains(mouseX, mouseY) || (tooltip = ((HintProvider)pair2.getFirst()).provideTooltip(new Point(mouseX, mouseY))) == null) continue;
            ScreenOverlayImpl.getInstance().clearTooltips();
            ScreenOverlayImpl.getInstance().renderTooltip(poses, tooltip);
        }
        int split = 2;
        for (HintProvider.HintButton button : buttons) {
            int y2;
            int x2;
            int y1;
            int x1 = x + 4 + (width - 8 - 8) / split * (buttons.indexOf(button) % split);
            Rectangle bounds = new Rectangle(x1, y1 = y + height - 20 - 20 * (int)Math.floor((float)buttons.indexOf(button) / (float)split), (x2 = x1 + (width - 8 - 8) / split) - x1 - 4, (y2 = y1 + 16) - y1);
            int buttonColor = bounds.contains(mouseX, mouseY) ? -1886417009 : 0x66666666;
            this.method_25296(poses, x1, y1, x2 - 4, y2, buttonColor, buttonColor);
            this.font.method_30881(poses, button.name(), (float)((x1 + x2 - 4 - this.font.method_27525((class_5348)button.name())) / 2), (float)(y1 + 4), -1);
            if (!bounds.contains(mouseX, mouseY) || !clicking) continue;
            Widgets.produceClickSound();
            button.action().accept(bounds);
        }
        poses.method_22909();
    }

    @Override
    protected void renderSuggestion(class_4587 matrices, int x, int y) {
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 400.0);
        int color = this.containsMouse(PointHelper.ofMouse()) || this.isFocused() ? -571806998 : -6250336;
        this.font.method_1720(matrices, this.font.method_27523(this.getSuggestion(), this.getWidth()), (float)x, (float)y, color);
        matrices.method_22909();
    }

    @Override
    public void renderBorder(class_4587 matrices) {
        int borderColor;
        boolean bl = isHighlighting = isHighlighting && ConfigObject.getInstance().isInventoryHighlightingAllowed();
        if (this.isMain && isHighlighting) {
            borderColor = -852212;
        } else if (this.isMain && ScreenOverlayImpl.getEntryListWidget().isEmpty() && !this.getText().isEmpty()) {
            borderColor = -43691;
        } else {
            super.renderBorder(matrices);
            return;
        }
        OverlaySearchField.method_25294((class_4587)matrices, (int)(this.getBounds().x - 1), (int)(this.getBounds().y - 1), (int)(this.getBounds().x + this.getBounds().width + 1), (int)(this.getBounds().y + this.getBounds().height + 1), (int)-16777216);
        OverlaySearchField.method_25294((class_4587)matrices, (int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + this.getBounds().width), (int)(this.getBounds().y + this.getBounds().height), (int)borderColor);
        OverlaySearchField.method_25294((class_4587)matrices, (int)(this.getBounds().x + 1), (int)(this.getBounds().y + 1), (int)(this.getBounds().x + this.getBounds().width - 1), (int)(this.getBounds().y + this.getBounds().height - 1), (int)-16777216);
    }

    public int getManhattanDistance(Point point1, Point point2) {
        int e = Math.abs(point1.getX() - point2.getX());
        int f = Math.abs(point1.getY() - point2.getY());
        return e + f;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean contains = this.containsMouse(mouseX, mouseY);
        if (this.isVisible() && contains && button == 1) {
            this.setText("");
        }
        if (contains && button == 0 && this.isMain && ConfigObject.getInstance().isInventoryHighlightingAllowed()) {
            if (this.lastClickedDetails == null) {
                this.lastClickedDetails = new class_3545((Object)System.currentTimeMillis(), (Object)new Point(mouseX, mouseY));
            } else if (System.currentTimeMillis() - (Long)this.lastClickedDetails.method_15442() > 1500L) {
                this.lastClickedDetails = null;
            } else if (this.getManhattanDistance((Point)this.lastClickedDetails.method_15441(), new Point(mouseX, mouseY)) <= 25) {
                this.lastClickedDetails = null;
                isHighlighting = !isHighlighting;
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            } else {
                this.lastClickedDetails = new class_3545((Object)System.currentTimeMillis(), (Object)new Point(mouseX, mouseY));
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isVisible() && this.isFocused() && this.isMain) {
            int i;
            if (keyCode == 257 || keyCode == 335) {
                this.addToHistory(this.getText());
                this.setFocused(false);
                return true;
            }
            if (keyCode == 265) {
                int i2 = this.history.indexOf(this.getText()) - 1;
                if (i2 < -1 && this.getText().isEmpty()) {
                    i2 = this.history.size() - 1;
                } else if (i2 < -1) {
                    this.addToHistory(this.getText());
                    i2 = this.history.size() - 2;
                }
                if (i2 >= 0) {
                    this.setText(this.history.get(i2));
                    return true;
                }
            } else if (keyCode == 264 && (i = this.history.indexOf(this.getText()) + 1) > 0) {
                this.setText(i < this.history.size() ? this.history.get(i) : "");
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.isVisible() && this.isFocused() && this.isMain && this.keybindFocusKey != -1) {
            this.keybindFocusTime = -1L;
            this.keybindFocusKey = -1;
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char character, int modifiers) {
        if (this.isMain && System.currentTimeMillis() - this.keybindFocusTime < 1000L && this.keybindFocusKey != -1 && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)this.keybindFocusKey)) {
            this.keybindFocusTime = -1L;
            this.keybindFocusKey = -1;
            return true;
        }
        return super.method_25400(character, modifiers);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return (!this.isMain || REIRuntime.getInstance().getOverlay().get().isNotInExclusionZones(mouseX, mouseY)) && super.containsMouse(mouseX, mouseY);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }
}

