/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import team.creative.ambientsounds.AmbientEngine;

public class BiomeEnviroment {
    public final LinkedHashMap<BiomeArea, Float> biomes = new LinkedHashMap();

    public BiomeEnviroment() {
    }

    public BiomeEnviroment(AmbientEngine engine, class_1657 player, class_1937 level, double volume, double surface) {
        if (volume > 0.0) {
            class_2338 center = player.method_33575();
            class_2338.class_2339 pos = new class_2338.class_2339();
            for (int x = -engine.biomeScanCount; x <= engine.biomeScanCount; ++x) {
                for (int z = -engine.biomeScanCount; z <= engine.biomeScanCount; ++z) {
                    BiomeArea area;
                    Float before;
                    pos.method_10103(center.method_10263() + x * engine.biomeScanDistance, center.method_10264(), center.method_10260() + z * engine.biomeScanDistance);
                    class_6880 class_68802 = level.method_23753((class_2338)pos);
                    float biomeVolume = (float)((1.0 - Math.sqrt(center.method_10262((class_2382)pos)) / (double)(engine.biomeScanCount * engine.biomeScanDistance * 2)) * volume);
                    if (class_1959.method_40136((class_6880)class_68802) != class_1959.class_1961.field_29217) {
                        biomeVolume = (float)((double)biomeVolume * surface);
                    }
                    if ((before = this.biomes.get(area = new BiomeArea(level, (class_6880<class_1959>)class_68802, (class_2338)pos))) == null) {
                        before = Float.valueOf(0.0f);
                    }
                    this.biomes.put(area, Float.valueOf(Math.max(before.floatValue(), biomeVolume)));
                }
            }
            ArrayList<Map.Entry<BiomeArea, Float>> entries = new ArrayList<Map.Entry<BiomeArea, Float>>(this.biomes.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<BiomeArea, Float>>(){

                @Override
                public int compare(Map.Entry<BiomeArea, Float> o1, Map.Entry<BiomeArea, Float> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            for (Map.Entry entry : entries) {
                this.biomes.put((BiomeArea)entry.getKey(), (Float)entry.getValue());
            }
        }
    }

    public static class BiomeArea {
        public final class_6880<class_1959> biome;
        public final class_2960 location;
        public final class_2338 pos;

        public BiomeArea(class_1937 level, class_6880<class_1959> biome, class_2338 pos) {
            this.biome = biome;
            this.location = level.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)biome.comp_349()));
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                String biomename = class_1959.method_40136(this.biome).method_8749().toLowerCase().replace("_", " ");
                if (biomename.matches(".*" + name.replace("*", ".*") + ".*")) {
                    return true;
                }
                if (!this.location.method_12832().matches(".*" + name.replace("*", ".*") + ".*")) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome.equals(this.biome);
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }
}

