/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.lifecycle.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3222;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;

public final class ServerLifecycleEvents {
    public static final Event<ServerStarting> SERVER_STARTING = EventFactory.createArrayBacked(ServerStarting.class, callbacks -> server -> {
        for (ServerStarting callback : callbacks) {
            callback.onServerStarting(server);
        }
    });
    public static final Event<ServerStarted> SERVER_STARTED = EventFactory.createArrayBacked(ServerStarted.class, callbacks -> server -> {
        for (ServerStarted callback : callbacks) {
            callback.onServerStarted(server);
        }
    });
    public static final Event<ServerStopping> SERVER_STOPPING = EventFactory.createArrayBacked(ServerStopping.class, callbacks -> server -> {
        for (ServerStopping callback : callbacks) {
            callback.onServerStopping(server);
        }
    });
    public static final Event<ServerStopped> SERVER_STOPPED = EventFactory.createArrayBacked(ServerStopped.class, callbacks -> server -> {
        for (ServerStopped callback : callbacks) {
            callback.onServerStopped(server);
        }
    });
    public static final Event<SyncDataPackContents> SYNC_DATA_PACK_CONTENTS = EventFactory.createArrayBacked(SyncDataPackContents.class, callbacks -> (player, joined) -> {
        for (SyncDataPackContents callback : callbacks) {
            callback.onSyncDataPackContents(player, joined);
        }
    });
    public static final Event<StartDataPackReload> START_DATA_PACK_RELOAD = EventFactory.createArrayBacked(StartDataPackReload.class, callbacks -> (server, serverResourceManager) -> {
        for (StartDataPackReload callback : callbacks) {
            callback.startDataPackReload(server, serverResourceManager);
        }
    });
    public static final Event<EndDataPackReload> END_DATA_PACK_RELOAD = EventFactory.createArrayBacked(EndDataPackReload.class, callbacks -> (server, serverResourceManager, success) -> {
        for (EndDataPackReload callback : callbacks) {
            callback.endDataPackReload(server, serverResourceManager, success);
        }
    });

    private ServerLifecycleEvents() {
    }

    @FunctionalInterface
    public static interface EndDataPackReload {
        public void endDataPackReload(MinecraftServer var1, class_6860 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface StartDataPackReload {
        public void startDataPackReload(MinecraftServer var1, class_6860 var2);
    }

    @FunctionalInterface
    public static interface SyncDataPackContents {
        public void onSyncDataPackContents(class_3222 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ServerStopped {
        public void onServerStopped(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface ServerStopping {
        public void onServerStopping(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface ServerStarted {
        public void onServerStarted(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface ServerStarting {
        public void onServerStarting(MinecraftServer var1);
    }
}

