/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch.render;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL20;

public class EarlyRenderFormat {
    public static final EarlyRenderFormat POSITION_COLOR = new EarlyRenderFormat().addPart(PartType.FLOAT, 3).addPart(PartType.FLOAT, 4);
    public static final EarlyRenderFormat POSITION_COLOR_TEX = new EarlyRenderFormat().addPart(PartType.FLOAT, 3).addPart(PartType.FLOAT, 4).addPart(PartType.FLOAT, 2);
    public final List<Part> parts = new ArrayList<Part>();
    public int stride;

    public EarlyRenderFormat addPart(PartType type, int count) {
        this.parts.add(new Part(type, count));
        this.updateStride();
        return this;
    }

    private void updateStride() {
        this.stride = 0;
        for (Part part : this.parts) {
            this.stride += part.count * part.type.size;
        }
    }

    public void setupAttrs() {
        int offset = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = this.parts.get(i);
            GL20.glVertexAttribPointer((int)i, (int)part.count, (int)part.type.glType, (boolean)false, (int)this.stride, (long)offset);
            GL20.glEnableVertexAttribArray((int)i);
            offset += part.count * part.type.size;
        }
    }

    public void cleanAttrs() {
        for (int i = 0; i < this.parts.size(); ++i) {
            GL20.glDisableVertexAttribArray((int)i);
        }
    }

    private record Part(PartType type, int count) {
    }

    public static enum PartType {
        FLOAT(5126, 4);

        private final int glType;
        private final int size;

        private PartType(int glType, int size) {
            this.glType = glType;
            this.size = size;
        }
    }
}

