/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.shedaniel.errornotifier.ErrorNotifierPlatform;
import me.shedaniel.errornotifier.launch.EarlyShaderProgram;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

public class EarlyShader {
    private final int handle;
    private final ShaderType shaderType;

    public static void useShader(String shaderName) {
        EarlyShaderProgram.getProgram(shaderName).use();
    }

    public static int getUniform(String shaderName, String uniformName) {
        return EarlyShaderProgram.getProgram(shaderName).getUniform(uniformName);
    }

    static EarlyShader createVertexShader(String shaderName) {
        EarlyShader earlyShader;
        block8: {
            InputStream stream = ErrorNotifierPlatform.getResourceResolver().resolve("error_notifier_shaders/" + shaderName + ".vsh");
            try {
                earlyShader = new EarlyShader(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), ShaderType.VERTEX);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return earlyShader;
    }

    static EarlyShader createFragmentShader(String shaderName) {
        EarlyShader earlyShader;
        block8: {
            InputStream stream = ErrorNotifierPlatform.getResourceResolver().resolve("error_notifier_shaders/" + shaderName + ".fsh");
            try {
                earlyShader = new EarlyShader(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), ShaderType.FRAGMENT);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return earlyShader;
    }

    public EarlyShader(String shader, ShaderType shaderType) {
        this.handle = GL20.glCreateShader((int)(shaderType == ShaderType.VERTEX ? 35633 : 35632));
        this.shaderType = shaderType;
        GL20.glShaderSource((int)this.handle, (CharSequence)("#version 150\n\n" + shader));
        GL20.glCompileShader((int)this.handle);
        String infoLog = GL20.glGetShaderInfoLog((int)this.handle, (int)512);
        System.out.println("Shader " + shaderType + " compilation status: " + infoLog);
    }

    int getHandle() {
        return this.handle;
    }

    public static enum ShaderType {
        VERTEX,
        FRAGMENT;

    }
}

