/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.errornotifier.ErrorNotifierPlatform;
import me.shedaniel.errornotifier.launch.ColorUtil;
import me.shedaniel.errornotifier.launch.EarlyWindow;
import me.shedaniel.errornotifier.launch.early.BakedGlyph;
import me.shedaniel.errornotifier.launch.early.FontLoader;
import me.shedaniel.errornotifier.launch.early.FontTexture;
import me.shedaniel.errornotifier.launch.early.Glyph;
import me.shedaniel.errornotifier.launch.early.Image;
import me.shedaniel.errornotifier.launch.early.ImageTexture;
import me.shedaniel.errornotifier.launch.early.MissingGlyph;
import me.shedaniel.errornotifier.launch.early.Texture;
import me.shedaniel.errornotifier.launch.render.EarlyBufferBuilder;
import me.shedaniel.errornotifier.launch.render.EarlyDrawType;
import me.shedaniel.errornotifier.launch.render.EarlyRenderFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public enum EarlyGraphics {
    INSTANCE;

    public static final Logger LOGGER;
    public static final Map<String, Texture> textures;
    public static Font font;

    public static Font getFont() {
        if (font == null) {
            JsonElement element = JsonParser.parseString((String)"{\"type\":\"bitmap\",\"file\":\"/assets/minecraft/textures/font/ascii.png\",\"ascent\":7,\"chars\":[\"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\",\"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\",\" !\\\"#$%&'()*+,-./\",\"0123456789:;<=>?\",\"@ABCDEFGHIJKLMNO\",\"PQRSTUVWXYZ[\\\\]^_\",\"`abcdefghijklmno\",\"pqrstuvwxyz{|}~\\u0000\",\"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\",\"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\u00a3\\u0000\\u0000\u0192\",\"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\u00aa\u00ba\\u0000\\u0000\u00ac\\u0000\\u0000\\u0000\u00ab\u00bb\",\"\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\",\"\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\",\"\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\",\"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\u2205\u2208\\u0000\",\"\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\\u0000\u221a\\u207f\u00b2\u25a0\\u0000\"]}");
            FontLoader loader = FontLoader.fromJson(element.getAsJsonObject(), ErrorNotifierPlatform.getResourceResolver());
            font = new Font(loader);
        }
        return font;
    }

    public void fill(int x1, int y1, int x2, int y2, int color) {
        int tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        EarlyBufferBuilder builder = new EarlyBufferBuilder("position_color", EarlyRenderFormat.POSITION_COLOR);
        float rF = ColorUtil.rF(color);
        float gF = ColorUtil.gF(color);
        float bF = ColorUtil.bF(color);
        float aF = ColorUtil.aF(color);
        builder.pos(x1, y2, 0.0f).color(rF, gF, bF, aF).endVertex();
        builder.pos(x2, y2, 0.0f).color(rF, gF, bF, aF).endVertex();
        builder.pos(x2, y1, 0.0f).color(rF, gF, bF, aF).endVertex();
        builder.pos(x1, y1, 0.0f).color(rF, gF, bF, aF).endVertex();
        builder.end(EarlyDrawType.QUAD);
        GL11.glDisable((int)3042);
    }

    public void fillGradient(int x1, int y1, int x2, int y2, int color1, int color2) {
        int tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = color1;
            color1 = color2;
            color2 = tmp;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        EarlyBufferBuilder builder = new EarlyBufferBuilder("position_color", EarlyRenderFormat.POSITION_COLOR);
        float rF1 = ColorUtil.rF(color1);
        float gF1 = ColorUtil.gF(color1);
        float bF1 = ColorUtil.bF(color1);
        float aF1 = ColorUtil.aF(color1);
        float rF2 = ColorUtil.rF(color2);
        float gF2 = ColorUtil.gF(color2);
        float bF2 = ColorUtil.bF(color2);
        float aF2 = ColorUtil.aF(color2);
        builder.pos(x1, y2, 0.0f).color(rF2, gF2, bF2, aF2).endVertex();
        builder.pos(x2, y2, 0.0f).color(rF2, gF2, bF2, aF2).endVertex();
        builder.pos(x2, y1, 0.0f).color(rF1, gF1, bF1, aF1).endVertex();
        builder.pos(x1, y1, 0.0f).color(rF1, gF1, bF1, aF1).endVertex();
        builder.end(EarlyDrawType.QUAD);
        GL11.glDisable((int)3042);
    }

    public void bindTexture(String textureId) {
        EarlyGraphics._bindTexture(this.convertToPath(textureId));
    }

    private String convertToPath(String textureId) {
        String path;
        String ns;
        int column = textureId.indexOf(58);
        if (column == -1) {
            ns = "minecraft";
            path = textureId;
        } else {
            ns = textureId.substring(0, column);
            path = textureId.substring(column + 1);
        }
        return "/assets/%s/%s".formatted(ns, path);
    }

    public boolean bindTextureCustomStream(String textureId, Supplier<InputStream> supplier) {
        return EarlyGraphics.registerTexture(this.convertToPath(textureId), supplier);
    }

    public float drawString(String string, int x, int y, int color) {
        return EarlyGraphics.getFont().draw(string, (float)x, (float)y, color, 1.0f);
    }

    public float drawStringCentered(String string, int x, int y, int color) {
        return EarlyGraphics.getFont().draw(string, (float)(x - this.width(string) / 2), (float)y, color, 1.0f);
    }

    public float drawStringWithShadow(String string, int x, int y, int color) {
        EarlyGraphics.getFont().draw(string, (float)(x + 1), (float)(y + 1), color, 0.33333334f);
        return EarlyGraphics.getFont().draw(string, (float)x, (float)y, color, 1.0f);
    }

    public float drawStringCenteredWithShadow(String string, int x, int y, int color) {
        EarlyGraphics.getFont().draw(string, (float)(x - this.width(string) / 2 + 1), (float)(y + 1), color, 0.33333334f);
        return EarlyGraphics.getFont().draw(string, (float)(x - this.width(string) / 2), (float)y, color, 1.0f);
    }

    public int width(String string) {
        return EarlyGraphics.getFont().width(string);
    }

    public List<String> splitString(String string, int width) {
        return EarlyGraphics.getFont().split(string, width);
    }

    public int getScaledWidth() {
        return (int)Math.ceil((double)EarlyWindow.framebufferWidth / EarlyWindow.scale);
    }

    public int getScaledHeight() {
        return (int)Math.ceil((double)EarlyWindow.framebufferHeight / EarlyWindow.scale);
    }

    public void innerBlit(int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, int color) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float rF = ColorUtil.rF(color);
        float gF = ColorUtil.gF(color);
        float bF = ColorUtil.bF(color);
        float aF = ColorUtil.aF(color);
        EarlyBufferBuilder builder = new EarlyBufferBuilder("position_color_tex", EarlyRenderFormat.POSITION_COLOR_TEX);
        builder.pos(x1, y2, z).color(rF, gF, bF, aF).tex(u1, v2).endVertex();
        builder.pos(x2, y2, z).color(rF, gF, bF, aF).tex(u2, v2).endVertex();
        builder.pos(x2, y1, z).color(rF, gF, bF, aF).tex(u2, v1).endVertex();
        builder.pos(x1, y1, z).color(rF, gF, bF, aF).tex(u1, v1).endVertex();
        builder.end(EarlyDrawType.QUAD);
        GL11.glDisable((int)3042);
    }

    public static void registerTexture(String name) {
        if (!textures.containsKey(name)) {
            EarlyGraphics.registerTexture(name, () -> Objects.requireNonNull(ErrorNotifierPlatform.getResourceResolver().resolve(name), name + " not found!"));
        }
    }

    public static boolean registerTexture(String name, Supplier<InputStream> stream) {
        if (!textures.containsKey(name)) {
            try {
                ImageTexture texture = new ImageTexture(Image.load(stream.get()));
                EarlyGraphics.registerTexture(name, texture);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load texture " + name, (Throwable)e);
                return false;
            }
        }
        EarlyGraphics._bindTexture(name);
        return true;
    }

    public static void registerTexture(String name, Texture texture) {
        if (!textures.containsKey(name)) {
            texture.upload(false, false);
            textures.put(name, texture);
        }
    }

    public static void _bindTexture(String name) {
        EarlyGraphics.registerTexture(name);
        GL11.glBindTexture((int)3553, (int)textures.get(name).getId());
    }

    static {
        LOGGER = LogManager.getLogger(EarlyGraphics.class);
        textures = new HashMap<String, Texture>();
    }

    public static class Font {
        private final List<FontTexture> textures = Lists.newArrayList();
        private final FontLoader loader;
        private final Int2ObjectMap<BakedGlyph> glyphs = new Int2ObjectOpenHashMap();
        private static final Glyph SPACE_GLYPH = new Glyph(){

            @Override
            public float getOversample() {
                return 1.0f;
            }

            @Override
            public int getPixelWidth() {
                return 4;
            }

            @Override
            public int getPixelHeight() {
                return 0;
            }

            @Override
            public float getAdvance() {
                return 4.0f;
            }

            @Override
            public void upload(int id, int xOffset, int yOffset, Image out) {
            }

            @Override
            public boolean isColored() {
                return true;
            }
        };

        public Font(FontLoader loader) {
            this.loader = loader;
        }

        public float draw(String text, float x, float y, int color, float dimFactor) {
            float[] xx = new float[]{x};
            text.codePoints().forEach(value -> {
                xx[0] = xx[0] + this.draw(xx[0], y, color, dimFactor, value);
            });
            return xx[0] - x;
        }

        public int width(String text) {
            return (int)Math.ceil(text.codePoints().mapToDouble(this::width).sum());
        }

        public float draw(float x, float y, int color, float dimFactor, int codepoint) {
            return this.draw(x, y, ColorUtil.rF(color), ColorUtil.gF(color), ColorUtil.bF(color), ColorUtil.aF(color), dimFactor, codepoint);
        }

        public List<String> split(String text, int width) {
            ArrayList parts = Lists.newArrayList();
            text.codePoints().forEach(value -> {
                String part = parts.isEmpty() ? "" : (String)parts.get(parts.size() - 1);
                Object newPart = part + new String(new int[]{value}, 0, 1);
                if (this.width((String)newPart) > width || parts.isEmpty()) {
                    parts.add("");
                    newPart = new String(new int[]{value}, 0, 1);
                }
                parts.set(parts.size() - 1, newPart);
            });
            return parts;
        }

        public float draw(float x, float y, float r, float g, float b, float a, float dimFactor, int codepoint) {
            Glyph glyph = this.getRawGlyph(codepoint);
            BakedGlyph bakedGlyph = this.getGlyph(codepoint);
            this.renderChar(bakedGlyph, false, x, y, r *= dimFactor, g *= dimFactor, b *= dimFactor, a);
            return glyph.getAdvance();
        }

        public float width(int codepoint) {
            Glyph glyph = this.getRawGlyph(codepoint);
            return glyph.getAdvance();
        }

        void renderChar(BakedGlyph bakedGlyph, boolean italic, float x, float y, float r, float g, float b, float a) {
            bakedGlyph.render(italic, x, y, r, g, b, a);
        }

        public Glyph getRawGlyph(int i) {
            if (i == 32) {
                return SPACE_GLYPH;
            }
            Glyph glyph = this.loader.getGlyph(i);
            return glyph == null ? MissingGlyph.INSTANCE : glyph;
        }

        public BakedGlyph getGlyph(int i) {
            return (BakedGlyph)this.glyphs.computeIfAbsent(i, ix -> this.stitch(this.getRawGlyph(ix)));
        }

        private BakedGlyph stitch(Glyph glyph) {
            FontTexture fontTexture;
            BakedGlyph bakedGlyph;
            Iterator<FontTexture> var2 = this.textures.iterator();
            do {
                if (var2.hasNext()) continue;
                String newId = "font/" + System.identityHashCode(this) + "/" + this.textures.size();
                FontTexture fontTexture2 = new FontTexture(newId, glyph.isColored());
                this.textures.add(fontTexture2);
                EarlyGraphics.registerTexture(newId, fontTexture2);
                BakedGlyph bakedGlyph2 = fontTexture2.add(glyph);
                return bakedGlyph2 == null ? this.stitch(MissingGlyph.INSTANCE) : bakedGlyph2;
            } while ((bakedGlyph = (fontTexture = var2.next()).add(glyph)) == null);
            return bakedGlyph;
        }
    }
}

