/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.fabric;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.errornotifier.ErrorNotifierPlatform;
import me.shedaniel.errornotifier.api.ErrorProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.Nullable;

public class ErrorNotifierFileProvider
implements ErrorProvider {
    @Override
    public List<ErrorProvider.ErrorComponent> errors() {
        ArrayList<ErrorProvider.ErrorComponent> errors = new ArrayList<ErrorProvider.ErrorComponent>();
        List<Map.Entry<String, Path>> files = ErrorNotifierPlatform.findAllErrorNotifierFiles();
        Gson gson = new GsonBuilder().setLenient().create();
        for (Map.Entry<String, Path> entry : files) {
            Path file = entry.getValue();
            try {
                BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                try {
                    JsonElement element = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                    if (!element.isJsonObject()) {
                        throw new IllegalStateException("Invalid error file: %s! Expected JSON object, got: %s".formatted(file, element.toString()));
                    }
                    JsonObject object = element.getAsJsonObject();
                    if (!object.has("schemaVersion")) {
                        throw new IllegalStateException("Invalid error file: %s! Expected schemaVersion, got: %s".formatted(file, object.toString()));
                    }
                    int schemaVersion = object.getAsJsonPrimitive("schemaVersion").getAsInt();
                    if (schemaVersion != 1) {
                        throw new IllegalStateException("Invalid error file: %s! Expected schemaVersion 1, got: %s".formatted(file, schemaVersion));
                    }
                    Format format = (Format)gson.fromJson((JsonElement)object, Format.class);
                    block16: for (Check check : format.checks()) {
                        List<Object> versions = check.versions();
                        if (versions instanceof String) {
                            versions = List.of(versions);
                        } else if (!(versions instanceof Collection)) {
                            throw new IllegalStateException("Invalid error file: %s! Expected versions to be a string or collection, got: %s".formatted(file, versions.getClass()));
                        }
                        if (check.modId() == null) {
                            throw new IllegalStateException("Invalid error file: %s! Expected modId, got: %s".formatted(file, check.modId()));
                        }
                        Collection predicates = VersionPredicate.parse((Collection)versions);
                        Optional containerOptional = FabricLoader.getInstance().getModContainer(check.modId());
                        switch (check.type()) {
                            case "depends": {
                                if (containerOptional.isEmpty()) {
                                    errors.add(this.missingDependency(check.modId(), (String)MoreObjects.firstNonNull((Object)check.modName(), (Object)check.modId()), entry.getKey(), check.url()));
                                    break;
                                }
                                boolean found = false;
                                for (VersionPredicate predicate : predicates) {
                                    if (!predicate.test((Object)((ModContainer)containerOptional.get()).getMetadata().getVersion())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue block16;
                                errors.add(this.wrongVersion(check.modId(), (String)MoreObjects.firstNonNull((Object)check.modName(), (Object)((ModContainer)containerOptional.get()).getMetadata().getName()) + " " + ((ModContainer)containerOptional.get()).getMetadata().getVersion().getFriendlyString(), entry.getKey(), (Collection<String>)versions, check.url()));
                                break;
                            }
                            case "breaks": {
                                if (!containerOptional.isPresent()) continue block16;
                                boolean found = false;
                                for (VersionPredicate predicate : predicates) {
                                    if (!predicate.test((Object)((ModContainer)containerOptional.get()).getMetadata().getVersion())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue block16;
                                errors.add(this.breaksVersion(check.modId(), (String)MoreObjects.firstNonNull((Object)check.modName(), (Object)((ModContainer)containerOptional.get()).getMetadata().getName()) + " " + ((ModContainer)containerOptional.get()).getMetadata().getVersion().getFriendlyString(), entry.getKey(), (Collection<String>)versions, check.url()));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid error file: %s! Unknown check type: %s".formatted(file, check.type()));
                            }
                        }
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return errors;
    }

    private ErrorProvider.ErrorComponent missingDependency(String id, String name, String requestingMod, String url) {
        return new ErrorProvider.ErrorComponent(ErrorProvider.MessageComponent.of("%s is a required dependency of %s but it is not installed!".formatted(name, requestingMod)), url);
    }

    private ErrorProvider.ErrorComponent wrongVersion(String id, String name, String requestingMod, Collection<String> versions, String url) {
        StringBuilder versionString = new StringBuilder();
        int i = 0;
        for (String version : versions) {
            if (i == versions.size() - 1 && versions.size() > 1) {
                versionString.append(" or ");
            } else if (i != 0) {
                versionString.append(", ");
            }
            versionString.append('\'').append(version).append('\'');
            ++i;
        }
        return new ErrorProvider.ErrorComponent(ErrorProvider.MessageComponent.of("%s is an unsupported version of %s! Please use %s!".formatted(name, requestingMod, versionString.toString())), url);
    }

    private ErrorProvider.ErrorComponent breaksVersion(String id, String name, String requestingMod, Collection<String> versions, String url) {
        StringBuilder versionString = new StringBuilder();
        int i = 0;
        for (String version : versions) {
            if (i == versions.size() - 1 && versions.size() > 1) {
                versionString.append(" and ");
            } else if (i != 0) {
                versionString.append(", ");
            }
            versionString.append('\'').append(version).append('\'');
            ++i;
        }
        return new ErrorProvider.ErrorComponent(ErrorProvider.MessageComponent.of("%s is an unsupported version of %s! Please avoid %s!".formatted(name, requestingMod, versionString.toString())), url);
    }

    private static final class Format {
        private List<Check> checks;

        private Format() {
        }

        public List<Check> checks() {
            return this.checks;
        }
    }

    private static final class Check {
        private String type;
        private String modId;
        @Nullable
        private String modName;
        private Object versions;
        @Nullable
        private String url;

        private Check() {
        }

        public String type() {
            return this.type;
        }

        public String modId() {
            return this.modId;
        }

        @Nullable
        public String modName() {
            return this.modName;
        }

        public Object versions() {
            return this.versions;
        }

        @Nullable
        public String url() {
            return this.url;
        }
    }
}

