/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class NBTHelper {
    public static void putMarker(class_2487 nbt, String marker) {
        nbt.method_10556(marker, true);
    }

    public static <T extends Enum<?>> T readEnum(class_2487 nbt, String key, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        }
        if (nbt.method_10573(key, 8)) {
            String name = nbt.method_10558(key);
            for (Enum t : enumConstants) {
                if (!t.name().equals(name)) continue;
                return (T)t;
            }
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> void writeEnum(class_2487 nbt, String key, T enumConstant) {
        nbt.method_10582(key, enumConstant.name());
    }

    public static <T> class_2499 writeCompoundList(Iterable<T> list, Function<T, class_2487> serializer) {
        class_2499 listNBT = new class_2499();
        list.forEach(t -> {
            class_2487 apply = (class_2487)serializer.apply(t);
            if (apply == null) {
                return;
            }
            listNBT.add((Object)apply);
        });
        return listNBT;
    }

    public static <T> List<T> readCompoundList(class_2499 listNBT, Function<class_2487, T> deserializer) {
        ArrayList list = new ArrayList(listNBT.size());
        listNBT.forEach(inbt -> list.add(deserializer.apply((class_2487)inbt)));
        return list;
    }

    public static <T> void iterateCompoundList(class_2499 listNBT, Consumer<class_2487> consumer) {
        listNBT.forEach(inbt -> consumer.accept((class_2487)inbt));
    }

    public static class_2499 writeItemList(Iterable<class_1799> stacks) {
        return NBTHelper.writeCompoundList(stacks, NBTSerializer::serializeNBTCompound);
    }

    public static List<class_1799> readItemList(class_2499 stacks) {
        return NBTHelper.readCompoundList(stacks, class_1799::method_7915);
    }

    public static class_2499 writeAABB(class_238 bb) {
        class_2499 bbtag = new class_2499();
        bbtag.add((Object)class_2494.method_23244((float)((float)bb.field_1323)));
        bbtag.add((Object)class_2494.method_23244((float)((float)bb.field_1322)));
        bbtag.add((Object)class_2494.method_23244((float)((float)bb.field_1321)));
        bbtag.add((Object)class_2494.method_23244((float)((float)bb.field_1320)));
        bbtag.add((Object)class_2494.method_23244((float)((float)bb.field_1325)));
        bbtag.add((Object)class_2494.method_23244((float)((float)bb.field_1324)));
        return bbtag;
    }

    public static class_238 readAABB(class_2499 bbtag) {
        if (bbtag == null || bbtag.isEmpty()) {
            return null;
        }
        return new class_238((double)bbtag.method_10604(0), (double)bbtag.method_10604(1), (double)bbtag.method_10604(2), (double)bbtag.method_10604(3), (double)bbtag.method_10604(4), (double)bbtag.method_10604(5));
    }

    public static class_2499 writeVec3i(class_2382 vec) {
        class_2499 tag = new class_2499();
        tag.add((Object)class_2497.method_23247((int)vec.method_10263()));
        tag.add((Object)class_2497.method_23247((int)vec.method_10264()));
        tag.add((Object)class_2497.method_23247((int)vec.method_10260()));
        return tag;
    }

    public static class_2382 readVec3i(class_2499 tag) {
        return new class_2382(tag.method_10600(0), tag.method_10600(1), tag.method_10600(2));
    }

    @Nonnull
    public static class_2520 getINBT(class_2487 nbt, String id) {
        class_2520 inbt = nbt.method_10580(id);
        if (inbt != null) {
            return inbt;
        }
        return new class_2487();
    }
}

