/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public abstract class CapManipulationBehaviourBase<T, S extends CapManipulationBehaviourBase<?, ?>>
extends TileEntityBehaviour {
    protected InterfaceProvider target;
    protected Storage<T> targetCapability;
    protected boolean simulateNext;
    protected boolean bypassSided;
    private boolean findNewNextTick;

    public CapManipulationBehaviourBase(SmartTileEntity te, InterfaceProvider target) {
        super(te);
        this.setLazyTickRate(5);
        this.target = target;
        this.targetCapability = null;
        this.simulateNext = false;
        this.bypassSided = false;
    }

    protected abstract Class<T> capability();

    @Override
    public void initialize() {
        super.initialize();
        this.findNewNextTick = true;
    }

    @Override
    public void onNeighborChanged(class_2338 neighborPos) {
        BlockFace targetBlockFace = this.target.getTarget(this.getWorld(), this.tileEntity.method_11016(), this.tileEntity.method_11010());
        if (targetBlockFace.getConnectedPos().equals((Object)neighborPos)) {
            this.onHandlerInvalidated(this.targetCapability);
        }
    }

    public S bypassSidedness() {
        this.bypassSided = true;
        return (S)this;
    }

    public S simulate() {
        this.simulateNext = true;
        return (S)this;
    }

    public boolean hasInventory() {
        return this.targetCapability != null;
    }

    @Nullable
    public Storage<T> getInventory() {
        return this.targetCapability;
    }

    protected void onHandlerInvalidated(Storage<T> handler) {
        this.findNewNextTick = true;
        this.targetCapability = null;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.targetCapability == null) {
            this.findNewCapability();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.findNewNextTick || this.getWorld().method_8510() % 64L == 0L) {
            this.findNewNextTick = false;
            this.findNewCapability();
        }
    }

    public int getAmountFromFilter() {
        int amount = -1;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null && !filter.anyAmount()) {
            amount = filter.getAmount();
        }
        return amount;
    }

    public void findNewCapability() {
        class_1937 world = this.getWorld();
        BlockFace targetBlockFace = this.target.getTarget(world, this.tileEntity.method_11016(), this.tileEntity.method_11010()).getOpposite();
        class_2338 pos = targetBlockFace.getPos();
        this.targetCapability = null;
        if (!world.method_8477(pos)) {
            return;
        }
        class_2586 invTE = world.method_8321(pos);
        if (invTE == null) {
            return;
        }
        Class<T> capability = this.capability();
        this.targetCapability = this.bypassSided ? TransferUtil.getStorage((class_2586)invTE, null, capability) : TransferUtil.getStorage((class_2586)invTE, (class_2350)targetBlockFace.getFace(), capability);
    }

    @FunctionalInterface
    public static interface InterfaceProvider {
        public static InterfaceProvider towardBlockFacing() {
            return (w, p, s) -> new BlockFace(p, s.method_28498((class_2769)class_2741.field_12525) ? (class_2350)s.method_11654((class_2769)class_2741.field_12525) : (class_2350)s.method_11654((class_2769)class_2741.field_12481));
        }

        public static InterfaceProvider oppositeOfBlockFacing() {
            return (w, p, s) -> new BlockFace(p, (s.method_28498((class_2769)class_2741.field_12525) ? (class_2350)s.method_11654((class_2769)class_2741.field_12525) : (class_2350)s.method_11654((class_2769)class_2741.field_12481)).method_10153());
        }

        public BlockFace getTarget(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

