/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.fabric.model.CullingBakedModel;
import com.jozufozu.flywheel.fabric.model.FabricModelUtil;
import com.jozufozu.flywheel.fabric.model.LayerFilteringBakedModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5558;
import net.minecraft.class_776;
import net.minecraft.class_778;

public class WorldSectionElement
extends AnimatedSceneElement {
    public static final SuperByteBufferCache.Compartment<Pair<Integer, Integer>> DOC_WORLD_SECTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    List<class_2586> renderedTileEntities;
    List<Pair<class_2586, Consumer<class_1937>>> tickableTileEntities;
    Selection section;
    boolean redraw;
    class_243 prevAnimatedOffset = class_243.field_1353;
    class_243 animatedOffset = class_243.field_1353;
    class_243 prevAnimatedRotation = class_243.field_1353;
    class_243 animatedRotation = class_243.field_1353;
    class_243 centerOfRotation = class_243.field_1353;
    class_243 stabilizationAnchor = null;
    class_2338 selectedBlock;

    public WorldSectionElement() {
    }

    public WorldSectionElement(Selection section) {
        this.section = section.copy();
        this.centerOfRotation = section.getCenter();
    }

    public void mergeOnto(WorldSectionElement other) {
        this.setVisible(false);
        if (other.isEmpty()) {
            other.set(this.section);
        } else {
            other.add(this.section);
        }
    }

    public void set(Selection selection) {
        this.applyNewSelection(selection.copy());
    }

    public void add(Selection toAdd) {
        this.applyNewSelection(this.section.add(toAdd));
    }

    public void erase(Selection toErase) {
        this.applyNewSelection(this.section.substract(toErase));
    }

    private void applyNewSelection(Selection selection) {
        this.section = selection;
        this.queueRedraw();
    }

    public void setCenterOfRotation(class_243 center) {
        this.centerOfRotation = center;
    }

    public void stabilizeRotation(class_243 anchor) {
        this.stabilizationAnchor = anchor;
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.resetAnimatedTransform();
        this.resetSelectedBlock();
    }

    public void selectBlock(class_2338 pos) {
        this.selectedBlock = pos;
    }

    public void resetSelectedBlock() {
        this.selectedBlock = null;
    }

    public void resetAnimatedTransform() {
        this.prevAnimatedOffset = class_243.field_1353;
        this.animatedOffset = class_243.field_1353;
        this.prevAnimatedRotation = class_243.field_1353;
        this.animatedRotation = class_243.field_1353;
    }

    public void queueRedraw() {
        this.redraw = true;
    }

    public boolean isEmpty() {
        return this.section == null;
    }

    public void setEmpty() {
        this.section = null;
    }

    public void setAnimatedRotation(class_243 eulerAngles, boolean force) {
        this.animatedRotation = eulerAngles;
        if (force) {
            this.prevAnimatedRotation = this.animatedRotation;
        }
    }

    public class_243 getAnimatedRotation() {
        return this.animatedRotation;
    }

    public void setAnimatedOffset(class_243 offset, boolean force) {
        this.animatedOffset = offset;
        if (force) {
            this.prevAnimatedOffset = this.animatedOffset;
        }
    }

    public class_243 getAnimatedOffset() {
        return this.animatedOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.isEmpty();
    }

    public Pair<class_243, class_2338> rayTrace(PonderWorld world, class_243 source, class_243 target) {
        world.setMask(this.section);
        class_243 transformedTarget = this.reverseTransformVec(target);
        class_3965 rayTraceBlocks = world.method_17742(new class_3959(this.reverseTransformVec(source), transformedTarget, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, null));
        world.clearMask();
        if (rayTraceBlocks == null) {
            return null;
        }
        if (rayTraceBlocks.method_17784() == null) {
            return null;
        }
        double t = rayTraceBlocks.method_17784().method_1020(transformedTarget).method_1027() / source.method_1020(target).method_1027();
        class_243 actualHit = VecHelper.lerp((float)t, target, source);
        return Pair.of(actualHit, rayTraceBlocks.method_17777());
    }

    private class_243 reverseTransformVec(class_243 in) {
        float pt = AnimationTickHolder.getPartialTicks();
        in = in.method_1020(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)class_243.field_1353) || !this.prevAnimatedRotation.equals((Object)class_243.field_1353)) {
            if (this.centerOfRotation == null) {
                this.centerOfRotation = this.section.getCenter();
            }
            double rotX = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1352, (double)this.animatedRotation.field_1352);
            double rotZ = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1350, (double)this.animatedRotation.field_1350);
            double rotY = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1351, (double)this.animatedRotation.field_1351);
            in = in.method_1020(this.centerOfRotation);
            in = VecHelper.rotate(in, -rotX, class_2350.class_2351.field_11048);
            in = VecHelper.rotate(in, -rotZ, class_2350.class_2351.field_11051);
            in = VecHelper.rotate(in, -rotY, class_2350.class_2351.field_11052);
            in = in.method_1019(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                in = in.method_1020(this.stabilizationAnchor);
                in = VecHelper.rotate(in, rotX, class_2350.class_2351.field_11048);
                in = VecHelper.rotate(in, rotZ, class_2350.class_2351.field_11051);
                in = VecHelper.rotate(in, rotY, class_2350.class_2351.field_11052);
                in = in.method_1019(this.stabilizationAnchor);
            }
        }
        return in;
    }

    public void transformMS(class_4587 ms, float pt) {
        TransformStack.cast((class_4587)ms).translate(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)class_243.field_1353) || !this.prevAnimatedRotation.equals((Object)class_243.field_1353)) {
            if (this.centerOfRotation == null) {
                this.centerOfRotation = this.section.getCenter();
            }
            double rotX = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1352, (double)this.animatedRotation.field_1352);
            double rotZ = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1350, (double)this.animatedRotation.field_1350);
            double rotY = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1351, (double)this.animatedRotation.field_1351);
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)ms).translate(this.centerOfRotation)).rotateX(rotX)).rotateZ(rotZ)).rotateY(rotY)).translateBack(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)ms).translate(this.stabilizationAnchor)).rotateX(-rotX)).rotateZ(-rotZ)).rotateY(-rotY)).translateBack(this.stabilizationAnchor);
            }
        }
    }

    @Override
    public void tick(PonderScene scene) {
        this.prevAnimatedOffset = this.animatedOffset;
        this.prevAnimatedRotation = this.animatedRotation;
        if (!this.isVisible()) {
            return;
        }
        this.loadTEsIfMissing(scene.getWorld());
        this.renderedTileEntities.removeIf(te -> scene.getWorld().method_8321(te.method_11016()) != te);
        this.tickableTileEntities.removeIf(te -> scene.getWorld().method_8321(((class_2586)te.getFirst()).method_11016()) != te.getFirst());
        this.tickableTileEntities.forEach(te -> ((Consumer)te.getSecond()).accept(scene.getWorld()));
    }

    @Override
    public void whileSkipping(PonderScene scene) {
        if (this.redraw) {
            this.renderedTileEntities = null;
            this.tickableTileEntities = null;
        }
        this.redraw = false;
    }

    protected void loadTEsIfMissing(PonderWorld world) {
        if (this.renderedTileEntities != null) {
            return;
        }
        this.tickableTileEntities = new ArrayList<Pair<class_2586, Consumer<class_1937>>>();
        this.renderedTileEntities = new ArrayList<class_2586>();
        this.section.forEach(pos -> {
            class_2586 tileEntity = world.method_8321((class_2338)pos);
            class_2680 blockState = world.method_8320((class_2338)pos);
            class_2248 block = blockState.method_26204();
            if (tileEntity == null) {
                return;
            }
            if (!(block instanceof class_2343)) {
                return;
            }
            tileEntity.method_31664(world.method_8320((class_2338)pos));
            class_5558 ticker = ((class_2343)block).method_31645((class_1937)world, blockState, tileEntity.method_11017());
            if (ticker != null) {
                this.addTicker(tileEntity, ticker);
            }
            this.renderedTileEntities.add(tileEntity);
        });
    }

    private <T extends class_2586> void addTicker(T tileEntity, class_5558<?> ticker) {
        this.tickableTileEntities.add(Pair.of(tileEntity, w -> ticker.tick(w, tileEntity.method_11016(), tileEntity.method_11010(), tileEntity)));
    }

    @Override
    public void renderFirst(PonderWorld world, class_4597 buffer, class_4587 ms, float fade, float pt) {
        int light = -1;
        if (fade != 1.0f) {
            light = (int)class_3532.method_16439((float)fade, (float)5.0f, (float)14.0f);
        }
        if (this.redraw) {
            this.renderedTileEntities = null;
            this.tickableTileEntities = null;
        }
        ms.method_22903();
        this.transformMS(ms, pt);
        world.pushFakeLight(light);
        this.renderTileEntities(world, ms, buffer, pt);
        world.popLight();
        Map<class_2338, Integer> blockBreakingProgressions = world.getBlockBreakingProgressions();
        class_4587 overlayMS = null;
        class_776 renderer = class_310.method_1551().method_1541();
        for (Map.Entry<class_2338, Integer> entry : blockBreakingProgressions.entrySet()) {
            class_2338 pos = entry.getKey();
            if (!this.section.test(pos)) continue;
            if (overlayMS == null) {
                overlayMS = new class_4587();
                overlayMS.method_23760().method_23761().method_35434(ms.method_23760().method_23761());
                overlayMS.method_23760().method_23762().method_22852(ms.method_23760().method_23762());
                float scaleFactor = world.scene.getScaleFactor();
                float f = (float)Math.pow(30.0f * scaleFactor, -1.2);
                overlayMS.method_22905(f, f, f);
            }
            class_4583 builder = new class_4583(buffer.getBuffer((class_1921)class_1088.field_21772.get(entry.getValue())), overlayMS.method_23760().method_23761(), overlayMS.method_23760().method_23762());
            ms.method_22903();
            ms.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            renderer.method_23071(world.method_8320(pos), pos, (class_1920)world, ms, (class_4588)builder);
            ms.method_22909();
        }
        ms.method_22909();
    }

    @Override
    protected void renderLayer(PonderWorld world, class_4597 buffer, class_1921 type, class_4587 ms, float fade, float pt) {
        SuperByteBuffer contraptionBuffer;
        SuperByteBufferCache bufferCache = CreateClient.BUFFER_CACHE;
        int code = this.hashCode() ^ ((Object)((Object)world)).hashCode();
        Pair<Integer, Integer> key = Pair.of(code, class_1921.method_22720().indexOf(type));
        if (this.redraw) {
            bufferCache.invalidate(DOC_WORLD_SECTION, key);
        }
        if ((contraptionBuffer = bufferCache.get(DOC_WORLD_SECTION, key, () -> this.buildStructureBuffer(world, type))).isEmpty()) {
            return;
        }
        this.transformMS(contraptionBuffer.getTransforms(), pt);
        int light = this.lightCoordsFromFade(fade);
        contraptionBuffer.light(light).renderInto(ms, buffer.getBuffer(type));
    }

    @Override
    protected void renderLast(PonderWorld world, class_4597 buffer, class_4587 ms, float fade, float pt) {
        this.redraw = false;
        if (this.selectedBlock == null) {
            return;
        }
        class_2680 blockState = world.method_8320(this.selectedBlock);
        if (blockState.method_26215()) {
            return;
        }
        class_265 shape = blockState.method_26172((class_1922)world, this.selectedBlock, class_3726.method_16195((class_1297)class_310.method_1551().field_1724));
        if (shape.method_1110()) {
            return;
        }
        ms.method_22903();
        this.transformMS(ms, pt);
        ms.method_22904((double)this.selectedBlock.method_10263(), (double)this.selectedBlock.method_10264(), (double)this.selectedBlock.method_10260());
        AABBOutline aabbOutline = new AABBOutline(shape.method_1107());
        aabbOutline.getParams().lineWidth(0.015625f).colored(0xEFEFEF).disableNormals();
        aabbOutline.render(ms, (SuperRenderTypeBuffer)buffer, pt);
        ms.method_22909();
    }

    private void renderTileEntities(PonderWorld world, class_4587 ms, class_4597 buffer, float pt) {
        this.loadTEsIfMissing(world);
        TileEntityRenderHelper.renderTileEntities(world, this.renderedTileEntities, ms, buffer, pt);
    }

    private SuperByteBuffer buildStructureBuffer(PonderWorld world, class_1921 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        Random random = objects.random;
        ShadeSeparatingVertexConsumer shadeSeparatingWrapper = objects.shadeSeparatingWrapper;
        ShadeSeparatedBufferBuilder builder = new ShadeSeparatedBufferBuilder(512);
        class_287 unshadedBuilder = objects.unshadedBuilder;
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        unshadedBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        shadeSeparatingWrapper.prepare((class_4588)builder, (class_4588)unshadedBuilder);
        world.setMask(this.section);
        class_778.method_20544();
        this.section.forEach(pos -> {
            class_2680 state = world.method_8320((class_2338)pos);
            class_3610 fluidState = world.method_8316((class_2338)pos);
            poseStack.method_22903();
            poseStack.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (state.method_26217() == class_2464.field_11458) {
                class_1087 model = dispatcher.method_3349(state);
                if (((FabricBakedModel)model).isVanillaAdapter()) {
                    if (!FabricModelUtil.doesLayerMatch((class_2680)state, (class_1921)layer)) {
                        model = null;
                    }
                } else {
                    model = CullingBakedModel.wrap((class_1087)model);
                    model = LayerFilteringBakedModel.wrap((class_1087)model, (class_1921)layer);
                }
                if (model != null) {
                    model = shadeSeparatingWrapper.wrapModel(model);
                    dispatcher.method_3350().method_3374((class_1920)world, model, state, pos, poseStack, (class_4588)shadeSeparatingWrapper, true, random, state.method_26190(pos), class_4608.field_21444);
                }
            }
            if (!fluidState.method_15769() && class_4696.method_23680((class_3610)fluidState) == layer) {
                dispatcher.method_3352(pos, (class_1920)world, (class_4588)builder, state, fluidState);
            }
            poseStack.method_22909();
        });
        class_778.method_20545();
        world.clearMask();
        shadeSeparatingWrapper.clear();
        unshadedBuilder.method_1326();
        builder.appendUnshadedVertices(unshadedBuilder);
        builder.method_1326();
        return new SuperByteBuffer((class_287)builder);
    }

    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final Random random = new Random();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final class_287 unshadedBuilder = new class_287(512);

        private ThreadLocalObjects() {
        }
    }

    class WorldSectionRayTraceResult {
        class_243 actualHitVec;
        class_2338 worldPos;

        WorldSectionRayTraceResult() {
        }
    }
}

