/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.curiosities.tools.SandPaperItem;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.BeltItemElement;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class DeployerScenes {
    public static void filter(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer", "Using the Deployer");
        scene.configureBasePlate(0, 0, 5);
        class_2338 potPosition = util.grid.at(1, 1, 2);
        class_2338 deployerPos = util.grid.at(3, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.setBlock(potPosition, class_2246.field_10124.method_9564(), false);
        scene.world.showSection(util.select.layer(0).add(util.select.position(1, 1, 2)), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 3, 1, 5), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(deployerSelection, class_2350.field_11035);
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.topOf(deployerPos)).text("Given Rotational Force, a Deployer can imitate player interactions");
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(44);
        scene.overlay.showSelectionWithText(util.select.position(deployerPos.method_10088(2)), 60).text("It will always interact with the position 2 blocks in front of itself").attachKeyFrame().placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame();
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(20);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 1), class_2350.field_11033);
        scene.idle(24);
        scene.overlay.showText(50).pointAt(util.vector.topOf(deployerPos.method_10067())).text("Blocks directly in front will not obstruct it").placeNearTarget();
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(34);
        scene.world.hideSection(util.select.fromTo(2, 1, 3, 2, 1, 1), class_2350.field_11036);
        scene.idle(20);
        String[] actions = new String[]{"Place Blocks,", "Use Items,", "Activate Blocks,", "Harvest blocks", "and Attack Mobs"};
        scene.overlay.showText(80).attachKeyFrame().independent(40).placeNearTarget().text("Deployers can:");
        int y = 60;
        for (String s : actions) {
            scene.idle(15);
            scene.overlay.showText(50).colored(PonderPalette.MEDIUM).placeNearTarget().independent(y).text(s);
            y += 16;
        }
        scene.idle(50);
        class_1799 pot = new class_1799((class_1935)class_1802.field_8074);
        class_243 frontVec = util.vector.blockSurface(deployerPos, class_2350.field_11039).method_1031(-0.125, 0.0, 0.0);
        scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.DOWN).rightClick().withItem(pot), 40);
        scene.idle(7);
        Class<DeployerTileEntity> teType = DeployerTileEntity.class;
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)pot)));
        scene.idle(10);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().pointAt(frontVec).text("Right-click the front to give it an Item to use");
        scene.idle(40);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.restoreBlocks(util.select.position(potPosition));
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)class_1799.field_8037)));
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(20);
        scene.world.showSection(util.select.position(deployerPos.method_10084()), class_2350.field_11033);
        class_1799 tulip = new class_1799((class_1935)class_1802.field_17502);
        class_243 entitySpawn = util.vector.topOf(deployerPos.method_10086(3));
        ElementLink<EntityElement> entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), tulip);
        scene.idle(17);
        scene.world.modifyEntity(entity1, class_1297::method_31472);
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)tulip)));
        scene.idle(10);
        scene.overlay.showText(40).placeNearTarget().pointAt(util.vector.of(3.0, 2.5, 3.0)).text("Items can also be inserted automatically");
        scene.idle(30);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.setBlock(potPosition, class_2246.field_10598.method_9564(), false);
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)class_1799.field_8037)));
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(25);
        scene.world.hideSection(util.select.position(potPosition), class_2350.field_11036);
        scene.world.hideSection(util.select.position(deployerPos.method_10084()), class_2350.field_11034);
        scene.idle(20);
        class_243 filterSlot = frontVec.method_1031(0.375, 0.25, 0.0);
        scene.overlay.showFilterSlotInput(filterSlot, 80);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("Deployers carry a filter slot");
        scene.idle(50);
        class_1799 shears = new class_1799((class_1935)class_1802.field_8868);
        scene.overlay.showControls(new InputWindowElement(filterSlot, Pointing.DOWN).rightClick().withItem(shears), 40);
        scene.idle(7);
        scene.world.setFilterData(deployerSelection, teType, shears);
        scene.overlay.showText(60).placeNearTarget().pointAt(filterSlot).text("When a filter is set, it activates only while holding a matching item");
        scene.idle(70);
        ElementLink<EntityElement> sheep = scene.world.createEntity(w -> {
            class_1472 entity = (class_1472)class_1299.field_6115.method_5883(w);
            entity.method_6631(class_1767.field_7954);
            class_243 p = util.vector.topOf(util.grid.at(1, 0, 2));
            entity.method_5814(p.field_1352, p.field_1351, p.field_1350);
            entity.field_6014 = p.field_1352;
            entity.field_6036 = p.field_1351;
            entity.field_5969 = p.field_1350;
            entity.field_6249 = 0.0f;
            entity.field_5982 = 210.0f;
            entity.method_36456(210.0f);
            entity.field_6259 = 210.0f;
            entity.field_6241 = 210.0f;
            return entity;
        });
        scene.idle(20);
        scene.world.showSection(util.select.position(deployerPos.method_10084()), class_2350.field_11039);
        entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), shears);
        scene.idle(17);
        scene.world.modifyEntity(entity1, class_1297::method_31472);
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)shears)));
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.of(3.0, 2.5, 3.0)).text("Only items matching the filter can now be inserted...");
        scene.idle(70);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.modifyEntity(sheep, e -> ((class_1472)e).method_6635(true));
        scene.effects.emitParticles(util.vector.topOf(deployerPos.method_10088(2)).method_1031(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace(new class_2388(class_2398.field_11217, class_2246.field_10459.method_9564()), util.vector.of(0.0, 0.0, 0.0)), 25.0f, 1);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.world.showSection(util.select.position(deployerPos.method_10095()), class_2350.field_11035);
        scene.idle(25);
        scene.overlay.showText(80).placeNearTarget().pointAt(util.vector.of(3.5, 1.25, 1.25)).text("...and only non-matching items will be extracted");
        scene.world.flapFunnel(deployerPos.method_10095(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.method_10095()).method_1023(0.0, 0.45, 0.0), util.vector.of(0.0, 0.0, -0.1), new class_1799((class_1935)class_1802.field_19050));
        scene.markAsFinished();
        for (int i = 0; i < 10; ++i) {
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, 1.0f, 25);
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, -1.0f, 25);
            scene.idle(26);
        }
    }

    public static void modes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_modes", "Modes of the Deployer");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 3, 1, 5), class_2350.field_11033);
        scene.idle(10);
        class_2338 deployerPos = util.grid.at(3, 1, 2);
        class_243 frontVec = util.vector.blockSurface(deployerPos, class_2350.field_11039).method_1031(-0.125, 0.0, 0.0);
        Selection grassBlock = util.select.position(1, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.showSection(deployerSelection, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(grassBlock, class_2350.field_11033);
        scene.idle(10);
        class_1799 tool = new class_1799((class_1935)class_1802.field_8303);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(deployerPos), Pointing.DOWN).withItem(tool), 30);
        scene.idle(7);
        scene.world.modifyTileNBT(deployerSelection, DeployerTileEntity.class, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)tool)));
        scene.idle(45);
        scene.world.setKineticSpeed(util.select.position(2, 0, 5), 16.0f);
        scene.world.setKineticSpeed(util.select.layer(1), -32.0f);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 2)).text("By default, a Deployer imitates a Right-click interaction");
        scene.idle(26);
        scene.world.replaceBlocks(grassBlock, class_2246.field_10362.method_9564(), false);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(46);
        scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.LEFT).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.modifyTileNBT(deployerSelection, DeployerTileEntity.class, nbt -> nbt.method_10582("Mode", "PUNCH"));
        scene.idle(45);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 2)).text("Using a Wrench, it can be set to imitate a Left-click instead");
        class_2338 breakingPos = deployerPos.method_10088(2);
        for (int i = 0; i < 4; ++i) {
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, 1.0f, 25);
            scene.idle(26);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.moveDeployer(deployerPos, -1.0f, 25);
            if (i == 3) {
                scene.world.createItemEntity(util.vector.centerOf(breakingPos), util.vector.of(0.0, 0.0, 0.0), new class_1799((class_1935)class_2246.field_10566));
            }
            scene.idle(26);
            if (i != 0) continue;
            scene.markAsFinished();
        }
    }

    public static void processing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_processing", "Processing Items using Deployers");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        ElementLink<WorldSectionElement> depot = scene.world.showIndependentSection(util.select.position(2, 1, 1), class_2350.field_11033);
        scene.world.moveSection(depot, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        Selection pressS = util.select.position(2, 3, 2);
        class_2338 pressPos = util.grid.at(2, 3, 2);
        class_2338 depotPos = util.grid.at(2, 1, 1);
        scene.world.setKineticSpeed(pressS, 0.0f);
        scene.world.showSection(pressS, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11043);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 2, 3), class_2350.field_11035);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 3, 3), class_2350.field_11043);
        scene.world.setKineticSpeed(pressS, -32.0f);
        scene.effects.indicateSuccess(pressPos);
        scene.idle(10);
        class_1799 tool = AllItems.SAND_PAPER.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(pressPos.method_10074(), class_2350.field_11034).method_1031(0.0, 0.15, 0.0), Pointing.RIGHT).withItem(tool), 30);
        scene.idle(7);
        scene.world.modifyTileNBT(pressS, DeployerTileEntity.class, nbt -> nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)tool)));
        scene.idle(25);
        class_243 pressSide = util.vector.blockSurface(pressPos, class_2350.field_11039);
        scene.overlay.showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("With a fitting held item, Deployers can process items provided beneath them");
        scene.idle(80);
        scene.overlay.showText(60).pointAt(pressSide.method_1023(0.0, 2.0, 0.0)).placeNearTarget().text("The Input items can be dropped or placed on a Depot under the Deployer");
        scene.idle(50);
        class_1799 quartz = AllItems.ROSE_QUARTZ.asStack();
        scene.world.createItemOnBeltLike(depotPos, class_2350.field_11043, quartz);
        class_243 depotCenter = util.vector.centerOf(depotPos.method_10072());
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(quartz), 30);
        scene.idle(10);
        class_243 targetV = util.vector.centerOf(pressPos).method_1023(0.0, 1.65, 0.0);
        scene.world.moveDeployer(pressPos, 1.0f, 30);
        scene.idle(30);
        scene.world.moveDeployer(pressPos, -1.0f, 30);
        scene.debug.enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world.removeItemsFromBelt(depotPos);
        class_1799 polished = AllItems.POLISHED_ROSE_QUARTZ.asStack();
        scene.world.createItemOnBeltLike(depotPos, class_2350.field_11036, polished);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(polished), 50);
        scene.idle(60);
        scene.world.hideIndependentSection(depot, class_2350.field_11043);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 0, 2, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 beltPos = util.grid.at(0, 1, 2);
        scene.overlay.showText(40).pointAt(util.vector.blockSurface(beltPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("When items are provided on a belt...");
        scene.idle(30);
        ElementLink<BeltItemElement> ingot = scene.world.createItemOnBelt(beltPos, class_2350.field_11035, quartz);
        scene.idle(15);
        ElementLink<BeltItemElement> ingot2 = scene.world.createItemOnBelt(beltPos, class_2350.field_11035, quartz);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, true);
        scene.world.moveDeployer(pressPos, 1.0f, 30);
        scene.overlay.showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Deployer will hold and process them automatically");
        scene.idle(30);
        scene.world.moveDeployer(pressPos, -1.0f, 30);
        scene.debug.enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world.removeItemsFromBelt(pressPos.method_10087(2));
        ingot = scene.world.createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, polished);
        scene.world.stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, true);
        scene.world.moveDeployer(pressPos, 1.0f, 30);
        scene.idle(30);
        scene.world.moveDeployer(pressPos, -1.0f, 30);
        scene.debug.enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world.removeItemsFromBelt(pressPos.method_10087(2));
        ingot2 = scene.world.createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, polished);
        scene.world.stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, false);
    }

    public static void redstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_redstone", "Controlling Deployers with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 5, 3, 1, 3), class_2350.field_11033);
        class_2338 deployerPos = util.grid.at(3, 1, 3);
        Selection redstone = util.select.fromTo(3, 1, 1, 3, 1, 2);
        class_2338 leverPos = util.grid.at(3, 1, 1);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(31);
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.world.showSection(redstone, class_2350.field_11035);
        scene.idle(31);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(10);
        scene.overlay.showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("When powered by Redstone, Deployers will not activate");
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(10);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(10);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(21);
        scene.overlay.showText(60).pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("Before stopping, the Deployer will finish any started cycles");
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(3);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.overlay.showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("Thus, a negative pulse can be used to trigger exactly one activation cycle");
        scene.idle(31);
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.idle(40);
    }

    public static void contraption(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_contraption", "Using Deployers on Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        Selection flowers = util.select.fromTo(4, 1, 1, 1, 1, 1);
        scene.world.replaceBlocks(flowers, class_2246.field_10124.method_9564(), false);
        Selection kinetics = util.select.fromTo(5, 1, 6, 5, 1, 3);
        class_2338 deployerPos = util.grid.at(4, 1, 3);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.showSection(util.select.layer(0).add(flowers), class_2350.field_11036);
        scene.idle(5);
        ElementLink<WorldSectionElement> pistonHead = scene.world.showIndependentSection(util.select.fromTo(5, 1, 2, 8, 1, 2), class_2350.field_11033);
        scene.world.moveSection(pistonHead, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.world.showSection(kinetics, class_2350.field_11033);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(deployerSelection, class_2350.field_11033);
        scene.idle(5);
        scene.world.glueBlockOnto(util.grid.at(4, 2, 3), class_2350.field_11033, contraption);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(deployerPos, class_2350.field_11039)).text("Whenever Deployers are moved as part of an animated Contraption...");
        scene.idle(70);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), -8.0f);
        scene.world.setKineticSpeed(kinetics, 16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(-3.0, 0.0, 0.0), 100);
        scene.world.moveSection(contraption, util.vector.of(-3.0, 0.0, 0.0), 100);
        for (int x = 0; x < 4; ++x) {
            scene.world.moveDeployer(deployerPos, 1.0f, 9);
            scene.idle(10);
            scene.world.moveDeployer(deployerPos, -1.0f, 9);
            scene.world.restoreBlocks(util.select.position(4 - x, 1, 1));
            scene.idle(18);
        }
        scene.overlay.showSelectionWithText(flowers, 90).attachKeyFrame().colored(PonderPalette.GREEN).text("They activate at each visited location, using items from inventories anywhere on the contraption");
        scene.idle(100);
        scene.world.hideSection(flowers, class_2350.field_11036);
        scene.idle(15);
        scene.world.replaceBlocks(flowers, class_2246.field_10124.method_9564(), false);
        scene.world.showSection(flowers, class_2350.field_11036);
        class_243 frontVec = util.vector.blockSurface(deployerPos.method_10088(3), class_2350.field_11043).method_1031(0.0, 0.0, -0.125);
        class_243 filterSlot = frontVec.method_1031(0.0, 0.25, 0.375);
        scene.overlay.showFilterSlotInput(filterSlot, 80);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("The Filter slot can be used to specify which items to pull");
        scene.idle(70);
        class_1799 poppy = new class_1799((class_1935)class_1802.field_8880);
        scene.overlay.showControls(new InputWindowElement(filterSlot, Pointing.DOWN).withItem(poppy), 30);
        scene.idle(7);
        scene.world.setFilterData(deployerSelection, DeployerTileEntity.class, poppy);
        scene.idle(25);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), 8.0f);
        scene.world.setKineticSpeed(kinetics, -16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(3.0, 0.0, 0.0), 100);
        scene.world.moveSection(contraption, util.vector.of(3.0, 0.0, 0.0), 100);
        for (int x = 0; x < 4; ++x) {
            scene.world.moveDeployer(deployerPos, 1.0f, 9);
            scene.idle(10);
            scene.world.moveDeployer(deployerPos, -1.0f, 9);
            scene.world.setBlock(util.grid.at(1 + x, 1, 1), class_2246.field_10449.method_9564(), false);
            scene.idle(18);
        }
    }
}

