/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.base.Suppliers;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.mixin.accessor.ParticleEngineAccessor;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorldParticles;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.IMultiTileContainer;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedClientWorld;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_898;

public class PonderWorld
extends SchematicWorld {
    public PonderScene scene;
    protected Map<class_2338, class_2680> originalBlocks;
    protected Map<class_2338, class_2586> originalTileEntities;
    protected Map<class_2338, Integer> blockBreakingProgressions;
    protected List<class_1297> originalEntities;
    private Supplier<class_638> asClientWorld = Suppliers.memoize(() -> WrappedClientWorld.of(this));
    protected PonderWorldParticles particles;
    private final Int2ObjectMap<class_707<?>> particleProviders;
    int overrideLight;
    Selection mask;

    public PonderWorld(class_2338 anchor, class_1937 original) {
        super(anchor, original);
        this.originalBlocks = new HashMap<class_2338, class_2680>();
        this.originalTileEntities = new HashMap<class_2338, class_2586>();
        this.blockBreakingProgressions = new HashMap<class_2338, Integer>();
        this.originalEntities = new ArrayList<class_1297>();
        this.particles = new PonderWorldParticles(this);
        this.particleProviders = ((ParticleEngineAccessor)class_310.method_1551().field_1713).create$getProviders();
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalTileEntities.clear();
        this.blocks.forEach((k, v) -> this.originalBlocks.put((class_2338)k, (class_2680)v));
        this.tileEntities.forEach((k, v) -> this.originalTileEntities.put((class_2338)k, class_2586.method_11005((class_2338)k, (class_2680)((class_2680)this.blocks.get(k)), (class_2487)v.method_38242())));
        this.entities.forEach(e -> class_1299.method_5892((class_2487)NBTSerializer.serializeNBTCompound((Object)e), (class_1937)this).ifPresent(this.originalEntities::add));
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.tileEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedTileEntities.clear();
        this.originalBlocks.forEach((k, v) -> this.blocks.put(k, v));
        this.originalTileEntities.forEach((k, v) -> {
            class_2586 te = class_2586.method_11005((class_2338)k, (class_2680)this.originalBlocks.get(k), (class_2487)v.method_38242());
            this.onTEadded(te, te.method_11016());
            this.tileEntities.put(k, te);
            this.renderedTileEntities.add(te);
        });
        this.originalEntities.forEach(e -> class_1299.method_5892((class_2487)NBTSerializer.serializeNBTCompound((Object)e), (class_1937)this).ifPresent(this.entities::add));
        this.particles.clearEffects();
        this.fixControllerTileEntities();
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalTileEntities.containsKey(p)) {
                class_2586 te = class_2586.method_11005((class_2338)p, (class_2680)this.originalBlocks.get(p), (class_2487)this.originalTileEntities.get(p).method_38242());
                this.onTEadded(te, te.method_11016());
                this.tileEntities.put(p, te);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int method_8314(class_1944 p_226658_1_, class_2338 p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public class_2680 method_8320(class_2338 globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.method_10059((class_2382)this.anchor))) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_8320(globalPos);
    }

    public class_1922 method_22338(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(class_4587 ms, SuperRenderTypeBuffer buffer, class_4184 ari, float pt) {
        class_243 Vector3d = ari.method_19326();
        double d0 = Vector3d.method_10216();
        double d1 = Vector3d.method_10214();
        double d2 = Vector3d.method_10215();
        for (class_1297 entity : this.entities) {
            if (entity.field_6012 == 0) {
                entity.field_6038 = entity.method_23317();
                entity.field_5971 = entity.method_23318();
                entity.field_5989 = entity.method_23321();
            }
            this.renderEntity(entity, d0, d1, d2, pt, ms, buffer);
        }
        buffer.draw(class_1921.method_23572((class_2960)class_1723.field_21668));
        buffer.draw(class_1921.method_23576((class_2960)class_1723.field_21668));
        buffer.draw(class_1921.method_23578((class_2960)class_1723.field_21668));
        buffer.draw(class_1921.method_23584((class_2960)class_1723.field_21668));
    }

    private void renderEntity(class_1297 entity, double x, double y, double z, float pt, class_4587 ms, class_4597 buffer) {
        double d0 = class_3532.method_16436((double)pt, (double)entity.field_6038, (double)entity.method_23317());
        double d1 = class_3532.method_16436((double)pt, (double)entity.field_5971, (double)entity.method_23318());
        double d2 = class_3532.method_16436((double)pt, (double)entity.field_5989, (double)entity.method_23321());
        float f = class_3532.method_16439((float)pt, (float)entity.field_5982, (float)entity.method_36454());
        class_898 renderManager = class_310.method_1551().method_1561();
        int light = renderManager.method_3953(entity).method_24088(entity, pt);
        renderManager.method_3954(entity, d0 - x, d1 - y, d2 - z, f, pt, ms, buffer, light);
    }

    public void renderParticles(class_4587 ms, class_4597 buffer, class_4184 ari, float pt) {
        this.particles.renderParticles(ms, buffer, ari, pt);
    }

    public void tick() {
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            class_1297 entity = (class_1297)iterator.next();
            ++entity.field_6012;
            entity.field_6038 = entity.method_23317();
            entity.field_5971 = entity.method_23318();
            entity.field_5989 = entity.method_23321();
            entity.method_5773();
            if (entity.method_23318() <= -0.5) {
                entity.method_31472();
            }
            if (entity.method_5805()) continue;
            iterator.remove();
        }
    }

    public void method_8406(class_2394 data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(this.makeParticle(data, x, y, z, mx, my, mz));
    }

    public void method_8494(class_2394 data, double x, double y, double z, double mx, double my, double mz) {
        this.method_8406(data, x, y, z, mx, my, mz);
    }

    @Nullable
    private <T extends class_2394> class_703 makeParticle(T data, double x, double y, double z, double mx, double my, double mz) {
        int id = class_2378.field_11141.method_10206((Object)data.method_10295());
        class_707 particleProvider = (class_707)this.particleProviders.get(id);
        return particleProvider == null ? null : particleProvider.method_3090(data, this.asClientWorld.get(), x, y, z, mx, my, mz);
    }

    @Override
    public boolean method_8652(class_2338 pos, class_2680 arg1, int arg2) {
        return super.method_8652(pos, arg1, arg2);
    }

    public void addParticle(class_703 p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    @Override
    protected void onTEadded(class_2586 tileEntity, class_2338 pos) {
        super.onTEadded(tileEntity, pos);
        if (!(tileEntity instanceof SmartTileEntity)) {
            return;
        }
        SmartTileEntity smartTileEntity = (SmartTileEntity)tileEntity;
        smartTileEntity.markVirtual();
    }

    public void fixControllerTileEntities() {
        for (class_2586 tileEntity : this.tileEntities.values()) {
            if (tileEntity instanceof BeltTileEntity) {
                BeltTileEntity beltTileEntity = (BeltTileEntity)tileEntity;
                if (!beltTileEntity.isController()) continue;
                class_2338 controllerPos = tileEntity.method_11016();
                for (class_2338 blockPos : BeltBlock.getBeltChain(this, controllerPos)) {
                    class_2586 tileEntity2 = this.method_8321(blockPos);
                    if (!(tileEntity2 instanceof BeltTileEntity)) continue;
                    BeltTileEntity belt2 = (BeltTileEntity)tileEntity2;
                    belt2.setController(controllerPos);
                }
            }
            if (!(tileEntity instanceof IMultiTileContainer)) continue;
            IMultiTileContainer multiTile = (IMultiTileContainer)tileEntity;
            class_2338 lastKnown = multiTile.getLastKnownPos();
            class_2338 current = tileEntity.method_11016();
            if (lastKnown == null || current == null || multiTile.isController() || lastKnown.equals((Object)current)) continue;
            class_2338 newControllerPos = multiTile.getController().method_10081((class_2382)current.method_10059((class_2382)lastKnown));
            multiTile.setController(newControllerPos);
        }
    }

    public void setBlockBreakingProgress(class_2338 pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<class_2338, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(class_2338 pos, class_2680 state) {
        class_265 voxelshape = state.method_26218((class_1922)this, pos);
        if (voxelshape.method_1110()) {
            return;
        }
        class_238 bb = voxelshape.method_1107();
        double d1 = Math.min(1.0, bb.field_1320 - bb.field_1323);
        double d2 = Math.min(1.0, bb.field_1325 - bb.field_1322);
        double d3 = Math.min(1.0, bb.field_1324 - bb.field_1321);
        int i = Math.max(2, class_3532.method_15384((double)(d1 / 0.25)));
        int j = Math.max(2, class_3532.method_15384((double)(d2 / 0.25)));
        int k = Math.max(2, class_3532.method_15384((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.field_1323;
                    double d8 = d5 * d2 + bb.field_1322;
                    double d9 = d6 * d3 + bb.field_1321;
                    this.method_8406((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + d7, (double)pos.method_10264() + d8, (double)pos.method_10260() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected class_2680 processBlockStateForPrinting(class_2680 state) {
        return state;
    }

    public boolean method_22340(class_2338 pos) {
        return true;
    }

    public boolean method_8393(int x, int y) {
        return true;
    }

    public boolean method_8477(class_2338 pos) {
        return true;
    }

    public boolean method_18458(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }

    public boolean method_8587(@Nullable class_1297 entity, class_238 collisionBox) {
        for (class_265 voxelShape : this.method_20812(entity, collisionBox)) {
            if (voxelShape.method_1110()) continue;
            return false;
        }
        if (!this.method_20743(entity, collisionBox).isEmpty()) {
            return false;
        }
        if (entity == null) {
            return true;
        }
        class_265 voxelShape2 = this.borderCollision(entity, collisionBox);
        return voxelShape2 == null || !class_259.method_1074((class_265)voxelShape2, (class_265)class_259.method_1078((class_238)collisionBox), (class_247)class_247.field_16896);
    }

    class_265 borderCollision(class_1297 entity, class_238 aABB) {
        class_2784 worldBorder = this.method_8621();
        return worldBorder.method_39459(entity, aABB) ? worldBorder.method_17903() : null;
    }
}

