/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.base.Strings;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.event.client.RenderTooltipBorderColorCallback;
import io.github.fabricators_of_create.porting_lib.util.KeyBindingHelper;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class PonderTooltipHandler {
    public static boolean enable = true;
    static LerpedFloat holdWProgress = LerpedFloat.linear().startWithValue(0.0);
    static class_1799 hoveredStack = class_1799.field_8037;
    static class_1799 trackingStack = class_1799.field_8037;
    static boolean subject = false;
    static boolean deferTick = false;
    public static final String HOLD_TO_PONDER = "ponder.hold_to_ponder";
    public static final String SUBJECT = "ponder.subject";

    public static void tick() {
        deferTick = true;
    }

    public static void deferredTick() {
        deferTick = false;
        class_310 instance = class_310.method_1551();
        class_437 currentScreen = instance.field_1755;
        if (hoveredStack.method_7960() || trackingStack.method_7960()) {
            trackingStack = class_1799.field_8037;
            holdWProgress.startWithValue(0.0);
            return;
        }
        float value = holdWProgress.getValue();
        int keyCode = KeyBindingHelper.getKeyCode((class_304)PonderTooltipHandler.ponderKeybind()).method_1444();
        long window = instance.method_22683().method_4490();
        if (!subject && class_3675.method_15987((long)window, (int)keyCode)) {
            if (value >= 1.0f) {
                if (currentScreen instanceof NavigatableSimiScreen) {
                    ((NavigatableSimiScreen)currentScreen).centerScalingOnMouse();
                }
                ScreenOpener.transitionTo(PonderUI.of(trackingStack));
                holdWProgress.startWithValue(0.0);
                return;
            }
            holdWProgress.setValue(Math.min(1.0f, value + Math.max(0.25f, value) * 0.25f));
        } else {
            holdWProgress.setValue(Math.max(0.0f, value - 0.05f));
        }
        hoveredStack = class_1799.field_8037;
    }

    public static void addToTooltip(List<class_2561> toolTip, class_1799 stack) {
        class_5250 component;
        if (!enable) {
            return;
        }
        PonderTooltipHandler.updateHovered(stack);
        if (deferTick) {
            PonderTooltipHandler.deferredTick();
        }
        if (trackingStack != stack) {
            return;
        }
        float renderPartialTicks = class_310.method_1551().method_1488();
        Object object = component = subject ? Lang.translateDirect(SUBJECT, new Object[0]).method_27692(class_124.field_1060) : PonderTooltipHandler.makeProgressBar(Math.min(1.0f, holdWProgress.getValue(renderPartialTicks) * 8.0f / 7.0f));
        if (toolTip.size() < 2) {
            toolTip.add((class_2561)component);
        } else {
            toolTip.add(1, (class_2561)component);
        }
    }

    protected static void updateHovered(class_1799 stack) {
        PonderUI ponderUI;
        class_310 instance = class_310.method_1551();
        class_437 currentScreen = instance.field_1755;
        boolean inPonderUI = currentScreen instanceof PonderUI;
        class_1799 prevStack = trackingStack;
        hoveredStack = class_1799.field_8037;
        subject = false;
        if (inPonderUI && stack.method_7962((ponderUI = (PonderUI)currentScreen).getSubject())) {
            subject = true;
        }
        if (stack.method_7960()) {
            return;
        }
        if (!PonderRegistry.ALL.containsKey(RegisteredObjects.getKeyOrThrow(stack.method_7909()))) {
            return;
        }
        if (prevStack.method_7960() || !prevStack.method_7962(stack)) {
            holdWProgress.startWithValue(0.0);
        }
        hoveredStack = stack;
        trackingStack = stack;
    }

    public static RenderTooltipBorderColorCallback.BorderColorEntry handleTooltipColor(class_1799 stack, int originalBorderColorStart, int originalBorderColorEn) {
        if (trackingStack != stack) {
            return null;
        }
        if (holdWProgress.getValue() == 0.0f) {
            return null;
        }
        float renderPartialTicks = class_310.method_1551().method_1488();
        int start = originalBorderColorStart;
        int end = originalBorderColorEn;
        float progress = Math.min(1.0f, holdWProgress.getValue(renderPartialTicks) * 8.0f / 7.0f);
        start = PonderTooltipHandler.getSmoothColorForProgress(progress);
        end = PonderTooltipHandler.getSmoothColorForProgress(progress);
        return new RenderTooltipBorderColorCallback.BorderColorEntry(start | 0xA0000000, end | 0xA0000000);
    }

    private static int getSmoothColorForProgress(float progress) {
        if (progress < 0.5f) {
            return Color.mixColors(0x5000FF, 0x5555FF, progress * 2.0f);
        }
        return Color.mixColors(0x5555FF, 0xFFFFFF, (progress - 0.5f) * 2.0f);
    }

    private static class_2561 makeProgressBar(float progress) {
        class_5250 holdW = Lang.translateDirect(HOLD_TO_PONDER, ((class_5250)PonderTooltipHandler.ponderKeybind().method_16007()).method_27692(class_124.field_1080)).method_27692(class_124.field_1063);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        float charWidth = fontRenderer.method_1727("|");
        float tipWidth = fontRenderer.method_27525((class_5348)holdW);
        int total = (int)(tipWidth / charWidth);
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            Object bars = "";
            bars = (String)bars + class_124.field_1080 + Strings.repeat((String)"|", (int)current);
            if (progress < 1.0f) {
                bars = (String)bars + class_124.field_1063 + Strings.repeat((String)"|", (int)(total - current));
            }
            return Components.literal((String)bars);
        }
        return holdW;
    }

    protected static class_304 ponderKeybind() {
        return class_310.method_1551().field_1690.field_1894;
    }
}

