/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public abstract class TileEntityConfigurationPacket<TE extends SyncedTileEntity>
extends SimplePacketBase {
    protected class_2338 pos;

    public TileEntityConfigurationPacket(class_2540 buffer) {
        this.pos = buffer.method_10811();
        this.readSettings(buffer);
    }

    public TileEntityConfigurationPacket(class_2338 pos) {
        this.pos = pos;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10807(this.pos);
        this.writeSettings(buffer);
    }

    @Override
    public void handle(Supplier<SimplePacketBase.Context> context) {
        context.get().enqueueWork(() -> {
            class_3222 player = ((SimplePacketBase.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            class_1937 world = player.field_6002;
            if (world == null || !world.method_8477(this.pos)) {
                return;
            }
            if (!this.pos.method_19771((class_2382)player.method_24515(), (double)this.maxRange())) {
                return;
            }
            class_2586 tileEntity = world.method_8321(this.pos);
            if (tileEntity instanceof SyncedTileEntity) {
                this.applySettings(player, (SyncedTileEntity)tileEntity);
                if (!this.causeUpdate()) {
                    return;
                }
                ((SyncedTileEntity)tileEntity).sendData();
                tileEntity.method_5431();
            }
        });
        context.get().setPacketHandled(true);
    }

    protected int maxRange() {
        return 20;
    }

    protected abstract void writeSettings(class_2540 var1);

    protected abstract void readSettings(class_2540 var1);

    protected void applySettings(class_3222 player, TE te) {
        this.applySettings(te);
    }

    protected boolean causeUpdate() {
        return true;
    }

    protected abstract void applySettings(TE var1);
}

