/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.google.common.collect.Maps;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMapData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMarker;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_22.class})
public class MapItemSavedDataMixin
implements StationMapData {
    @Final
    @Shadow
    public int field_116;
    @Final
    @Shadow
    public int field_115;
    @Final
    @Shadow
    public byte field_119;
    @Final
    @Shadow
    Map<String, class_20> field_117;
    private final Map<String, StationMarker> stationMarkers = Maps.newLinkedHashMap();

    @Inject(method={"save(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    public void save(class_2487 compound, CallbackInfoReturnable<class_2487> cir) {
        class_2499 listTag = new class_2499();
        for (StationMarker stationMarker : this.stationMarkers.values()) {
            listTag.add((Object)stationMarker.save());
        }
        ((class_2487)cir.getReturnValue()).method_10566("create:stations", (class_2520)listTag);
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;"}, at={@At(value="RETURN")})
    private static void load(class_2487 compound, CallbackInfoReturnable<class_22> cir) {
        class_22 mapData = (class_22)cir.getReturnValue();
        StationMapData stationMapData = (StationMapData)mapData;
        class_2499 listTag = compound.method_10554("create:stations", 10);
        for (int k = 0; k < listTag.size(); ++k) {
            StationMarker stationMarker = StationMarker.load(listTag.method_10602(k));
            stationMapData.addStationMarker(stationMarker);
        }
    }

    @Override
    public void addStationMarker(StationMarker marker) {
        this.stationMarkers.put(marker.getId(), marker);
        int scaleMultiplier = 1 << this.field_119;
        double localX = ((double)marker.getTarget().method_10263() - (double)this.field_116) / (double)scaleMultiplier;
        double localZ = ((double)marker.getTarget().method_10260() - (double)this.field_115) / (double)scaleMultiplier;
        if (localX < -63.0 || localX > 63.0 || localZ < -63.0 || localZ > 63.0) {
            return;
        }
        byte localXByte = (byte)(localX * 2.0 + 0.5);
        byte localZByte = (byte)(localZ * 2.0 + 0.5);
        StationMarker.Decoration decoration = new StationMarker.Decoration(localXByte, localZByte, marker.getName());
        this.field_117.put(marker.getId(), decoration);
    }

    @Shadow
    private void method_32368(String pIdentifier) {
        throw new AssertionError();
    }

    @Shadow
    public boolean method_37343(int pTrackedCount) {
        throw new AssertionError();
    }

    @Override
    public boolean toggleStation(class_1936 level, class_2338 pos, StationTileEntity stationTileEntity) {
        double xCenter = (double)pos.method_10263() + 0.5;
        double zCenter = (double)pos.method_10260() + 0.5;
        int scaleMultiplier = 1 << this.field_119;
        double localX = (xCenter - (double)this.field_116) / (double)scaleMultiplier;
        double localZ = (zCenter - (double)this.field_115) / (double)scaleMultiplier;
        if (localX < -63.0 || localX > 63.0 || localZ < -63.0 || localZ > 63.0) {
            return false;
        }
        StationMarker marker = StationMarker.fromWorld((class_1922)level, pos);
        if (marker == null) {
            return false;
        }
        if (this.stationMarkers.remove(marker.getId(), marker)) {
            this.method_32368(marker.getId());
            return true;
        }
        if (!this.method_37343(256)) {
            this.addStationMarker(marker);
        }
        return false;
    }

    @Inject(method={"checkBanners(Lnet/minecraft/world/level/BlockGetter;II)V"}, at={@At(value="RETURN")})
    public void checkBanners(class_1922 pReader, int pX, int pZ, CallbackInfo ci) {
        this.checkStations(pReader, pX, pZ);
    }

    private void checkStations(class_1922 pReader, int pX, int pZ) {
        Iterator<StationMarker> iterator = this.stationMarkers.values().iterator();
        while (iterator.hasNext()) {
            StationMarker other;
            StationMarker marker = iterator.next();
            if (marker.getTarget().method_10263() != pX || marker.getTarget().method_10260() != pZ || marker.equals(other = StationMarker.fromWorld(pReader, marker.getSource()))) continue;
            iterator.remove();
            this.method_32368(marker.getId());
            if (other == null || !marker.getTarget().equals((Object)other.getTarget())) continue;
            this.addStationMarker(other);
        }
    }
}

