/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.item.IItemHandlerModifiableIntermediate;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import io.github.fabricators_of_create.porting_lib.util.INBTSerializable;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class SmartInventory
extends RecipeWrapper
implements IItemHandlerModifiableIntermediate,
INBTSerializable<class_2487> {
    protected boolean extractionAllowed;
    protected boolean insertionAllowed;
    protected boolean stackNonStackables;
    protected int stackSize;

    public SmartInventory(int slots, SyncedTileEntity te) {
        this(slots, te, 64, false);
    }

    public SmartInventory(int slots, SyncedTileEntity te, int stackSize, boolean stackNonStackables) {
        super((ItemStackHandler)new SyncedStackHandler(slots, te, stackNonStackables, stackSize));
        this.stackNonStackables = stackNonStackables;
        this.insertionAllowed = true;
        this.extractionAllowed = true;
        this.stackSize = stackSize;
    }

    public SmartInventory withMaxStackSize(int maxStackSize) {
        this.stackSize = maxStackSize;
        ((SyncedStackHandler)this.handler).stackSize = maxStackSize;
        return this;
    }

    public SmartInventory whenContentsChanged(Runnable updateCallback) {
        ((SyncedStackHandler)this.handler).whenContentsChange(updateCallback);
        return this;
    }

    public SmartInventory allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    public SmartInventory allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    public SmartInventory forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    public SmartInventory forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.insertionAllowed) {
            return 0L;
        }
        return this.handler.insert(resource, maxAmount, transaction);
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.extractionAllowed) {
            return 0L;
        }
        if (this.stackNonStackables) {
            try (Transaction t = transaction.openNested();){
                long extracted = this.handler.extract(resource, maxAmount, (TransactionContext)t);
                t.abort();
                if (extracted != 0L && (long)resource.getItem().method_7882() < extracted) {
                    maxAmount = resource.getItem().method_7882();
                }
            }
        }
        return this.handler.extract(resource, maxAmount, transaction);
    }

    public class_1799 method_5438(int slot) {
        return super.method_5438(slot);
    }

    public class_2487 serializeNBT() {
        return this.getInv().serializeNBT();
    }

    public void deserializeNBT(class_2487 nbt) {
        this.getInv().deserializeNBT(nbt);
    }

    private SyncedStackHandler getInv() {
        return (SyncedStackHandler)this.handler;
    }

    @Override
    public class_1799 getStackInSlotIntermediate(int slot) {
        return this.method_5438(slot);
    }

    public Iterator<StorageView<ItemVariant>> iterator(TransactionContext transaction) {
        return this.handler.iterator(transaction);
    }

    private static class SyncedStackHandler
    extends ItemStackHandler {
        private SyncedTileEntity te;
        private boolean stackNonStackables;
        private int stackSize;
        private Runnable updateCallback;

        public SyncedStackHandler(int slots, SyncedTileEntity te, boolean stackNonStackables, int stackSize) {
            super(slots);
            this.te = te;
            this.stackNonStackables = stackNonStackables;
            this.stackSize = stackSize;
        }

        protected void onFinalCommit() {
            if (this.updateCallback != null) {
                this.updateCallback.run();
            }
            this.te.notifyUpdate();
        }

        public int getSlotLimit(int slot) {
            return Math.min(this.stackNonStackables ? 64 : super.getSlotLimit(slot), this.stackSize);
        }

        public void whenContentsChange(Runnable updateCallback) {
            this.updateCallback = updateCallback;
        }
    }
}

