/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.AllLangPartials;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_3518;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class LangMerger
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    static final String CATEGORY_HEADER = "\t\"_\": \"->------------------------]  %s  [------------------------<-\",";
    private class_2403 gen;
    private List<Object> mergedLangData;
    private Map<String, List<Object>> populatedLangData;
    private Map<String, Map<String, String>> allLocalizedEntries;
    private Map<String, MutableInt> missingTranslationTally;
    private List<String> langIgnore;

    public LangMerger(class_2403 gen) {
        this.gen = gen;
        this.mergedLangData = new ArrayList<Object>();
        this.langIgnore = new ArrayList<String>();
        this.allLocalizedEntries = new HashMap<String, Map<String, String>>();
        this.populatedLangData = new HashMap<String, List<Object>>();
        this.missingTranslationTally = new HashMap<String, MutableInt>();
        this.populateLangIgnore();
    }

    private void populateLangIgnore() {
        this.langIgnore.add("create.ponder.debug_");
        this.langIgnore.add("create.gui.chromatic_projector");
    }

    private boolean shouldIgnore(String key) {
        for (String string : this.langIgnore) {
            if (!key.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public String method_10321() {
        return "Lang merger";
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.gen.method_10313().resolve("assets/create/lang/en_us.json");
        for (Pair<String, JsonElement> pair : this.getAllLocalizationFiles()) {
            if (!((JsonElement)pair.getRight()).isJsonObject()) continue;
            HashMap localizedEntries = new HashMap();
            JsonObject jsonobject = ((JsonElement)pair.getRight()).getAsJsonObject();
            jsonobject.entrySet().stream().forEachOrdered(entry -> {
                String key = (String)entry.getKey();
                if (key.startsWith("_")) {
                    return;
                }
                String value = ((JsonElement)entry.getValue()).getAsString();
                localizedEntries.put(key, value);
            });
            String key = (String)pair.getKey();
            this.allLocalizedEntries.put(key, localizedEntries);
            this.populatedLangData.put(key, new ArrayList());
            this.missingTranslationTally.put(key, new MutableInt(0));
        }
        this.collectExistingEntries(path);
        this.collectEntries();
        if (this.mergedLangData.isEmpty()) {
            return;
        }
        this.save(cache, this.mergedLangData, -1, path, "Merging en_us.json with hand-written lang entries...");
        for (Map.Entry entry2 : this.populatedLangData.entrySet()) {
            String key = (String)entry2.getKey();
            Path populatedLangPath = this.gen.method_10313().resolve("assets/create/lang/unfinished/" + key);
            this.save(cache, (List)entry2.getValue(), this.missingTranslationTally.get(key).intValue(), populatedLangPath, "Populating " + key + " with missing entries...");
        }
    }

    private void collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Create.LOGGER.warn("Nothing to merge! It appears no lang was generated before me.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
            this.addAll("Game Elements", jsonobject);
            reader.close();
        }
    }

    protected void addAll(String header, JsonObject jsonobject) {
        if (jsonobject == null) {
            return;
        }
        header = String.format(CATEGORY_HEADER, header);
        this.writeData("\n");
        this.writeData(header);
        this.writeData("\n\n");
        MutableObject previousKey = new MutableObject((Object)"");
        jsonobject.entrySet().stream().forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            if (this.shouldIgnore(key)) {
                return;
            }
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!((String)previousKey.getValue()).isEmpty() && this.shouldAddLineBreak(key, (String)previousKey.getValue())) {
                this.writeData("\n");
            }
            this.writeEntry(key, value);
            previousKey.setValue((Object)key);
        });
        this.writeData("\n");
    }

    private void writeData(String data) {
        this.mergedLangData.add(data);
        this.populatedLangData.values().forEach(l -> l.add(data));
    }

    private void writeEntry(String key, String value) {
        this.mergedLangData.add(new LangEntry(key, value));
        this.populatedLangData.forEach((k, l) -> {
            ForeignLangEntry entry = new ForeignLangEntry(key, value, this.allLocalizedEntries.get(k));
            if (entry.isMissing()) {
                this.missingTranslationTally.get(k).increment();
            }
            l.add(entry);
        });
    }

    protected boolean shouldAddLineBreak(String key, String previousKey) {
        if (key.endsWith(".tooltip")) {
            return true;
        }
        if (key.startsWith("create.ponder") && key.endsWith("header")) {
            return true;
        }
        key = key.replaceFirst("\\.", "");
        previousKey = previousKey.replaceFirst("\\.", "");
        String[] split = key.split("\\.");
        String[] split2 = previousKey.split("\\.");
        if (split.length == 0 || split2.length == 0) {
            return false;
        }
        return !split[0].equals(split2[0]);
    }

    private List<Pair<String, JsonElement>> getAllLocalizationFiles() {
        ArrayList<Pair<String, JsonElement>> list = new ArrayList<Pair<String, JsonElement>>();
        String filepath = "assets/create/lang/";
        try (InputStream resourceStream = ClassLoader.getSystemResourceAsStream(filepath);){
            String readLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceStream));
            while ((readLine = bufferedReader.readLine()) != null) {
                if (!readLine.endsWith(".json") || readLine.startsWith("en_us") || readLine.startsWith("en_ud")) continue;
                list.add((Pair<String, JsonElement>)Pair.of((Object)readLine, (Object)FilesHelper.loadJsonResource(filepath + readLine)));
            }
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void collectEntries() {
        for (AllLangPartials partial : AllLangPartials.values()) {
            this.addAll(partial.getDisplay(), partial.provide().getAsJsonObject());
        }
    }

    private void save(class_2408 cache, List<Object> dataIn, int missingKeys, Path target, String message) throws IOException {
        String data = this.createString(dataIn, missingKeys);
        String hash = class_2405.field_11280.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.method_10323(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                Create.LOGGER.info(message);
                bufferedwriter.write(data);
                bufferedwriter.close();
            }
        }
        cache.method_10325(target, hash);
    }

    protected String createString(List<Object> data, int missingKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        if (missingKeys != -1) {
            builder.append("\t\"_\": \"Missing Localizations: " + missingKeys + "\",\n");
        }
        data.forEach(builder::append);
        builder.append("\t\"_\": \"Thank you for translating Create!\"\n\n");
        builder.append("}");
        return builder.toString();
    }

    private class LangEntry {
        static final String ENTRY_FORMAT = "\t\"%s\": %s,\n";
        private String key;
        private String value;

        LangEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format(ENTRY_FORMAT, this.key, GSON.toJson((Object)this.value, String.class));
        }
    }

    private class ForeignLangEntry
    extends LangEntry {
        private boolean missing;

        ForeignLangEntry(String key, String value, Map<String, String> localizationMap) {
            super(key, localizationMap.getOrDefault(key, "UNLOCALIZED: " + value));
            this.missing = !localizationMap.containsKey(key);
        }

        public boolean isMissing() {
            return this.missing;
        }
    }
}

