/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreenList;
import com.simibubi.create.foundation.config.ui.HintableTextFieldWidget;
import com.simibubi.create.foundation.config.ui.compat.flywheel.FlwConfigScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import io.github.fabricators_of_create.porting_lib.mixin.client.accessor.AbstractSelectionListAccessor;
import io.github.fabricators_of_create.porting_lib.mixin.client.accessor.AbstractWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ConfigModListScreen
extends ConfigScreen {
    ConfigScreenList list;
    HintableTextFieldWidget search;
    BoxWidget goBack;
    List<ModEntry> allEntries;

    public ConfigModListScreen(class_437 parent) {
        super(parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int listWidth = Math.min(this.field_22789 - 80, 300);
        this.list = new ConfigScreenList(this.field_22787, listWidth, this.field_22790 - 60, 15, this.field_22790 - 45, 40);
        this.list.method_25333(this.field_22789 / 2 - ((AbstractSelectionListAccessor)this.list).port_lib$getWidth() / 2);
        this.method_37063(this.list);
        this.allEntries = new ArrayList<ModEntry>();
        FabricLoader.getInstance().getAllMods().forEach(container -> this.allEntries.add(new ModEntry(container.getMetadata().getId(), this)));
        this.allEntries.sort((e1, e2) -> {
            int empty = (e2.button.field_22763 ? 1 : 0) - (e1.button.field_22763 ? 1 : 0);
            if (empty != 0) {
                return empty;
            }
            return e1.id.compareToIgnoreCase(e2.id);
        });
        this.list.method_25396().clear();
        this.list.method_25396().addAll(this.allEntries);
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.field_22789 / 2 - listWidth / 2 - 30, this.field_22790 / 2 + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> ScreenOpener.open(this.parent));
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((class_2561)Components.literal("Go Back"));
        this.method_37063(this.goBack);
        this.search = new HintableTextFieldWidget(this.field_22793, this.field_22789 / 2 - listWidth / 2, this.field_22790 - 35, listWidth, 20);
        this.search.method_1863(this::updateFilter);
        this.search.setHint("Search...");
        this.search.method_1870();
        this.method_37063((class_364)this.search);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            ScreenOpener.open(this.parent);
        }
        return false;
    }

    private void updateFilter(String search) {
        this.list.method_25396().clear();
        this.allEntries.stream().filter(modEntry -> modEntry.id.contains(search.toLowerCase(Locale.ROOT))).forEach(this.list.method_25396()::add);
        this.list.method_25307(this.list.method_25341());
        if (this.list.method_25396().size() > 0) {
            this.search.method_1868(Theme.i(Theme.Key.TEXT));
        } else {
            this.search.method_1868(Theme.i(Theme.Key.BUTTON_FAIL));
        }
    }

    public static class ModEntry
    extends ConfigScreenList.LabeledEntry {
        protected BoxWidget button;
        protected String id;

        public ModEntry(String id, class_437 parent) {
            super(ConfigScreen.toHumanReadable(id));
            this.id = id;
            this.button = (BoxWidget)new BoxWidget(0, 0, 35, 16).showingElement((RenderElement)AllIcons.I_CONFIG_OPEN.asStencil().at(10.0f, 0.0f));
            this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.button)));
            if (ConfigHelper.hasAnyForgeConfig(id)) {
                this.button.withCallback(() -> ScreenOpener.open(new BaseConfigScreen(parent, id)));
            } else if (id.equals("flywheel")) {
                this.button.withCallback(() -> ScreenOpener.open(new FlwConfigScreen(parent, id)));
            } else {
                this.button.field_22763 = false;
                this.button.updateColorsFromState();
                this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BaseConfigScreen.DISABLED_RENDERER));
                this.labelTooltip.add(Components.literal(ConfigScreen.toHumanReadable(id)));
                this.labelTooltip.addAll(TooltipHelper.cutTextComponent((class_2561)Components.literal("This Mod does not have any configs registered or is not using a compatible config system"), class_124.field_1080, class_124.field_1080));
            }
            this.listeners.add(this.button);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void tick() {
            super.tick();
            this.button.tick();
        }

        @Override
        public void method_25343(class_4587 ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.method_25343(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.field_22760 = x + width - 108;
            this.button.field_22761 = y + 10;
            ((AbstractWidgetAccessor)this.button).port_lib$setHeight(height - 20);
            this.button.method_25394(ms, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

