/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractSimpleShaftBlock;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.content.schematics.block.LaunchedItem;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTProcessors;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3908;

public class SchematicannonTileEntity
extends SmartTileEntity
implements class_3908,
CustomRenderBoundingBoxBlockEntity {
    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;
    public SchematicannonInventory inventory;
    public boolean sendUpdate;
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;
    public SchematicPrinter printer;
    public class_1799 missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;
    public class_2338 previousTarget;
    public LinkedHashSet<Storage<ItemVariant>> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;
    public float fuelLevel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceTileEntities;
    public boolean firstRenderTick;
    public float defaultYaw;

    public SchematicannonTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(30);
        this.attachedInventories = new LinkedHashSet();
        this.flyingBlocks = new LinkedList<LaunchedItem>();
        this.inventory = new SchematicannonInventory(this);
        this.statusMsg = "idle";
        this.state = State.STOPPED;
        this.replaceMode = 2;
        this.checklist = new MaterialChecklist();
        this.printer = new SchematicPrinter();
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (class_2350 facing : Iterate.directions) {
            Storage storage;
            class_2586 tileEntity;
            if (!this.field_11863.method_8477(this.field_11867.method_10093(facing))) continue;
            if (AllBlocks.CREATIVE_CRATE.has(this.field_11863.method_8320(this.field_11867.method_10093(facing)))) {
                this.hasCreativeCrate = true;
            }
            if ((tileEntity = this.field_11863.method_8321(this.field_11867.method_10093(facing))) == null || (storage = TransferUtil.getItemStorage((class_2586)tileEntity, (class_2350)facing.method_10153())) == null || !storage.supportsExtraction()) continue;
            this.attachedInventories.add((Storage<ItemVariant>)storage);
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        }
        this.statusMsg = compound.method_10558("Status");
        this.schematicProgress = compound.method_10583("Progress");
        this.bookPrintingProgress = compound.method_10583("PaperProgress");
        this.fuelLevel = compound.method_10583("Fuel");
        this.state = State.valueOf(compound.method_10558("State"));
        this.blocksPlaced = compound.method_10550("AmountPlaced");
        this.blocksToPlace = compound.method_10550("AmountToPlace");
        this.missingItem = null;
        if (compound.method_10545("MissingItem")) {
            this.missingItem = class_1799.method_7915((class_2487)compound.method_10562("MissingItem"));
        }
        class_2487 options = compound.method_10562("Options");
        this.replaceMode = options.method_10550("ReplaceMode");
        this.skipMissing = options.method_10577("SkipMissing");
        this.replaceTileEntities = options.method_10577("ReplaceTileEntities");
        if (compound.method_10545("Printer")) {
            this.printer.fromTag(compound.method_10562("Printer"), clientPacket);
        }
        if (compound.method_10545("FlyingBlocks")) {
            this.readFlyingBlocks(compound);
        }
        this.defaultYaw = compound.method_10583("DefaultYaw");
        super.read(compound, clientPacket);
    }

    protected void readFlyingBlocks(class_2487 compound) {
        class_2499 tagBlocks = compound.method_10554("FlyingBlocks", 10);
        if (tagBlocks.isEmpty()) {
            this.flyingBlocks.clear();
        }
        boolean pastDead = false;
        for (int i = 0; i < tagBlocks.size(); ++i) {
            class_2487 c = tagBlocks.method_10602(i);
            LaunchedItem launched = LaunchedItem.fromNBT(c);
            class_2338 readBlockPos = launched.target;
            if (this.field_11863 == null || !this.field_11863.field_9236) {
                this.flyingBlocks.add(launched);
                continue;
            }
            while (!(pastDead || this.flyingBlocks.isEmpty() || this.flyingBlocks.get((int)0).target.equals((Object)readBlockPos))) {
                this.flyingBlocks.remove(0);
            }
            pastDead = true;
            if (i < this.flyingBlocks.size()) continue;
            this.flyingBlocks.add(launched);
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
            if (this.state == State.RUNNING) {
                compound.method_10556("Running", true);
            }
        }
        compound.method_10548("Progress", this.schematicProgress);
        compound.method_10548("PaperProgress", this.bookPrintingProgress);
        compound.method_10548("Fuel", this.fuelLevel);
        compound.method_10582("Status", this.statusMsg);
        compound.method_10582("State", this.state.name());
        compound.method_10569("AmountPlaced", this.blocksPlaced);
        compound.method_10569("AmountToPlace", this.blocksToPlace);
        if (this.missingItem != null) {
            compound.method_10566("MissingItem", NBTSerializer.serializeNBT((Object)this.missingItem));
        }
        class_2487 options = new class_2487();
        options.method_10569("ReplaceMode", this.replaceMode);
        options.method_10556("SkipMissing", this.skipMissing);
        options.method_10556("ReplaceTileEntities", this.replaceTileEntities);
        compound.method_10566("Options", (class_2520)options);
        class_2487 printerData = new class_2487();
        this.printer.write(printerData);
        compound.method_10566("Printer", (class_2520)printerData);
        class_2499 tagFlyingBlocks = new class_2499();
        for (LaunchedItem b : this.flyingBlocks) {
            tagFlyingBlocks.add((Object)b.serializeNBT());
        }
        compound.method_10566("FlyingBlocks", (class_2520)tagFlyingBlocks);
        compound.method_10548("DefaultYaw", this.defaultYaw);
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state != State.STOPPED && this.neighbourCheckCooldown-- <= 0) {
            this.neighbourCheckCooldown = 100;
            this.findInventories();
        }
        this.firstRenderTick = true;
        this.previousTarget = this.printer.getCurrentTarget();
        this.tickFlyingBlocks();
        if (this.field_11863.field_9236) {
            return;
        }
        this.tickPaperPrinter();
        this.refillFuelIfPossible();
        this.skipsLeft = (Integer)this.config().schematicannonSkips.get();
        this.blockSkipped = true;
        while (this.blockSkipped && this.skipsLeft-- > 0) {
            this.tickPrinter();
        }
        this.schematicProgress = 0.0f;
        if (this.blocksToPlace > 0) {
            this.schematicProgress = (float)this.blocksPlaced / (float)this.blocksToPlace;
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.SERVER.schematics;
    }

    protected void tickPrinter() {
        ItemRequirement requirement;
        class_1799 blueprint = this.inventory.getStackInSlot(0);
        this.blockSkipped = false;
        if (this.state == State.STOPPED) {
            if (this.printer.isLoaded()) {
                this.resetPrinter();
            }
            return;
        }
        if (blueprint.method_7960()) {
            this.state = State.STOPPED;
            this.statusMsg = "idle";
            this.sendUpdate = true;
            return;
        }
        if (this.state == State.PAUSED && !this.positionNotLoaded && this.missingItem == null && (double)this.fuelLevel > this.getFuelUsageRate()) {
            return;
        }
        if (!this.printer.isLoaded()) {
            this.initializePrinter(blueprint);
            return;
        }
        if (this.printerCooldown > 0) {
            --this.printerCooldown;
            return;
        }
        if (this.fuelLevel <= 0.0f && !this.hasCreativeCrate) {
            this.fuelLevel = 0.0f;
            this.state = State.PAUSED;
            this.statusMsg = "noGunpowder";
            this.sendUpdate = true;
            return;
        }
        if (this.hasCreativeCrate && this.missingItem != null) {
            this.missingItem = null;
            this.state = State.RUNNING;
        }
        if (this.missingItem == null && !this.positionNotLoaded) {
            if (!this.printer.advanceCurrentPos()) {
                this.finishedPrinting();
                return;
            }
            this.sendUpdate = true;
        }
        if (!this.method_10997().method_8477(this.printer.getCurrentTarget())) {
            this.positionNotLoaded = true;
            this.statusMsg = "targetNotLoaded";
            this.state = State.PAUSED;
            return;
        }
        if (this.positionNotLoaded) {
            this.positionNotLoaded = false;
            this.state = State.RUNNING;
        }
        if ((requirement = this.printer.getCurrentRequirement()).isInvalid() || !this.printer.shouldPlaceCurrent(this.field_11863, this::shouldPlace)) {
            this.statusMsg = "searching";
            this.blockSkipped = true;
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            try (Transaction t = TransferUtil.getTransaction();){
                for (ItemRequirement.StackRequirement required : requiredItems) {
                    if (this.grabItemsFromAttachedInventories(required, (TransactionContext)t)) continue;
                    if (this.skipMissing) {
                        this.statusMsg = "skipping";
                        this.blockSkipped = true;
                        if (this.missingItem != null) {
                            this.missingItem = null;
                            this.state = State.RUNNING;
                        }
                        return;
                    }
                    this.missingItem = required.stack;
                    this.state = State.PAUSED;
                    this.statusMsg = "missingBlock";
                    return;
                }
                t.commit();
            }
        }
        this.state = State.RUNNING;
        class_1799 icon = requirement.isEmpty() || requiredItems.isEmpty() ? class_1799.field_8037 : requiredItems.get((int)0).stack;
        this.printer.handleCurrentTarget((target, blockState, tile) -> {
            this.statusMsg = blockState.method_26204() != class_2246.field_10124 ? "placing" : "clearing";
            this.launchBlockOrBelt(target, icon, blockState, tile);
        }, (target, entity) -> {
            this.statusMsg = "placing";
            this.launchEntity(target, icon, entity);
        });
        this.printerCooldown = (Integer)this.config().schematicannonDelay.get();
        this.fuelLevel = (float)((double)this.fuelLevel - this.getFuelUsageRate());
        this.sendUpdate = true;
        this.missingItem = null;
    }

    public double getFuelUsageRate() {
        return this.hasCreativeCrate ? 0.0 : (Double)this.config().schematicannonFuelUsage.get() / 100.0;
    }

    protected void initializePrinter(class_1799 blueprint) {
        if (!blueprint.method_7985()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicInvalid";
            this.sendUpdate = true;
            return;
        }
        if (!blueprint.method_7969().method_10577("Deployed")) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicNotPlaced";
            this.sendUpdate = true;
            return;
        }
        this.printer.loadSchematic(blueprint, this.field_11863, true);
        if (this.printer.isWorldEmpty()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicExpired";
            this.inventory.setStackInSlot(0, class_1799.field_8037);
            this.inventory.setStackInSlot(1, new class_1799((class_1935)AllItems.EMPTY_SCHEMATIC.get()));
            this.printer.resetSchematic();
            return;
        }
        if (!this.printer.getAnchor().method_19771((class_2382)this.method_11016(), 256.0)) {
            this.state = State.STOPPED;
            this.statusMsg = "targetOutsideRange";
            this.printer.resetSchematic();
            return;
        }
        this.state = State.PAUSED;
        this.statusMsg = "ready";
        this.updateChecklist();
        this.sendUpdate = true;
        this.blocksToPlace += this.blocksPlaced;
    }

    protected class_1799 getItemForBlock(class_2680 blockState) {
        class_1792 item = class_1747.field_8003.getOrDefault(blockState.method_26204(), class_1802.field_8162);
        return item == class_1802.field_8162 ? class_1799.field_8037 : new class_1799((class_1935)item);
    }

    protected boolean grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, TransactionContext transaction) {
        if (this.hasCreativeCrate) {
            return true;
        }
        ItemRequirement.ItemUseType usage = required.usage;
        if (usage == ItemRequirement.ItemUseType.DAMAGE) {
            for (Storage storage : this.attachedInventories) {
                Transaction t = transaction.openNested();
                try {
                    for (StorageView view : storage.iterable((TransactionContext)t)) {
                        ItemVariant itemVariant;
                        class_1799 stack;
                        if (view.isResourceBlank() || !required.matches(stack = (itemVariant = (ItemVariant)view.getResource()).toStack()) || !stack.method_7963()) continue;
                        if (storage.extract((Object)itemVariant, 1L, (TransactionContext)t) == 1L) {
                            stack.method_7974(stack.method_7919() + 1);
                            if (stack.method_7919() <= stack.method_7936() && storage.insert((Object)itemVariant, 1L, (TransactionContext)t) == 1L) {
                                t.commit();
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            return false;
        }
        boolean success = false;
        long l = 0L;
        try (Transaction t = transaction.openNested();){
            for (Storage storage : this.attachedInventories) {
                if ((l += (long)ItemHelper.extract((Storage<ItemVariant>)storage, required::matches, ItemHelper.ExtractionCountMode.UPTO, required.stack.method_7947(), false).method_7947()) < (long)required.stack.method_7947()) continue;
                success = true;
                break;
            }
            if (success) {
                t.commit();
            }
        }
        return success;
    }

    public void finishedPrinting() {
        this.inventory.setStackInSlot(0, class_1799.field_8037);
        this.inventory.setStackInSlot(1, new class_1799((class_1935)AllItems.EMPTY_SCHEMATIC.get(), this.inventory.getStackInSlot(1).method_7947() + 1));
        this.state = State.STOPPED;
        this.statusMsg = "finished";
        this.resetPrinter();
        AllSoundEvents.SCHEMATICANNON_FINISH.playOnServer(this.field_11863, (class_2382)this.field_11867);
        this.sendUpdate = true;
    }

    protected void resetPrinter() {
        this.printer.resetSchematic();
        this.missingItem = null;
        this.sendUpdate = true;
        this.schematicProgress = 0.0f;
        this.blocksPlaced = 0;
        this.blocksToPlace = 0;
    }

    protected boolean shouldPlace(class_2338 pos, class_2680 state, class_2586 te, class_2680 toReplace, class_2680 toReplaceOther, boolean isNormalCube) {
        if (pos.method_19771((class_2382)this.method_11016(), 2.0)) {
            return false;
        }
        if (!this.replaceTileEntities && (toReplace.method_31709() || toReplaceOther != null && toReplaceOther.method_31709())) {
            return false;
        }
        if (this.shouldIgnoreBlockState(state, te)) {
            return false;
        }
        boolean placingAir = state.method_26215();
        if (this.replaceMode == 3) {
            return true;
        }
        if (this.replaceMode == 2 && !placingAir) {
            return true;
        }
        if (!(this.replaceMode != 1 || !isNormalCube && (toReplace.method_26212((class_1922)this.field_11863, pos) || toReplaceOther != null && toReplaceOther.method_26212((class_1922)this.field_11863, pos)) || placingAir)) {
            return true;
        }
        return this.replaceMode == 0 && !toReplace.method_26212((class_1922)this.field_11863, pos) && (toReplaceOther == null || !toReplaceOther.method_26212((class_1922)this.field_11863, pos)) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(class_2680 state, class_2586 te) {
        if (state.method_26204() == class_2246.field_10369) {
            return true;
        }
        ItemRequirement requirement = ItemRequirement.of(state, te);
        if (requirement.isEmpty()) {
            return false;
        }
        if (requirement.isInvalid()) {
            return false;
        }
        if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
            return true;
        }
        if (state.method_28498((class_2769)class_2741.field_12483) && state.method_11654((class_2769)class_2741.field_12483) == class_2742.field_12560) {
            return true;
        }
        if (state.method_26204() instanceof class_2671) {
            return true;
        }
        if (AllBlocks.BELT.has(state)) {
            return state.method_11654(BeltBlock.PART) == BeltPart.MIDDLE;
        }
        return false;
    }

    protected void tickFlyingBlocks() {
        LinkedList<LaunchedItem> toRemove = new LinkedList<LaunchedItem>();
        for (LaunchedItem b : this.flyingBlocks) {
            if (!b.update(this.field_11863)) continue;
            toRemove.add(b);
        }
        this.flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if ((double)(1.0f - this.fuelLevel + 0.0078125f) < this.getFuelAddedByGunPowder()) {
            return;
        }
        if (this.inventory.getStackInSlot(4).method_7960()) {
            return;
        }
        this.inventory.getStackInSlot(4).method_7934(1);
        this.fuelLevel = (float)((double)this.fuelLevel + this.getFuelAddedByGunPowder());
        this.sendUpdate = true;
    }

    public double getFuelAddedByGunPowder() {
        return (Double)this.config().schematicannonGunpowderWorth.get() / 100.0;
    }

    protected void tickPaperPrinter() {
        boolean outputFull;
        int BookInput = 2;
        int BookOutput = 3;
        class_1799 blueprint = this.inventory.getStackInSlot(0);
        class_1799 paper = this.inventory.getStackInSlot(BookInput).method_7972();
        paper.method_7939(1);
        boolean bl = outputFull = this.inventory.getStackInSlot(BookOutput).method_7947() == this.inventory.getSlotLimit(BookOutput);
        if (paper.method_7960() || outputFull) {
            if (this.bookPrintingProgress != 0.0f) {
                this.sendUpdate = true;
            }
            this.bookPrintingProgress = 0.0f;
            this.dontUpdateChecklist = false;
            return;
        }
        if (!this.printer.isLoaded()) {
            if (!blueprint.method_7960()) {
                this.initializePrinter(blueprint);
            }
            return;
        }
        if (this.bookPrintingProgress >= 1.0f) {
            this.bookPrintingProgress = 0.0f;
            if (!this.dontUpdateChecklist) {
                this.updateChecklist();
            }
            this.dontUpdateChecklist = true;
            try (Transaction t = TransferUtil.getTransaction();){
                this.inventory.extract(ItemVariant.of((class_1799)paper), paper.method_7947(), (TransactionContext)t);
                t.commit();
            }
            class_1799 stack = this.checklist.createItem();
            stack.method_7939(this.inventory.getStackInSlot(BookOutput).method_7947() + 1);
            this.inventory.setStackInSlot(BookOutput, stack);
            this.sendUpdate = true;
            return;
        }
        this.bookPrintingProgress += 0.05f;
        this.sendUpdate = true;
    }

    public static class_2680 stripBeltIfNotLast(class_2680 blockState) {
        BeltPart part = (BeltPart)((Object)blockState.method_11654(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return class_2246.field_10124.method_9564();
        }
        boolean isLastSegment = false;
        class_2350 facing = (class_2350)blockState.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)blockState.method_11654(BeltBlock.SLOPE));
        boolean positive = facing.method_10171() == class_2350.class_2352.field_11056;
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        switch (slope) {
            case DOWNWARD: {
                isLastSegment = start;
                break;
            }
            case UPWARD: {
                isLastSegment = end;
                break;
            }
            default: {
                boolean bl = isLastSegment = positive && end || !positive && start;
            }
        }
        if (isLastSegment) {
            return blockState;
        }
        return (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)AbstractSimpleShaftBlock.AXIS, (Comparable)(slope == BeltSlope.SIDEWAYS ? class_2350.class_2351.field_11052 : facing.method_10170().method_10166()));
    }

    protected void launchBlockOrBelt(class_2338 target, class_1799 icon, class_2680 blockState, class_2586 tile) {
        if (AllBlocks.BELT.has(blockState)) {
            blockState = SchematicannonTileEntity.stripBeltIfNotLast(blockState);
            if (tile instanceof BeltTileEntity && AllBlocks.BELT.has(blockState)) {
                this.launchBelt(target, blockState, ((BeltTileEntity)tile).beltLength);
            } else if (blockState != class_2246.field_10124.method_9564()) {
                this.launchBlock(target, icon, blockState, null);
            }
        } else {
            class_2487 data = null;
            if (tile != null) {
                if (AllTags.AllBlockTags.SAFE_NBT.matches(blockState)) {
                    data = tile.method_38242();
                    data = NBTProcessors.process(tile, data, true);
                } else if (tile instanceof IPartialSafeNBT) {
                    data = new class_2487();
                    ((IPartialSafeNBT)tile).writeSafe(data);
                    data = NBTProcessors.process(tile, data, true);
                }
            }
            this.launchBlock(target, icon, blockState, data);
        }
    }

    protected void launchBelt(class_2338 target, class_2680 state, int length) {
        ++this.blocksPlaced;
        class_1799 connector = AllItems.BELT_CONNECTOR.asStack();
        this.flyingBlocks.add(new LaunchedItem.ForBelt(this.method_11016(), target, connector, state, length));
        this.playFiringSound();
    }

    protected void launchBlock(class_2338 target, class_1799 stack, class_2680 state, @Nullable class_2487 data) {
        if (!state.method_26215()) {
            ++this.blocksPlaced;
        }
        this.flyingBlocks.add(new LaunchedItem.ForBlockState(this.method_11016(), target, stack, state, data));
        this.playFiringSound();
    }

    protected void launchEntity(class_2338 target, class_1799 stack, class_1297 entity) {
        ++this.blocksPlaced;
        this.flyingBlocks.add(new LaunchedItem.ForEntity(this.method_11016(), target, stack, entity));
        this.playFiringSound();
    }

    public void playFiringSound() {
        AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.playOnServer(this.field_11863, (class_2382)this.field_11867);
    }

    @Override
    public void sendToContainer(class_2540 buffer) {
        buffer.method_10807(this.method_11016());
        buffer.method_10794(this.method_16887());
    }

    public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
        return SchematicannonContainer.create(id, inv, this);
    }

    public class_2561 method_5476() {
        return Lang.translateDirect("gui.schematicannon.title", new Object[0]);
    }

    public void updateChecklist() {
        this.checklist.required.clear();
        this.checklist.damageRequired.clear();
        this.checklist.blocksNotLoaded = false;
        if (this.printer.isLoaded()) {
            this.blocksToPlace = this.blocksPlaced;
            this.blocksToPlace += this.printer.markAllBlockRequirements(this.checklist, this.field_11863, this::shouldPlace);
            this.printer.markAllEntityRequirements(this.checklist);
        }
        this.checklist.gathered.clear();
        this.findInventories();
        for (Storage storage : this.attachedInventories) {
            List contents = TransferUtil.getAllItems((Storage)storage);
            contents.forEach(this.checklist::collect);
        }
        this.sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_238 getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static enum State {
        STOPPED,
        PAUSED,
        RUNNING;

    }
}

