/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.virtual.VirtualEmptyBlockGetter;
import com.jozufozu.flywheel.fabric.model.DefaultLayerFilteringBakedModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.schematics.block.LaunchedItem;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import io.github.fabricators_of_create.porting_lib.mixin.client.accessor.BlockRenderDispatcherAccessor;
import io.github.fabricators_of_create.porting_lib.render.virtual.FixedLightBakedModel;
import java.util.Random;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_809;

public class SchematicannonRenderer
extends SafeTileEntityRenderer<SchematicannonTileEntity> {
    public SchematicannonRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SchematicannonTileEntity tileEntity, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        boolean blocksLaunching;
        boolean bl = blocksLaunching = !tileEntity.flyingBlocks.isEmpty();
        if (blocksLaunching) {
            SchematicannonRenderer.renderLaunchedBlocks(tileEntity, partialTicks, ms, buffer, light, overlay);
        }
        if (Backend.canUseInstancing((class_1937)tileEntity.method_10997())) {
            return;
        }
        class_2338 pos = tileEntity.method_11016();
        class_2680 state = tileEntity.method_11010();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles(tileEntity, pos, partialTicks);
        double yaw = cannonAngles[0];
        double pitch = cannonAngles[1];
        double recoil = SchematicannonRenderer.getRecoil(tileEntity, partialTicks);
        ms.method_22903();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        SuperByteBuffer connector = CachedBufferer.partial(AllBlockPartials.SCHEMATICANNON_CONNECTOR, state);
        connector.translate(0.5, 0.0, 0.5);
        connector.rotate(class_2350.field_11036, (float)((yaw + 90.0) / 180.0 * Math.PI));
        connector.translate(-0.5, 0.0, -0.5);
        connector.light(light).renderInto(ms, vb);
        SuperByteBuffer pipe = CachedBufferer.partial(AllBlockPartials.SCHEMATICANNON_PIPE, state);
        pipe.translate(0.5, 0.9375, 0.5);
        pipe.rotate(class_2350.field_11036, (float)((yaw + 90.0) / 180.0 * Math.PI));
        pipe.rotate(class_2350.field_11035, (float)(pitch / 180.0 * Math.PI));
        pipe.translate(-0.5, -0.9375, -0.5);
        pipe.translate(0.0, -recoil / 100.0, 0.0);
        pipe.light(light).renderInto(ms, vb);
        ms.method_22909();
    }

    public static double[] getCannonAngles(SchematicannonTileEntity tile, class_2338 pos, float partialTicks) {
        double pitch;
        double yaw;
        class_2338 target = tile.printer.getCurrentTarget();
        if (target != null) {
            class_243 diff = class_243.method_24954((class_2382)target.method_10059((class_2382)pos));
            if (tile.previousTarget != null) {
                diff = class_243.method_24954((class_2382)tile.previousTarget).method_1019(class_243.method_24954((class_2382)target.method_10059((class_2382)tile.previousTarget)).method_1021((double)partialTicks)).method_1020(class_243.method_24954((class_2382)pos));
            }
            double diffX = diff.method_10216();
            double diffZ = diff.method_10215();
            yaw = class_3532.method_15349((double)diffX, (double)diffZ);
            yaw = yaw / Math.PI * 180.0;
            float distance = class_3532.method_15355((float)((float)(diffX * diffX + diffZ * diffZ)));
            double yOffset = 0.0f + distance * 2.0f;
            pitch = class_3532.method_15349((double)distance, (double)(diff.method_10214() * 3.0 + yOffset));
            pitch = pitch / Math.PI * 180.0 + 10.0;
        } else {
            yaw = tile.defaultYaw;
            pitch = 40.0;
        }
        return new double[]{yaw, pitch};
    }

    public static double getRecoil(SchematicannonTileEntity tileEntityIn, float partialTicks) {
        double recoil = 0.0;
        for (LaunchedItem launched : tileEntityIn.flyingBlocks) {
            if (launched.ticksRemaining == 0 || !((float)(launched.ticksRemaining + 1) - partialTicks > (float)(launched.totalTicks - 10))) continue;
            recoil = Math.max(recoil, (double)((float)(launched.ticksRemaining + 1) - partialTicks - (float)launched.totalTicks + 10.0f));
        }
        return recoil;
    }

    private static void renderLaunchedBlocks(SchematicannonTileEntity tileEntityIn, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        for (LaunchedItem launched : tileEntityIn.flyingBlocks) {
            if (launched.ticksRemaining == 0) continue;
            class_243 start = class_243.method_24954((class_2382)tileEntityIn.method_11016().method_10080(0.5, 1.0, 0.5));
            class_243 target = class_243.method_24954((class_2382)launched.target).method_1031(-0.5, 0.0, 1.0);
            class_243 distance = target.method_1020(start);
            double targetY = target.field_1351 - start.field_1351;
            double throwHeight = Math.sqrt(distance.method_1027()) * (double)0.6f + targetY;
            class_243 cannonOffset = distance.method_1031(0.0, throwHeight, 0.0).method_1029().method_1021(2.0);
            start = start.method_1019(cannonOffset);
            float progress = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            class_243 blockLocationXZ = new class_243(0.5, 0.5, 0.5).method_1019(target.method_1020(start).method_1021((double)progress).method_18805(1.0, 0.0, 1.0));
            float t = progress;
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * targetY;
            class_243 blockLocation = blockLocationXZ.method_1031(0.0, yOffset + 1.0, 0.0).method_1019(cannonOffset);
            ms.method_22903();
            ms.method_22904(blockLocation.field_1352, blockLocation.field_1351, blockLocation.field_1350);
            ms.method_22904(0.125, 0.125, 0.125);
            ms.method_22907(new class_1160(0.0f, 1.0f, 0.0f).method_23214(360.0f * t));
            ms.method_22907(new class_1160(1.0f, 0.0f, 0.0f).method_23214(360.0f * t));
            ms.method_22904(-0.125, -0.125, -0.125);
            if (launched instanceof LaunchedItem.ForBlockState) {
                class_2680 state = launched instanceof LaunchedItem.ForBelt ? AllBlocks.SHAFT.getDefaultState() : ((LaunchedItem.ForBlockState)launched).state;
                float scale = 0.3f;
                ms.method_22905(scale, scale, scale);
                class_776 dispatcher = class_310.method_1551().method_1541();
                switch (state.method_26217()) {
                    case field_11458: {
                        class_1087 model = dispatcher.method_3349(state);
                        model = DefaultLayerFilteringBakedModel.wrap((class_1087)model);
                        model = FixedLightBakedModel.wrap((class_1087)model, (int)light);
                        dispatcher.method_3350().method_3374((class_1920)VirtualEmptyBlockGetter.INSTANCE, model, state, class_2338.field_10980, ms, buffer.getBuffer(class_4696.method_23683((class_2680)state, (boolean)false)), false, new Random(), 42L, overlay);
                        break;
                    }
                    case field_11456: {
                        ((BlockRenderDispatcherAccessor)dispatcher).getBlockEntityRenderer().method_3166(new class_1799((class_1935)state.method_26204()), class_809.class_811.field_4315, ms, buffer, light, overlay);
                    }
                }
            } else if (launched instanceof LaunchedItem.ForEntity) {
                float scale = 1.2f;
                ms.method_22905(scale, scale, scale);
                class_310.method_1551().method_1480().method_23178(launched.stack, class_809.class_811.field_4318, light, overlay, ms, buffer, 0);
            }
            ms.method_22909();
            if (launched.ticksRemaining != launched.totalTicks || !tileEntityIn.firstRenderTick) continue;
            tileEntityIn.firstRenderTick = false;
            for (int i = 0; i < 10; ++i) {
                Random r = tileEntityIn.method_10997().method_8409();
                double sX = cannonOffset.field_1352 * (double)0.01f;
                double sY = (cannonOffset.field_1351 + 1.0) * (double)0.01f;
                double sZ = cannonOffset.field_1350 * (double)0.01f;
                double rX = (double)r.nextFloat() - sX * 40.0;
                double rY = (double)r.nextFloat() - sY * 40.0;
                double rZ = (double)r.nextFloat() - sZ * 40.0;
                tileEntityIn.method_10997().method_8406((class_2394)class_2398.field_11204, start.field_1352 + rX, start.field_1351 + rY, start.field_1350 + rZ, sX, sY, sZ);
            }
        }
    }

    public boolean shouldRenderOffScreen(SchematicannonTileEntity tileEntity) {
        return true;
    }

    public int method_33893() {
        return 128;
    }
}

