/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainIconType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.AbstractStationScreen;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationEditPacket;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationScreen;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.TrainEditPacket;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.WideIconButton;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.lang.ref.WeakReference;
import java.util.List;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class AssemblyScreen
extends AbstractStationScreen {
    private IconButton quitAssembly;
    private IconButton toggleAssemblyButton;
    private List<class_2960> iconTypes;
    private ScrollInput iconTypeScroll;

    public AssemblyScreen(StationTileEntity te, GlobalStation station) {
        super(te, station);
        this.background = AllGuiTextures.STATION_ASSEMBLING;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        int by = y + this.background.height - 24;
        class_4068 widget = (class_4068)this.field_33816.get(0);
        if (widget instanceof IconButton) {
            IconButton ib = (IconButton)widget;
            ib.setIcon(AllIcons.I_PRIORITY_VERY_LOW);
            ib.setToolTip((class_2561)Lang.translateDirect("station.close", new Object[0]));
        }
        this.iconTypes = TrainIconType.REGISTRY.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 184, 14).titled(Lang.translateDirect("station.icon_type", new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -this.iconTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId(this.iconTypes.get((int)s));
            }
        });
        this.iconTypeScroll.field_22764 = false;
        this.iconTypeScroll.field_22763 = false;
        this.method_37063(this.iconTypeScroll);
        this.toggleAssemblyButton = new WideIconButton(x + 94, by, AllGuiTextures.I_ASSEMBLE_TRAIN);
        this.toggleAssemblyButton.field_22763 = false;
        this.toggleAssemblyButton.setToolTip((class_2561)Lang.translateDirect("station.assemble_train", new Object[0]));
        this.toggleAssemblyButton.withCallback(() -> AllPackets.channel.sendToServer((C2SPacket)StationEditPacket.tryAssemble(this.te.method_11016())));
        this.quitAssembly = new IconButton(x + 73, by, AllIcons.I_DISABLE);
        this.quitAssembly.field_22763 = true;
        this.quitAssembly.setToolTip((class_2561)Lang.translateDirect("station.cancel", new Object[0]));
        this.quitAssembly.withCallback(() -> {
            AllPackets.channel.sendToServer((C2SPacket)StationEditPacket.configure(this.te.method_11016(), false, this.station.name));
            this.field_22787.method_1507((class_437)new StationScreen(this.te, this.station));
        });
        this.method_37063(this.toggleAssemblyButton);
        this.method_37063(this.quitAssembly);
        this.tickTrainDisplay();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.tickTrainDisplay();
        Train train = (Train)this.displayedTrain.get();
        boolean bl = this.toggleAssemblyButton.field_22763 = this.te.bogeyCount > 0 || train != null;
        if (train != null) {
            AllPackets.channel.sendToServer((C2SPacket)StationEditPacket.configure(this.te.method_11016(), false, this.station.name));
            this.field_22787.method_1507((class_437)new StationScreen(this.te, this.station));
            for (Carriage carriage : train.carriages) {
                carriage.updateConductors();
            }
        }
    }

    private void tickTrainDisplay() {
        if (this.getImminent() == null) {
            this.displayedTrain = new WeakReference<Object>(null);
            this.quitAssembly.field_22763 = true;
            this.iconTypeScroll.field_22764 = false;
            this.iconTypeScroll.field_22763 = false;
            this.toggleAssemblyButton.setToolTip((class_2561)Lang.translateDirect("station.assemble_train", new Object[0]));
            this.toggleAssemblyButton.setIcon(AllGuiTextures.I_ASSEMBLE_TRAIN);
            this.toggleAssemblyButton.withCallback(() -> AllPackets.channel.sendToServer((C2SPacket)StationEditPacket.tryAssemble(this.te.method_11016())));
        } else {
            AllPackets.channel.sendToServer((C2SPacket)StationEditPacket.configure(this.te.method_11016(), false, this.station.name));
            this.field_22787.method_1507((class_437)new StationScreen(this.te, this.station));
        }
    }

    @Override
    protected void renderWindow(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(ms, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        class_5250 header = Lang.translateDirect("station.assembly_title", new Object[0]);
        this.field_22793.method_30883(ms, (class_2561)header, (float)(x + this.background.width / 2 - this.field_22793.method_27525((class_5348)header) / 2), (float)(y + 4), 926259);
        AssemblyException lastAssemblyException = this.te.lastException;
        if (lastAssemblyException != null) {
            class_5250 text = Lang.translateDirect("station.failed", new Object[0]);
            this.field_22793.method_30883(ms, (class_2561)text, (float)(x + 97 - this.field_22793.method_27525((class_5348)text) / 2), (float)(y + 47), 0x775B5B);
            int offset = 0;
            if (this.te.failedCarriageIndex != -1) {
                this.field_22793.method_30883(ms, (class_2561)Lang.translateDirect("station.carriage_number", this.te.failedCarriageIndex), (float)(x + 30), (float)(y + 67), 0x7A7A7A);
                offset += 10;
            }
            this.field_22793.method_1712((class_5348)lastAssemblyException.component, x + 30, y + 67 + offset, 134, 0x775B5B);
            this.field_22793.method_1712((class_5348)Lang.translateDirect("station.retry", new Object[0]), x + 30, y + 67 + (offset += this.field_22793.method_1728((class_5348)lastAssemblyException.component, 134).size() * 9 + 5), 134, 0x7A7A7A);
            return;
        }
        int bogeyCount = this.te.bogeyCount;
        class_5250 text = Lang.translateDirect(bogeyCount == 0 ? "station.no_bogeys" : (bogeyCount == 1 ? "station.one_bogey" : "station.more_bogeys"), bogeyCount);
        this.field_22793.method_30883(ms, (class_2561)text, (float)(x + 97 - this.field_22793.method_27525((class_5348)text) / 2), (float)(y + 47), 0x7A7A7A);
        this.field_22793.method_1712((class_5348)Lang.translateDirect("station.how_to", new Object[0]), x + 28, y + 62, 134, 0x7A7A7A);
        this.field_22793.method_1712((class_5348)Lang.translateDirect("station.how_to_1", new Object[0]), x + 28, y + 94, 134, 0x7A7A7A);
        this.field_22793.method_1712((class_5348)Lang.translateDirect("station.how_to_2", new Object[0]), x + 28, y + 117, 138, 0x7A7A7A);
    }

    public void method_25432() {
        super.method_25432();
        Train train = (Train)this.displayedTrain.get();
        if (train != null) {
            class_2960 iconId = this.iconTypes.get(this.iconTypeScroll.getState());
            train.icon = TrainIconType.byId(iconId);
            AllPackets.channel.sendToServer((C2SPacket)new TrainEditPacket(train.id, "", iconId));
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return AllBlockPartials.STATION_ASSEMBLE;
    }
}

