/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_5321;

public class TrackNodeLocation
extends class_2382 {
    public class_5321<class_1937> dimension;

    public TrackNodeLocation(class_243 vec) {
        this(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public TrackNodeLocation(double p_121865_, double p_121866_, double p_121867_) {
        super((double)Math.round(p_121865_ * 2.0), Math.floor(p_121866_ * 2.0), (double)Math.round(p_121867_ * 2.0));
    }

    public TrackNodeLocation in(class_1937 level) {
        return this.in((class_5321<class_1937>)level.method_27983());
    }

    public TrackNodeLocation in(class_5321<class_1937> dimension) {
        this.dimension = dimension;
        return this;
    }

    private static TrackNodeLocation fromPackedPos(class_2338 bufferPos) {
        return new TrackNodeLocation(bufferPos);
    }

    private TrackNodeLocation(class_2338 readBlockPos) {
        super(readBlockPos.method_10263(), readBlockPos.method_10264(), readBlockPos.method_10260());
    }

    public class_243 getLocation() {
        return new class_243((double)((float)this.method_10263() / 2.0f), (double)((float)this.method_10264() / 2.0f), (double)((float)this.method_10260() / 2.0f));
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object pOther) {
        if (!this.equalsIgnoreDim(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (!Objects.equals(tnl.dimension, this.dimension)) return false;
        return true;
    }

    public boolean equalsIgnoreDim(Object pOther) {
        return super.equals(pOther);
    }

    public int hashCode() {
        return (this.method_10264() + (this.method_10260() * 31 + this.dimension.hashCode()) * 31) * 31 + this.method_10263();
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 c = class_2512.method_10692((class_2338)new class_2338((class_2382)this));
        if (dimensions != null) {
            c.method_10569("D", dimensions.encode(this.dimension));
        }
        return c;
    }

    public static TrackNodeLocation read(class_2487 tag, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(class_2512.method_10691((class_2487)tag));
        if (dimensions != null) {
            location.dimension = dimensions.decode(tag.method_10550("D"));
        }
        return location;
    }

    public void send(class_2540 buffer, DimensionPalette dimensions) {
        buffer.method_10807(new class_2338((class_2382)this));
        buffer.method_10804(dimensions.encode(this.dimension));
    }

    public static TrackNodeLocation receive(class_2540 buffer, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(buffer.method_10811());
        location.dimension = dimensions.decode(buffer.method_10816());
        return location;
    }

    public Collection<class_2338> allAdjacent() {
        HashSet<class_2338> set = new HashSet<class_2338>();
        class_243 vec3 = this.getLocation();
        double step = 0.125;
        for (int x : Iterate.positiveAndNegative) {
            for (int y : Iterate.positiveAndNegative) {
                for (int z : Iterate.positiveAndNegative) {
                    set.add(new class_2338(vec3.method_1031((double)x * step, (double)y * step, (double)z * step)));
                }
            }
        }
        return set;
    }

    public static class DiscoveredLocation
    extends TrackNodeLocation {
        BezierConnection turn = null;
        boolean forceNode = false;
        class_243 direction;
        class_243 normal;

        public DiscoveredLocation(class_1937 level, double p_121865_, double p_121866_, double p_121867_) {
            super(p_121865_, p_121866_, p_121867_);
            this.in(level);
        }

        public DiscoveredLocation(class_5321<class_1937> dimension, class_243 vec) {
            super(vec);
            this.in(dimension);
        }

        public DiscoveredLocation(class_1937 level, class_243 vec) {
            this((class_5321<class_1937>)level.method_27983(), vec);
        }

        public DiscoveredLocation viaTurn(BezierConnection turn) {
            this.turn = turn;
            if (turn != null) {
                this.forceNode();
            }
            return this;
        }

        public DiscoveredLocation forceNode() {
            this.forceNode = true;
            return this;
        }

        public DiscoveredLocation withNormal(class_243 normal) {
            this.normal = normal;
            return this;
        }

        public DiscoveredLocation withDirection(class_243 direction) {
            this.direction = direction == null ? null : direction.method_1029();
            return this;
        }

        public boolean connectedViaTurn() {
            return this.turn != null;
        }

        public BezierConnection getTurn() {
            return this.turn;
        }

        public boolean shouldForceNode() {
            return this.forceNode;
        }

        public boolean notInLineWith(class_243 direction) {
            return this.direction != null && Math.max(direction.method_1026(this.direction), direction.method_1026(this.direction.method_1021(-1.0))) < 0.875;
        }
    }
}

