/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_918;

public class ArmInstance
extends SingleRotatingInstance
implements DynamicInstance {
    final ModelData base;
    final ModelData lowerBody;
    final ModelData upperBody;
    final ModelData head;
    final ModelData claw;
    private final ArrayList<ModelData> clawGrips;
    private final ArrayList<ModelData> models;
    private final ArmTileEntity arm;
    private final Boolean ceiling;
    private boolean firstRender = true;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmInstance(MaterialManager modelManager, ArmTileEntity tile) {
        super(modelManager, tile);
        Material mat = this.getTransformMaterial();
        this.base = (ModelData)mat.getModel(AllBlockPartials.ARM_BASE, this.blockState).createInstance();
        this.lowerBody = (ModelData)mat.getModel(AllBlockPartials.ARM_LOWER_BODY, this.blockState).createInstance();
        this.upperBody = (ModelData)mat.getModel(AllBlockPartials.ARM_UPPER_BODY, this.blockState).createInstance();
        this.head = (ModelData)mat.getModel(AllBlockPartials.ARM_HEAD, this.blockState).createInstance();
        this.claw = (ModelData)mat.getModel(AllBlockPartials.ARM_CLAW_BASE, this.blockState).createInstance();
        Instancer clawHalfModel = mat.getModel(AllBlockPartials.ARM_CLAW_GRIP, this.blockState);
        ModelData clawGrip1 = (ModelData)clawHalfModel.createInstance();
        ModelData clawGrip2 = (ModelData)clawHalfModel.createInstance();
        this.clawGrips = Lists.newArrayList((Object[])new ModelData[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new ModelData[]{this.base, this.lowerBody, this.upperBody, this.head, this.claw, clawGrip1, clawGrip2});
        this.arm = tile;
        this.ceiling = (Boolean)this.blockState.method_11654((class_2769)ArmBlock.CEILING);
        this.animateArm(false);
    }

    public void beginFrame() {
        if (this.arm.phase == ArmTileEntity.Phase.DANCING && ((KineticTileEntity)this.blockEntity).getSpeed() != 0.0f) {
            this.animateArm(true);
            this.firstRender = true;
            return;
        }
        float pt = AnimationTickHolder.getPartialTicks();
        float baseAngleNow = this.arm.baseAngle.getValue(pt);
        float lowerArmAngleNow = this.arm.lowerArmAngle.getValue(pt);
        float upperArmAngleNow = this.arm.upperArmAngle.getValue(pt);
        float headAngleNow = this.arm.headAngle.getValue(pt);
        boolean settled = class_3532.method_15347((float)this.baseAngle, (float)baseAngleNow) && class_3532.method_15347((float)this.lowerArmAngle, (float)lowerArmAngleNow) && class_3532.method_15347((float)this.upperArmAngle, (float)upperArmAngleNow) && class_3532.method_15347((float)this.headAngle, (float)headAngleNow);
        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;
        if (!settled || this.firstRender) {
            this.animateArm(false);
        }
        if (this.firstRender) {
            this.firstRender = false;
        }
    }

    private void animateArm(boolean rave) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((class_1936)this.arm.method_10997()) + (float)(((KineticTileEntity)this.blockEntity).hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = this.baseAngle;
            lowerArmAngle = this.lowerArmAngle - 135.0f;
            upperArmAngle = this.upperArmAngle - 90.0f;
            headAngle = this.headAngle;
            color = 0xFFFFFF;
        }
        class_4587 msLocal = new class_4587();
        TransformStack msr = TransformStack.cast((class_4587)msLocal);
        msr.translate((class_2382)this.getInstancePosition());
        msr.centre();
        if (this.ceiling.booleanValue()) {
            msr.rotateX(180.0);
        }
        ArmRenderer.transformBase(msr, baseAngle);
        this.base.setTransform(msLocal);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        this.lowerBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        this.upperBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformHead(msr, headAngle);
        this.head.setTransform(msLocal);
        ArmRenderer.transformClaw(msr);
        this.claw.setTransform(msLocal);
        class_1799 item = this.arm.heldItem;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        boolean hasItem = !item.method_7960();
        boolean isBlockItem = hasItem && item.method_7909() instanceof class_1747 && itemRenderer.method_4019(item, (class_1937)class_310.method_1551().field_1687, null, 0).method_4712();
        for (int index : Iterate.zeroAndOne) {
            msLocal.method_22903();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            this.clawGrips.get(index).setTransform(msLocal);
            msLocal.method_22909();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.models.stream());
    }

    @Override
    protected Instancer<RotatingData> getModel() {
        return this.getRotatingMaterial().getModel(AllBlockPartials.ARM_COG, ((KineticTileEntity)this.blockEntity).method_11010());
    }

    @Override
    public void remove() {
        super.remove();
        this.models.forEach(InstanceData::delete);
    }
}

