/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FunnelMovementBehaviour
implements MovementBehaviour {
    private final boolean hasFilter;

    public static FunnelMovementBehaviour andesite() {
        return new FunnelMovementBehaviour(false);
    }

    public static FunnelMovementBehaviour brass() {
        return new FunnelMovementBehaviour(true);
    }

    private FunnelMovementBehaviour(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        class_2350 facing = FunnelBlock.getFunnelFacing(context.state);
        class_243 vec = class_243.method_24954((class_2382)facing.method_10163());
        if (facing != class_2350.field_11036) {
            return vec.method_1021((Boolean)context.state.method_11654((class_2769)FunnelBlock.EXTRACTING) != false ? 0.15 : 0.65);
        }
        return vec.method_1021(0.65);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        MovementBehaviour.super.visitNewPosition(context, pos);
        if (((Boolean)context.state.method_11654((class_2769)FunnelBlock.EXTRACTING)).booleanValue()) {
            this.extract(context, pos);
        } else {
            this.succ(context, pos);
        }
    }

    private void extract(MovementContext context, class_2338 pos) {
        class_1799 extract;
        class_1937 world = context.world;
        class_243 entityPos = context.position;
        if (context.state.method_11654((class_2769)FunnelBlock.FACING) != class_2350.field_11033) {
            entityPos = entityPos.method_1031(0.0, -0.5, 0.0);
        }
        if (!world.method_8320(pos).method_26220((class_1922)world, pos).method_1110()) {
            return;
        }
        if (!world.method_18467(class_1542.class, new class_238(new class_2338(entityPos))).isEmpty()) {
            return;
        }
        class_1799 filter = this.getFilter(context);
        int filterAmount = context.tileData.method_10550("FilterAmount");
        if (filterAmount <= 0) {
            int n = filterAmount = this.hasFilter ? (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get() : 1;
        }
        if ((extract = ItemHelper.extract((Storage<ItemVariant>)context.contraption.getSharedInventory(), s -> FilterItem.test(world, s, filter), ItemHelper.ExtractionCountMode.UPTO, filterAmount, false)).method_7960()) {
            return;
        }
        if (world.field_9236) {
            return;
        }
        class_1542 entity = new class_1542(world, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, extract);
        entity.method_18799(class_243.field_1353);
        entity.method_6982(5);
        world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.0625f, 0.1f);
        world.method_8649((class_1297)entity);
    }

    private void succ(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        List items = world.method_18467(class_1542.class, new class_238(pos));
        class_1799 filter = this.getFilter(context);
        try (Transaction t = TransferUtil.getTransaction();){
            for (class_1542 item : items) {
                long inserted;
                if (!item.method_5805()) continue;
                class_1799 toInsert = item.method_6983();
                if (!filter.method_7960() && !FilterItem.test(context.world, toInsert, filter) || (inserted = context.contraption.getSharedInventory().insert(ItemVariant.of((class_1799)toInsert), toInsert.method_7947(), (TransactionContext)t)) == 0L) continue;
                if (inserted == (long)toInsert.method_7947()) {
                    item.method_6979(class_1799.field_8037);
                    item.method_31472();
                    continue;
                }
                class_1799 remainder = item.method_6983().method_7972();
                remainder.method_7934(ItemHelper.truncateLong(inserted));
                item.method_6979(remainder);
            }
        }
    }

    @Override
    public boolean renderAsNormalTileEntity() {
        return true;
    }

    private class_1799 getFilter(MovementContext context) {
        return this.hasFilter ? class_1799.method_7915((class_2487)context.tileData.method_10562("Filter")) : class_1799.field_8037;
    }
}

