/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LongAttached;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_3722;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class ValueListDisplaySource
extends DisplaySource {
    static final int ENTRIES_PER_PAGE = 8;

    protected abstract Stream<LongAttached<class_5250>> provideEntries(DisplayLinkContext var1, int var2);

    protected abstract boolean valueFirst();

    @Override
    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        boolean isBook = context.getTargetTE() instanceof class_3722;
        List<class_5250> list = this.provideEntries(context, stats.maxRows() * (isBook ? 8 : 1)).map(e -> this.createComponentsFromEntry(context, (LongAttached<class_5250>)e)).map(l -> {
            class_5250 combined = ((class_5250)l.get(0)).method_10852((class_2561)l.get(1));
            if (l.size() > 2) {
                combined.method_10852((class_2561)l.get(2));
            }
            return combined;
        }).toList();
        if (isBook) {
            list = this.condensePages(list);
        }
        return list;
    }

    private List<class_5250> condensePages(List<class_5250> list) {
        ArrayList<class_5250> condensed = new ArrayList<class_5250>();
        class_5250 current = null;
        for (int i = 0; i < list.size(); ++i) {
            class_5250 atIndex = list.get(i);
            if (current == null) {
                current = atIndex;
                continue;
            }
            current.method_10852((class_2561)Components.literal("\n")).method_10852((class_2561)atIndex);
            if ((i + 1) % 8 != 0) continue;
            condensed.add(current);
            current = null;
        }
        if (current != null) {
            condensed.add(current);
        }
        return condensed;
    }

    @Override
    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        MutableInt highest = new MutableInt(0);
        context.flapDisplayContext = highest;
        return this.provideEntries(context, stats.maxRows()).map(e -> {
            highest.setValue((Number)Math.max((long)highest.getValue().intValue(), (Long)e.getFirst()));
            return this.createComponentsFromEntry(context, (LongAttached<class_5250>)e);
        }).toList();
    }

    protected List<class_5250> createComponentsFromEntry(DisplayLinkContext context, LongAttached<class_5250> entry) {
        long number = (Long)entry.getFirst();
        class_5250 name = ((class_5250)entry.getSecond()).method_10852((class_2561)WHITESPACE);
        if (this.shortenNumbers(context)) {
            Couple<class_5250> shortened = this.shorten(number);
            return this.valueFirst() ? Arrays.asList((class_5250)shortened.getFirst(), (class_5250)shortened.getSecond(), name) : Arrays.asList(name, (class_5250)shortened.getFirst(), (class_5250)shortened.getSecond());
        }
        class_5250 formattedNumber = Components.literal(String.valueOf(number)).method_10852((class_2561)WHITESPACE);
        return this.valueFirst() ? Arrays.asList(formattedNumber, name) : Arrays.asList(name, formattedNumber);
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayTileEntity flapDisplay, FlapDisplayLayout layout) {
        boolean shortenNumbers;
        int valueFormat;
        boolean valueFirst = this.valueFirst();
        String layoutKey = "ValueList_" + valueFirst + "_" + (valueFormat = (shortenNumbers = this.shortenNumbers(context)) ? 0 : Math.max(4, 1 + (int)Math.log10(((MutableInt)context.flapDisplayContext).intValue())));
        if (layout.isLayout(layoutKey)) {
            return;
        }
        int maxCharCount = flapDisplay.getMaxCharCount(1);
        int numberLength = Math.min(maxCharCount, Math.max(3, valueFormat));
        int nameLength = Math.max(maxCharCount - numberLength - (shortenNumbers ? 1 : 0), 0);
        FlapDisplaySection name = new FlapDisplaySection(7.0f * (float)nameLength, "alphabet", false, !valueFirst);
        FlapDisplaySection value = new FlapDisplaySection(7.0f * (float)numberLength, "number", false, !shortenNumbers && valueFirst).rightAligned();
        if (shortenNumbers) {
            FlapDisplaySection suffix = new FlapDisplaySection(7.0f, "shortened_numbers", false, valueFirst);
            layout.configure(layoutKey, valueFirst ? Arrays.asList(value, suffix, name) : Arrays.asList(name, value, suffix));
            return;
        }
        layout.configure(layoutKey, valueFirst ? Arrays.asList(value, name) : Arrays.asList(name, value));
    }

    private Couple<class_5250> shorten(long number) {
        if (number >= 1000000L) {
            return Couple.create(Components.literal(String.valueOf(number / 1000000L)), Lang.translateDirect("display_source.value_list.million", new Object[0]).method_10852((class_2561)WHITESPACE));
        }
        if (number >= 1000L) {
            return Couple.create(Components.literal(String.valueOf(number / 1000L)), Lang.translateDirect("display_source.value_list.thousand", new Object[0]).method_10852((class_2561)WHITESPACE));
        }
        return Couple.create(Components.literal(String.valueOf(number)), WHITESPACE);
    }

    protected boolean shortenNumbers(DisplayLinkContext context) {
        return context.sourceConfig().method_10550("Format") == 0;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        if (isFirstLine) {
            this.addFullNumberConfig(builder);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void addFullNumberConfig(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(0, 75, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.value_list", "shortened", "full_number")).titled(Lang.translateDirect("display_source.value_list.display", new Object[0])), "Format");
    }
}

