/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.DisplayLinkTileEntity;
import com.simibubi.create.content.logistics.block.display.source.AccumulatedItemCountDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import net.minecraft.class_5250;

public class ItemThroughputDisplaySource
extends AccumulatedItemCountDisplaySource {
    static final int POOL_SIZE = 10;

    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        class_2487 conf = context.sourceConfig();
        if (conf.method_10545("Inactive")) {
            return ZERO.method_27661();
        }
        double interval = 20.0 * Math.pow(60.0, conf.method_10550("Interval"));
        double rate = (double)conf.method_10583("Rate") * interval;
        if (rate > 0.0) {
            int lastAmount;
            double timeBetweenStacks;
            long previousTime = conf.method_10537("LastReceived");
            long gameTime = context.te().method_10997().method_8510();
            int diff = (int)(gameTime - previousTime);
            if (diff > 0 && (double)diff > (timeBetweenStacks = (double)(lastAmount = conf.method_10550("LastReceivedAmount")) / rate) * 2.0) {
                conf.method_10556("Inactive", true);
            }
        }
        return Lang.number(rate).component();
    }

    @Override
    public void itemReceived(DisplayLinkTileEntity te, int amount) {
        if (te.method_11010().method_28500((class_2769)DisplayLinkBlock.POWERED).orElse(true).booleanValue()) {
            return;
        }
        class_2487 conf = te.getSourceConfig();
        long gameTime = te.method_10997().method_8510();
        if (!conf.method_10545("LastReceived")) {
            conf.method_10544("LastReceived", gameTime);
            return;
        }
        long previousTime = conf.method_10537("LastReceived");
        class_2499 rates = conf.method_10554("PrevRates", 5);
        if (rates.size() != 10) {
            rates = new class_2499();
            for (int i = 0; i < 10; ++i) {
                rates.add((Object)class_2494.method_23244((float)-1.0f));
            }
        }
        int poolIndex = conf.method_10550("Index") % 10;
        rates.method_10606(poolIndex, (class_2520)class_2494.method_23244((float)((float)((double)amount / (double)(gameTime - previousTime)))));
        float rate = 0.0f;
        int validIntervals = 0;
        for (int i = 0; i < 10; ++i) {
            float pooledRate = rates.method_10604(i);
            if (!(pooledRate >= 0.0f)) continue;
            rate += pooledRate;
            ++validIntervals;
        }
        conf.method_10551("Rate");
        if (validIntervals > 0) {
            conf.method_10548("Rate", rate /= (float)validIntervals);
        }
        conf.method_10551("Inactive");
        conf.method_10569("LastReceivedAmount", amount);
        conf.method_10544("LastReceived", gameTime);
        conf.method_10569("Index", poolIndex + 1);
        conf.method_10566("PrevRates", (class_2520)rates);
        te.updateGatheredData();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 80, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.item_throughput.interval", "second", "minute", "hour")).titled(Lang.translateDirect("display_source.item_throughput.interval", new Object[0])), "Interval");
    }

    @Override
    protected String getTranslationKey() {
        return "item_throughput";
    }
}

