/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.armor.BackTankUtil;
import com.simibubi.create.content.curiosities.weapons.BuiltinPotatoProjectileTypes;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonPacket;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonProjectileType;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileEntity;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileTypeManager;
import com.simibubi.create.content.curiosities.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.item.EntitySwingListenerItem;
import io.github.fabricators_of_create.porting_lib.item.ReequipAnimationItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class PotatoCannonItem
extends class_1811
implements EntitySwingListenerItem,
ReequipAnimationItem {
    public static class_1799 CLIENT_CURRENT_AMMO = class_1799.field_8037;
    public static final int MAX_DAMAGE = 100;

    public PotatoCannonItem(class_1792.class_1793 properties) {
        super(properties.method_7898(100));
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        return this.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
    }

    public boolean method_31567(class_1799 stack) {
        return BackTankUtil.isBarVisible(stack, this.maxUses());
    }

    public int method_31569(class_1799 stack) {
        return BackTankUtil.getBarWidth(stack, this.maxUses());
    }

    public int method_31571(class_1799 stack) {
        return BackTankUtil.getBarColor(stack, this.maxUses());
    }

    private int maxUses() {
        return (Integer)AllConfigs.SERVER.curiosities.maxPotatoCannonShots.get();
    }

    public boolean isCannon(class_1799 stack) {
        return stack.method_7909() instanceof PotatoCannonItem;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        return this.findAmmoInInventory(world, player, stack).map(itemStack -> {
            if (ShootableGadgetItemMethods.shouldSwap(player, stack, hand, this::isCannon)) {
                return class_1271.method_22431((Object)stack);
            }
            if (world.field_9236) {
                CreateClient.POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
                return class_1271.method_22427((Object)stack);
            }
            class_243 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == class_1268.field_5808, new class_243(0.75, (double)-0.15f, 1.5));
            class_243 correction = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == class_1268.field_5808, new class_243((double)-0.05f, 0.0, 0.0)).method_1020(player.method_19538().method_1031(0.0, (double)player.method_5751(), 0.0));
            PotatoCannonProjectileType projectileType = PotatoProjectileTypeManager.getTypeForStack(itemStack).orElse(BuiltinPotatoProjectileTypes.FALLBACK);
            class_243 lookVec = player.method_5720();
            class_243 motion = lookVec.method_1019(correction).method_1029().method_1021(2.0).method_1021((double)projectileType.getVelocityMultiplier());
            float soundPitch = projectileType.getSoundPitch() + (Create.RANDOM.nextFloat() - 0.5f) / 4.0f;
            boolean spray = projectileType.getSplit() > 1;
            class_243 sprayBase = VecHelper.rotate(new class_243(0.0, 0.1, 0.0), 360.0f * Create.RANDOM.nextFloat(), class_2350.class_2351.field_11051);
            float sprayChange = 360.0f / (float)projectileType.getSplit();
            for (int i = 0; i < projectileType.getSplit(); ++i) {
                PotatoProjectileEntity projectile = (PotatoProjectileEntity)AllEntityTypes.POTATO_PROJECTILE.create(world);
                projectile.setItem((class_1799)itemStack);
                projectile.setEnchantmentEffectsFromCannon(stack);
                class_243 splitMotion = motion;
                if (spray) {
                    float imperfection = 40.0f * (Create.RANDOM.nextFloat() - 0.5f);
                    class_243 sprayOffset = VecHelper.rotate(sprayBase, (float)i * sprayChange + imperfection, class_2350.class_2351.field_11051);
                    splitMotion = splitMotion.method_1019(VecHelper.lookAt(sprayOffset, motion));
                }
                if (i != 0) {
                    projectile.recoveryChance = 0.0f;
                }
                projectile.method_5814(barrelPos.field_1352, barrelPos.field_1351, barrelPos.field_1350);
                projectile.method_18799(splitMotion);
                projectile.method_7432((class_1297)player);
                world.method_8649((class_1297)projectile);
            }
            if (!player.method_7337()) {
                itemStack.method_7934(1);
                if (itemStack.method_7960()) {
                    player.method_31548().method_7378(itemStack);
                }
            }
            if (!BackTankUtil.canAbsorbDamage((class_1309)player, this.maxUses())) {
                stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
            Integer cooldown = this.findAmmoInInventory(world, player, stack).flatMap(PotatoProjectileTypeManager::getTypeForStack).map(PotatoCannonProjectileType::getReloadTicks).orElse(10);
            ShootableGadgetItemMethods.applyCooldown(player, stack, hand, this::isCannon, cooldown);
            ShootableGadgetItemMethods.sendPackets(player, b -> new PotatoCannonPacket(barrelPos, lookVec.method_1029(), (class_1799)itemStack, hand, soundPitch, (boolean)b));
            return class_1271.method_22427((Object)stack);
        }).orElse(class_1271.method_22430((Object)stack));
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return slotChanged || newStack.method_7909() != oldStack.method_7909();
    }

    private Optional<class_1799> findAmmoInInventory(class_1937 world, class_1657 player, class_1799 held) {
        class_1799 findAmmo = player.method_18808(held);
        return PotatoProjectileTypeManager.getTypeForStack(findAmmo).map($ -> findAmmo);
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<class_1799> getAmmoforPreview(class_1799 cannon) {
        if (AnimationTickHolder.getTicks() % 3 != 0) {
            return Optional.of(CLIENT_CURRENT_AMMO).filter(stack -> !stack.method_7960());
        }
        class_746 player = class_310.method_1551().field_1724;
        CLIENT_CURRENT_AMMO = class_1799.field_8037;
        if (player == null) {
            return Optional.empty();
        }
        class_1799 findAmmo = player.method_18808(cannon);
        Optional<class_1799> found = PotatoProjectileTypeManager.getTypeForStack(findAmmo).map($ -> findAmmo);
        found.ifPresent(stack -> {
            CLIENT_CURRENT_AMMO = stack;
        });
        return found;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        int power = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
        int punch = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack);
        float additionalDamageMult = 1.0f + (float)power * 0.2f;
        float additionalKnockback = (float)punch * 0.5f;
        PotatoCannonItem.getAmmoforPreview(stack).ifPresent(ammo -> {
            String _attack = "potato_cannon.ammo.attack_damage";
            String _reload = "potato_cannon.ammo.reload_ticks";
            String _knockback = "potato_cannon.ammo.knockback";
            tooltip.add(Components.immutableEmpty());
            tooltip.add((class_2561)Components.translatable(ammo.method_7922()).method_10852((class_2561)Components.literal(":")).method_27692(class_124.field_1080));
            PotatoCannonProjectileType type = PotatoProjectileTypeManager.getTypeForStack(ammo).get();
            class_5250 spacing = Components.literal(" ");
            class_124 green = class_124.field_1060;
            class_124 darkGreen = class_124.field_1077;
            float damageF = (float)type.getDamage() * additionalDamageMult;
            class_5250 damage = Components.literal(damageF == (float)class_3532.method_15375((float)damageF) ? "" + class_3532.method_15375((float)damageF) : "" + damageF);
            class_5250 reloadTicks = Components.literal("" + type.getReloadTicks());
            class_5250 knockback = Components.literal("" + (type.getKnockback() + additionalKnockback));
            damage = damage.method_27692(additionalDamageMult > 1.0f ? green : darkGreen);
            knockback = knockback.method_27692(additionalKnockback > 0.0f ? green : darkGreen);
            reloadTicks = reloadTicks.method_27692(darkGreen);
            tooltip.add((class_2561)spacing.method_27662().method_10852((class_2561)Lang.translateDirect(_attack, damage).method_27692(darkGreen)));
            tooltip.add((class_2561)spacing.method_27662().method_10852((class_2561)Lang.translateDirect(_reload, reloadTicks).method_27692(darkGreen)));
            tooltip.add((class_2561)spacing.method_27662().method_10852((class_2561)Lang.translateDirect(_knockback, knockback).method_27692(darkGreen)));
        });
        super.method_7851(stack, world, tooltip, flag);
    }

    public Predicate<class_1799> method_19268() {
        return stack -> PotatoProjectileTypeManager.getTypeForStack(stack).isPresent();
    }

    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        return true;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public int method_24792() {
        return 15;
    }
}

