/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ToolboxHandler {
    public static final WorldAttached<WeakHashMap<class_2338, ToolboxTileEntity>> toolboxes = new WorldAttached<WeakHashMap>(w -> new WeakHashMap());
    static int validationTimer = 20;

    public static void onLoad(ToolboxTileEntity te) {
        toolboxes.get((class_1936)te.method_10997()).put(te.method_11016(), te);
    }

    public static void onUnload(ToolboxTileEntity te) {
        toolboxes.get((class_1936)te.method_10997()).remove(te.method_11016());
    }

    public static void entityTick(class_1297 entity, class_1937 world) {
        if (world.field_9236) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        if (!(entity instanceof class_3222)) {
            return;
        }
        if (entity.field_6012 % validationTimer != 0) {
            return;
        }
        class_3222 player = (class_3222)entity;
        if (!player.getExtraCustomData().method_10545("CreateToolboxData")) {
            return;
        }
        boolean sendData = false;
        class_2487 compound = player.getExtraCustomData().method_10562("CreateToolboxData");
        for (int i = 0; i < 9; ++i) {
            String key = String.valueOf(i);
            if (!compound.method_10545(key)) continue;
            class_2487 data = compound.method_10562(key);
            class_2338 pos = class_2512.method_10691((class_2487)data.method_10562("Pos"));
            int slot = data.method_10550("Slot");
            if (!world.method_8477(pos)) continue;
            if (!(world.method_8320(pos).method_26204() instanceof ToolboxBlock)) {
                compound.method_10551(key);
                sendData = true;
                continue;
            }
            class_2586 prevBlockEntity = world.method_8321(pos);
            if (!(prevBlockEntity instanceof ToolboxTileEntity)) continue;
            ((ToolboxTileEntity)prevBlockEntity).connectPlayer(slot, (class_1657)player, i);
        }
        if (sendData) {
            ToolboxHandler.syncData((class_1657)player);
        }
    }

    public static void playerLogin(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        if (player.getExtraCustomData().method_10545("CreateToolboxData") && !player.getExtraCustomData().method_10562("CreateToolboxData").method_33133()) {
            ToolboxHandler.syncData(player);
        }
    }

    public static void syncData(class_1657 player) {
        AllPackets.channel.sendToClient((S2CPacket)new ISyncPersistentData.PersistentDataPacket((class_1297)player), (class_3222)player);
    }

    public static List<ToolboxTileEntity> getNearest(class_1936 world, class_1657 player, int maxAmount) {
        class_243 location = player.method_19538();
        double maxRange = ToolboxHandler.getMaxRange(player);
        return toolboxes.get(world).keySet().stream().filter(p -> ToolboxHandler.distance(location, p) < maxRange * maxRange).sorted((p1, p2) -> Double.compare(ToolboxHandler.distance(location, p1), ToolboxHandler.distance(location, p2))).limit(maxAmount).map(toolboxes.get(world)::get).filter(ToolboxTileEntity::isFullyInitialized).collect(Collectors.toList());
    }

    public static void unequip(class_1657 player, int hotbarSlot, boolean keepItems) {
        class_2487 compound = player.getExtraCustomData().method_10562("CreateToolboxData");
        class_1937 world = player.field_6002;
        String key = String.valueOf(hotbarSlot);
        if (!compound.method_10545(key)) {
            return;
        }
        class_2487 prevData = compound.method_10562(key);
        class_2338 prevPos = class_2512.method_10691((class_2487)prevData.method_10562("Pos"));
        int prevSlot = prevData.method_10550("Slot");
        class_2586 prevBlockEntity = world.method_8321(prevPos);
        if (prevBlockEntity instanceof ToolboxTileEntity) {
            ToolboxTileEntity toolbox = (ToolboxTileEntity)prevBlockEntity;
            toolbox.unequip(prevSlot, player, hotbarSlot, keepItems || !ToolboxHandler.withinRange(player, toolbox));
        }
        compound.method_10551(key);
    }

    public static boolean withinRange(class_1657 player, ToolboxTileEntity box) {
        if (player.field_6002 != box.method_10997()) {
            return false;
        }
        double maxRange = ToolboxHandler.getMaxRange(player);
        return ToolboxHandler.distance(player.method_19538(), box.method_11016()) < maxRange * maxRange;
    }

    public static double distance(class_243 location, class_2338 p) {
        return location.method_1028((double)((float)p.method_10263() + 0.5f), (double)p.method_10264(), (double)((float)p.method_10260() + 0.5f));
    }

    public static double getMaxRange(class_1657 player) {
        return ((Integer)AllConfigs.SERVER.curiosities.toolboxRange.get()).doubleValue();
    }
}

