/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.armor;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_746;

public class BackTankUtil {
    public static class_1799 get(class_1309 entity) {
        for (class_1799 itemStack : entity.method_5661()) {
            if (itemStack.method_7960() || !AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(itemStack)) continue;
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public static boolean hasAirRemaining(class_1799 backtank) {
        return BackTankUtil.getAir(backtank) > 0.0f;
    }

    public static float getAir(class_1799 backtank) {
        class_2487 tag = backtank.method_7948();
        return Math.min(tag.method_10583("Air"), (float)BackTankUtil.maxAir(backtank));
    }

    public static void consumeAir(class_1309 entity, class_1799 backtank, float i) {
        class_2487 tag = backtank.method_7948();
        int maxAir = BackTankUtil.maxAir(backtank);
        float air = BackTankUtil.getAir(backtank);
        float newAir = air - i;
        tag.method_10548("Air", Math.min(newAir, (float)maxAir));
        backtank.method_7980(tag);
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        BackTankUtil.sendWarning(player, air, newAir, (float)maxAir / 10.0f);
        BackTankUtil.sendWarning(player, air, newAir, 1.0f);
    }

    private static void sendWarning(class_3222 player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        class_5250 component = Lang.translateDirect(depleted ? "backtank.depleted" : "backtank.low", new Object[0]);
        AllSoundEvents.DENY.play(player.field_6002, null, (class_2382)player.method_24515(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.field_6002, null, (class_2382)player.method_24515(), 0.5f, 0.5f);
        player.field_13987.method_14364((class_2596)new class_5905(10, 40, 10));
        player.field_13987.method_14364((class_2596)new class_5903((class_2561)Components.literal("\u26a0 ").method_27692(depleted ? class_124.field_1061 : class_124.field_1065).method_10852((class_2561)component.method_27692(class_124.field_1080))));
        player.field_13987.method_14364((class_2596)new class_5904(Components.immutableEmpty()));
    }

    public static int maxAir(class_1799 backtank) {
        return BackTankUtil.maxAir(class_1890.method_8225((class_1887)((class_1887)AllEnchantments.CAPACITY.get()), (class_1799)backtank));
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.SERVER.curiosities.airInBacktank.get() + (Integer)AllConfigs.SERVER.curiosities.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.SERVER.curiosities.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(class_1309 entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof class_1657 && ((class_1657)entity).method_7337()) {
            return true;
        }
        class_1799 backtank = BackTankUtil.get(entity);
        if (backtank.method_7960()) {
            return false;
        }
        if (!BackTankUtil.hasAirRemaining(backtank)) {
            return false;
        }
        float cost = (float)BackTankUtil.maxAirWithoutEnchants() / (float)usesPerTank;
        BackTankUtil.consumeAir(entity, backtank, cost);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isBarVisible(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1799 backtank = BackTankUtil.get((class_1309)player);
        if (backtank.method_7960() || !BackTankUtil.hasAirRemaining(backtank)) {
            return stack.method_7986();
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static int getBarWidth(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 13;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return 13;
        }
        class_1799 backtank = BackTankUtil.get((class_1309)player);
        if (backtank.method_7960() || !BackTankUtil.hasAirRemaining(backtank)) {
            return Math.round(13.0f - (float)stack.method_7919() / (float)stack.method_7936() * 13.0f);
        }
        return backtank.method_7909().method_31569(backtank);
    }

    @Environment(value=EnvType.CLIENT)
    public static int getBarColor(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return 0;
        }
        class_1799 backtank = BackTankUtil.get((class_1309)player);
        if (backtank.method_7960() || !BackTankUtil.hasAirRemaining(backtank)) {
            return class_3532.method_15369((float)(Math.max(0.0f, 1.0f - (float)stack.method_7919() / (float)stack.method_7936()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtank.method_7909().method_31571(backtank);
    }
}

