/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;

public class BasinRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(BasinTileEntity basin, class_1860<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.method_8110());
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return BasinRecipe.apply(basin, recipe, true);
    }

    public static boolean apply(BasinTileEntity basin, class_1860<?> recipe) {
        return BasinRecipe.apply(basin, recipe, false);
    }

    private static boolean apply(BasinTileEntity basin, class_1860<?> recipe, boolean test) {
        boolean isBasinRecipe = recipe instanceof BasinRecipe;
        Storage<ItemVariant> availableItems = basin.getItemStorage(null);
        Storage<FluidVariant> availableFluids = basin.getFluidStorage(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinTileEntity.getHeatLevelOf(basin.method_10997().method_8320(basin.method_11016().method_10087(1)));
        if (isBasinRecipe && !((BasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<class_1799> recipeOutputItems = new ArrayList<class_1799>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList<class_1856> ingredients = new LinkedList<class_1856>((Collection<class_1856>)recipe.method_8117());
        ingredients.sort(Comparator.comparingInt(i -> i.method_8105().length));
        List<FluidIngredient> fluidIngredients = isBasinRecipe ? ((BasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        try (Transaction t = TransferUtil.getTransaction();){
            block8: for (class_1856 ingredient : ingredients) {
                for (StorageView view : availableItems.iterable((TransactionContext)t)) {
                    ItemVariant var;
                    class_1799 stack;
                    if (view.isResourceBlank() || !ingredient.method_8093(stack = (var = (ItemVariant)view.getResource()).toStack())) continue;
                    if (stack.method_7909().method_7858() == stack.method_7909()) continue block8;
                    long extracted = view.extract((Object)var, 1L, (TransactionContext)t);
                    if (extracted == 0L) continue;
                    if (!stack.method_7909().method_7857()) continue block8;
                    recipeOutputItems.add(stack.method_7909().method_7858().method_7854());
                    continue block8;
                }
                boolean bl = false;
                return bl;
            }
            boolean fluidsAffected = false;
            block10: for (FluidIngredient fluidIngredient : fluidIngredients) {
                long amountRequired = fluidIngredient.getRequiredAmount();
                for (StorageView view : availableFluids.iterable((TransactionContext)t)) {
                    FluidStack fluidStack;
                    if (view.isResourceBlank() || !fluidIngredient.test(fluidStack = new FluidStack(view))) continue;
                    long drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (view.extract((Object)fluidStack.getType(), drainedAmount, (TransactionContext)t) != drainedAmount) continue;
                    fluidsAffected = true;
                    if ((amountRequired -= drainedAmount) == 0L) continue block10;
                }
                boolean bl = false;
                return bl;
            }
            if (fluidsAffected) {
                TransactionCallback.onSuccess((TransactionContext)t, () -> {
                    basin.getBehaviour(SmartFluidTankBehaviour.INPUT).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                    basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                });
            }
            if (recipe instanceof BasinRecipe) {
                recipeOutputItems.addAll(((BasinRecipe)recipe).rollResults());
                recipeOutputFluids.addAll((Collection<FluidStack>)((BasinRecipe)recipe).getFluidResults());
            } else {
                recipeOutputItems.add(recipe.method_8110());
            }
            if (!basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, (TransactionContext)t)) {
                boolean bl = false;
                return bl;
            }
            if (!test) {
                t.commit();
            }
            boolean bl = true;
            return bl;
        }
    }

    public static BasinRecipe convertShapeless(class_1860<?> recipe) {
        BasinRecipe basinRecipe = new ProcessingRecipeBuilder<BasinRecipe>(BasinRecipe::new, recipe.method_8114()).withItemIngredients((class_2371<class_1856>)recipe.method_8117()).withSingleItemOutput(recipe.method_8110()).build();
        return basinRecipe;
    }

    protected BasinRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public BasinRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(AllRecipeTypes.BASIN, params);
    }

    @Override
    protected int getMaxInputCount() {
        return 9;
    }

    @Override
    protected int getMaxOutputCount() {
        return 4;
    }

    @Override
    protected int getMaxFluidInputCount() {
        return 2;
    }

    @Override
    protected int getMaxFluidOutputCount() {
        return 2;
    }

    @Override
    protected boolean canRequireHeat() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull class_1937 worldIn) {
        return false;
    }
}

