/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PumpTileEntity
extends KineticTileEntity {
    LerpedFloat arrowDirection = LerpedFloat.linear().startWithValue(1.0);
    Couple<MutableBoolean> sidesToUpdate = Couple.create(MutableBoolean::new);
    boolean pressureUpdate;
    boolean reversed;

    public PumpTileEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new PumpFluidTransferBehaviour(this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
        this.registerAwardables(behaviours, AllAdvancements.PUMP);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reversed = this.getSpeed() < 0.0f;
    }

    @Override
    public void tick() {
        super.tick();
        float speed = this.getSpeed();
        if (this.field_11863.field_9236) {
            if (speed == 0.0f) {
                return;
            }
            this.arrowDirection.chase(speed >= 0.0f ? 1.0 : -1.0, 0.5, LerpedFloat.Chaser.EXP);
            this.arrowDirection.tickChaser();
            if (!this.isVirtual()) {
                return;
            }
        }
        this.sidesToUpdate.forEachWithContext((update, isFront) -> {
            if (update.isFalse()) {
                return;
            }
            update.setFalse();
            this.distributePressureTo(isFront != false ? this.getFront() : this.getFront().method_10153());
        });
        if (speed == 0.0f) {
            return;
        }
        if (speed < 0.0f != this.reversed) {
            this.reversed = speed < 0.0f;
            this.updatePressureChange();
            return;
        }
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (previousSpeed == this.getSpeed()) {
            return;
        }
        if (this.speed != 0.0f) {
            this.reversed = this.speed < 0.0f;
            this.award(AllAdvancements.PUMP);
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        this.updatePressureChange();
    }

    public void updatePressureChange() {
        this.pressureUpdate = false;
        class_2338 frontPos = this.field_11867.method_10093(this.getFront());
        class_2338 backPos = this.field_11867.method_10093(this.getFront().method_10153());
        FluidPropagator.propagateChangedPipe((class_1936)this.field_11863, frontPos, this.field_11863.method_8320(frontPos));
        FluidPropagator.propagateChangedPipe((class_1936)this.field_11863, backPos, this.field_11863.method_8320(backPos));
        FluidTransportBehaviour behaviour = this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.wipePressure();
        }
        this.sidesToUpdate.forEach(MutableBoolean::setTrue);
    }

    protected void distributePressureTo(class_2350 side) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockFace start = new BlockFace(this.field_11867, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<class_2338, Pair<Integer, Map<class_2350, Boolean>>> pipeGraph = new HashMap<class_2338, Pair<Integer, Map<class_2350, Boolean>>>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks(this.field_11863, this.field_11867, side.method_10153());
        }
        if (!this.hasReachedValidEndpoint((class_1936)this.field_11863, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.field_11867, $ -> Pair.of(0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of(1, new IdentityHashMap())).getSecond()).put(side.method_10153(), !pull);
            ArrayList<Pair<Integer, class_2338>> frontier = new ArrayList<Pair<Integer, class_2338>>();
            HashSet<class_2338> visited = new HashSet<class_2338>();
            int maxDistance = FluidPropagator.getPumpRange();
            frontier.add(Pair.of(1, start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                class_2338 currentPos = (class_2338)entry.getSecond();
                if (!this.field_11863.method_8477(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                class_2680 currentState = this.field_11863.method_8320(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((class_1922)this.field_11863, currentPos);
                if (pipe == null) continue;
                for (class_2350 face : FluidPropagator.getPipeConnections(currentState, pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    class_2338 connectedPos = blockFace.getConnectedPos();
                    if (!this.field_11863.method_8477(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((class_1936)this.field_11863, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((class_1922)this.field_11863, connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof PumpFluidTransferBehaviour || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of(distance + 1, new IdentityHashMap())).getSecond()).put(face.method_10153(), !pull);
                    frontier.add(Pair.of(distance + 1, connectedPos));
                }
            }
        }
        HashMap<Integer, Set<BlockFace>> validFaces = new HashMap<Integer, Set<BlockFace>>();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = Math.abs(this.getSpeed());
        for (Set set : validFaces.values()) {
            int parallelBranches = set.size();
            for (BlockFace face : set) {
                class_2338 pipePos = face.getPos();
                class_2350 pipeSide = face.getFace();
                if (pipePos.equals((Object)this.field_11867)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((class_1922)this.field_11863, pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    protected boolean searchForEndpointRecursively(Map<class_2338, Pair<Integer, Map<class_2350, Boolean>>> pipeGraph, Set<BlockFace> targets, Map<Integer, Set<BlockFace>> validFaces, BlockFace currentFace, boolean pull) {
        class_2338 currentPos = currentFace.getPos();
        if (!pipeGraph.containsKey(currentPos)) {
            return false;
        }
        Pair<Integer, Map<class_2350, Boolean>> pair = pipeGraph.get(currentPos);
        int distance = pair.getFirst();
        boolean atLeastOneBranchSuccessful = false;
        for (class_2350 nextFacing : Iterate.directions) {
            Map<class_2350, Boolean> map;
            if (nextFacing == currentFace.getFace() || !(map = pair.getSecond()).containsKey(nextFacing)) continue;
            BlockFace localTarget = new BlockFace(currentPos, nextFacing);
            if (targets.contains(localTarget)) {
                validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
                atLeastOneBranchSuccessful = true;
                continue;
            }
            if (map.get(nextFacing) != pull || !this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(currentPos.method_10093(nextFacing), nextFacing.method_10153()), pull)) continue;
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
            atLeastOneBranchSuccessful = true;
        }
        if (atLeastOneBranchSuccessful) {
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(currentFace);
        }
        return atLeastOneBranchSuccessful;
    }

    private boolean hasReachedValidEndpoint(class_1936 world, BlockFace blockFace, boolean pull) {
        Storage capability;
        class_2338 connectedPos = blockFace.getConnectedPos();
        class_2680 connectedState = world.method_8320(connectedPos);
        class_2586 tileEntity = world.method_8321(connectedPos);
        class_2350 face = blockFace.getFace();
        if (PumpBlock.isPump(connectedState) && ((class_2350)connectedState.method_11654((class_2769)PumpBlock.FACING)).method_10166() == face.method_10166() && tileEntity instanceof PumpTileEntity) {
            PumpTileEntity pumpTE = (PumpTileEntity)tileEntity;
            return pumpTE.isPullingOnSide(pumpTE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((class_1922)world, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (tileEntity != null && (capability = TransferUtil.getFluidStorage((class_2586)tileEntity, (class_2350)face.method_10153())) != null) {
            return true;
        }
        return FluidPropagator.isOpenEnd((class_1922)world, blockFace.getPos(), face);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Reversed", this.reversed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.reversed = compound.method_10577("Reversed");
        super.read(compound, clientPacket);
    }

    public void updatePipesOnSide(class_2350 side) {
        if (!this.isSideAccessible(side)) {
            return;
        }
        this.updatePipeNetwork(this.isFront(side));
        this.getBehaviour(FluidTransportBehaviour.TYPE).wipePressure();
    }

    protected boolean isFront(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock)) {
            return false;
        }
        class_2350 front = (class_2350)blockState.method_11654((class_2769)PumpBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Nullable
    protected class_2350 getFront() {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock)) {
            return null;
        }
        return (class_2350)blockState.method_11654((class_2769)PumpBlock.FACING);
    }

    protected void updatePipeNetwork(boolean front) {
        this.sidesToUpdate.get(front).setTrue();
    }

    public boolean isSideAccessible(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock)) {
            return false;
        }
        return ((class_2350)blockState.method_11654((class_2769)PumpBlock.FACING)).method_10166() == side.method_10166();
    }

    public boolean isPullingOnSide(boolean front) {
        return front == this.reversed;
    }

    class PumpFluidTransferBehaviour
    extends FluidTransportBehaviour {
        public PumpFluidTransferBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = PumpTileEntity.this.isPullingOnSide(PumpTileEntity.this.isFront((class_2350)entry.getKey()));
                Couple<Float> pressure = ((PipeConnection)entry.getValue()).pressure;
                pressure.set(pull, Float.valueOf(Math.abs(PumpTileEntity.this.getSpeed())));
                pressure.set(!pull, Float.valueOf(0.0f));
            }
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return PumpTileEntity.this.isSideAccessible(direction);
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

