/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.content.contraptions.fluids.FlowSource;
import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.FluidNetwork;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.OpenEndedPipe;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.tterrag.registrate.fabric.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3612;

public class PipeConnection {
    public class_2350 side;
    Couple<Float> pressure;
    Optional<FlowSource> source;
    Optional<FlowSource> previousSource;
    Optional<Flow> flow;
    boolean particleSplashNextTick;
    Optional<FluidNetwork> network;
    public static final int MAX_PARTICLE_RENDER_DISTANCE = 20;
    public static final int SPLASH_PARTICLE_AMOUNT = 1;
    public static final float IDLE_PARTICLE_SPAWN_CHANCE = 0.001f;
    public static final float RIM_RADIUS = 0.265625f;
    public static final Random r = new Random();

    public PipeConnection(class_2350 side) {
        this.side = side;
        this.pressure = Couple.create(() -> Float.valueOf(0.0f));
        this.flow = Optional.empty();
        this.previousSource = Optional.empty();
        this.source = Optional.empty();
        this.network = Optional.empty();
        this.particleSplashNextTick = false;
    }

    public FluidStack getProvidedFluid() {
        FluidStack empty = FluidStack.EMPTY;
        if (!this.hasFlow()) {
            return empty;
        }
        Flow flow = this.flow.get();
        if (!flow.inbound) {
            return empty;
        }
        if (!flow.complete) {
            return empty;
        }
        return flow.fluid;
    }

    public boolean flipFlowsIfPressureReversed() {
        if (!this.hasFlow()) {
            return false;
        }
        boolean singlePressure = this.comparePressure() != 0.0f && (this.getInboundPressure() == 0.0f || this.getOutwardPressure() == 0.0f);
        Flow flow = this.flow.get();
        if (!singlePressure || this.comparePressure() < 0.0f == flow.inbound) {
            return false;
        }
        boolean bl = flow.inbound = !flow.inbound;
        if (!flow.complete) {
            this.flow = Optional.empty();
        }
        return true;
    }

    public void manageSource(class_1937 world, class_2338 pos) {
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return;
        }
        FlowSource flowSource = this.source.get();
        flowSource.manageSource(world);
    }

    public boolean manageFlows(class_1937 world, class_2338 pos, FluidStack internalFluid, Predicate<FluidStack> extractionPredicate) {
        FluidStack provided;
        Optional<FluidNetwork> retainedNetwork = this.network;
        this.network = Optional.empty();
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return false;
        }
        FlowSource flowSource = this.source.get();
        if (!this.hasFlow()) {
            if (!this.hasPressure()) {
                return false;
            }
            boolean prioritizeInbound = this.comparePressure() < 0.0f;
            for (boolean trueFalse : Iterate.trueAndFalse) {
                boolean inbound;
                boolean bl = inbound = prioritizeInbound == trueFalse;
                if (this.pressure.get(inbound).floatValue() == 0.0f || !this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid)) continue;
                return true;
            }
            return false;
        }
        Flow flow = this.flow.get();
        FluidStack fluidStack = provided = flow.inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid;
        if (!this.hasPressure() || provided.isEmpty() || !provided.isFluidEqual(flow.fluid)) {
            this.flow = Optional.empty();
            return true;
        }
        if (flow.inbound != this.comparePressure() < 0.0f) {
            boolean inbound;
            boolean bl = inbound = !flow.inbound;
            if (inbound && !provided.isEmpty() || !inbound && !internalFluid.isEmpty()) {
                FluidPropagator.resetAffectedFluidNetworks(world, pos, this.side);
                this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid);
                return true;
            }
        }
        flowSource.whileFlowPresent(world, flow.inbound);
        if (!flowSource.isEndpoint()) {
            return false;
        }
        if (!flow.inbound) {
            return false;
        }
        this.network = retainedNetwork;
        if (!this.hasNetwork()) {
            this.network = Optional.of(new FluidNetwork(world, new BlockFace(pos, this.side), flowSource::provideHandler));
        }
        this.network.get().tick();
        return false;
    }

    private boolean tryStartingNewFlow(boolean inbound, FluidStack providedFluid) {
        if (providedFluid.isEmpty()) {
            return false;
        }
        Flow flow = new Flow(inbound, providedFluid);
        this.flow = Optional.of(flow);
        return true;
    }

    public boolean determineSource(class_1937 world, class_2338 pos) {
        class_2338 relative = pos.method_10093(this.side);
        if (world.method_8402(relative.method_10263() >> 4, relative.method_10260() >> 4, class_2806.field_12803, false) == null) {
            return false;
        }
        BlockFace location = new BlockFace(pos, this.side);
        if (FluidPropagator.isOpenEnd((class_1922)world, pos, this.side)) {
            this.source = this.previousSource.orElse(null) instanceof OpenEndedPipe ? this.previousSource : Optional.of(new OpenEndedPipe(location));
            return true;
        }
        if (FluidPropagator.hasFluidCapability((class_1922)world, location.getConnectedPos(), this.side.method_10153())) {
            this.source = Optional.of(new FlowSource.FluidHandler(location));
            return true;
        }
        FluidTransportBehaviour behaviour = TileEntityBehaviour.get((class_1922)world, relative, FluidTransportBehaviour.TYPE);
        this.source = Optional.of(behaviour == null ? new FlowSource.Blocked(location) : new FlowSource.OtherPipe(location));
        return true;
    }

    public void tickFlowProgress(class_1937 world, class_2338 pos) {
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        if (flow.fluid.isEmpty() || flow.fluid.getFluid().method_15780(class_3612.field_15906)) {
            return;
        }
        if (world.field_9236) {
            if (!this.source.isPresent()) {
                this.determineSource(world, pos);
            }
            this.spawnParticles(world, pos, flow.fluid);
            if (this.particleSplashNextTick) {
                this.spawnSplashOnRim(world, pos, flow.fluid);
            }
            this.particleSplashNextTick = false;
        }
        float flowSpeed = 0.03125f + class_3532.method_15363((float)(this.pressure.get(flow.inbound).floatValue() / 512.0f), (float)0.0f, (float)1.0f) * 31.0f / 32.0f;
        flow.progress.setValue(Math.min(flow.progress.getValue() + flowSpeed, 1.0f));
        if (flow.progress.getValue() >= 1.0f) {
            flow.complete = true;
        }
    }

    public void serializeNBT(class_2487 tag, boolean clientPacket) {
        class_2487 connectionData = new class_2487();
        tag.method_10566(this.side.method_10151(), (class_2520)connectionData);
        if (this.hasPressure()) {
            class_2499 pressureData = new class_2499();
            pressureData.add((Object)class_2494.method_23244((float)this.getInboundPressure()));
            pressureData.add((Object)class_2494.method_23244((float)this.getOutwardPressure()));
            connectionData.method_10566("Pressure", (class_2520)pressureData);
        }
        if (this.hasOpenEnd()) {
            connectionData.method_10566("OpenEnd", (class_2520)((OpenEndedPipe)this.source.get()).serializeNBT());
        }
        if (this.hasFlow()) {
            class_2487 flowData = new class_2487();
            Flow flow = this.flow.get();
            flow.fluid.writeToNBT(flowData);
            flowData.method_10556("In", flow.inbound);
            if (!flow.complete) {
                flowData.method_10566("Progress", (class_2520)flow.progress.writeNBT());
            }
            connectionData.method_10566("Flow", (class_2520)flowData);
        }
    }

    private boolean hasOpenEnd() {
        return this.source.orElse(null) instanceof OpenEndedPipe;
    }

    public void deserializeNBT(class_2487 tag, class_2338 tilePos, boolean clientPacket) {
        class_2487 connectionData = tag.method_10562(this.side.method_10151());
        if (connectionData.method_10545("Pressure")) {
            class_2499 pressureData = connectionData.method_10554("Pressure", 5);
            this.pressure = Couple.create(Float.valueOf(pressureData.method_10604(0)), Float.valueOf(pressureData.method_10604(1)));
        } else {
            this.pressure.replace(f -> Float.valueOf(0.0f));
        }
        this.source = Optional.empty();
        if (connectionData.method_10545("OpenEnd")) {
            this.source = Optional.of(OpenEndedPipe.fromNBT(connectionData.method_10562("OpenEnd"), tilePos));
        }
        if (connectionData.method_10545("Flow")) {
            class_2487 flowData = connectionData.method_10562("Flow");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((class_2487)flowData);
            boolean inbound = flowData.method_10577("In");
            if (!this.flow.isPresent()) {
                this.flow = Optional.of(new Flow(inbound, fluid));
                if (clientPacket) {
                    this.particleSplashNextTick = true;
                }
            }
            Flow flow = this.flow.get();
            flow.fluid = fluid;
            flow.inbound = inbound;
            boolean bl = flow.complete = !flowData.method_10545("Progress");
            if (!flow.complete) {
                flow.progress.readNBT(flowData.method_10562("Progress"), clientPacket);
            } else {
                if (flow.progress.getValue() == 0.0f) {
                    flow.progress.startWithValue(1.0);
                }
                flow.progress.setValue(1.0);
            }
        } else {
            this.flow = Optional.empty();
        }
    }

    public float comparePressure() {
        return this.getOutwardPressure() - this.getInboundPressure();
    }

    public void wipePressure() {
        this.pressure.replace(f -> Float.valueOf(0.0f));
        if (this.source.isPresent()) {
            this.previousSource = this.source;
        }
        this.source = Optional.empty();
        this.resetNetwork();
    }

    public FluidStack provideOutboundFlow() {
        if (!this.hasFlow()) {
            return FluidStack.EMPTY;
        }
        Flow flow = this.flow.get();
        if (!flow.complete || flow.inbound) {
            return FluidStack.EMPTY;
        }
        return flow.fluid;
    }

    public void addPressure(boolean inbound, float pressure) {
        this.pressure = this.pressure.mapWithContext((f, in) -> Float.valueOf(in == inbound ? f.floatValue() + pressure : f.floatValue()));
    }

    public boolean hasPressure() {
        return this.getInboundPressure() != 0.0f || this.getOutwardPressure() != 0.0f;
    }

    private float getOutwardPressure() {
        return ((Float)this.pressure.getSecond()).floatValue();
    }

    private float getInboundPressure() {
        return ((Float)this.pressure.getFirst()).floatValue();
    }

    public boolean hasFlow() {
        return this.flow.isPresent();
    }

    public boolean hasNetwork() {
        return this.network.isPresent();
    }

    public void resetNetwork() {
        this.network.ifPresent(FluidNetwork::reset);
    }

    public void spawnSplashOnRim(class_1937 world, class_2338 pos, FluidStack fluid) {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.spawnSplashOnRimInner(world, pos, fluid));
    }

    public void spawnParticles(class_1937 world, class_2338 pos, FluidStack fluid) {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.spawnParticlesInner(world, pos, fluid));
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnParticlesInner(class_1937 world, class_2338 pos, FluidStack fluid) {
        if (world == class_310.method_1551().field_1687 && !PipeConnection.isRenderEntityWithinDistance(pos)) {
            return;
        }
        if (this.hasOpenEnd()) {
            this.spawnPouringLiquid(world, pos, fluid, 1);
        } else if (r.nextFloat() < 0.001f) {
            this.spawnRimParticles(world, pos, fluid, 1);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnSplashOnRimInner(class_1937 world, class_2338 pos, FluidStack fluid) {
        if (world == class_310.method_1551().field_1687 && !PipeConnection.isRenderEntityWithinDistance(pos)) {
            return;
        }
        this.spawnRimParticles(world, pos, fluid, 1);
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnRimParticles(class_1937 world, class_2338 pos, FluidStack fluid, int amount) {
        if (this.hasOpenEnd()) {
            this.spawnPouringLiquid(world, pos, fluid, amount);
            return;
        }
        class_2394 particle = FluidFX.getDrippingParticle(fluid);
        FluidFX.spawnRimParticles(world, pos, this.side, amount, particle, 0.265625f);
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnPouringLiquid(class_1937 world, class_2338 pos, FluidStack fluid, int amount) {
        class_2394 particle = FluidFX.getFluidParticle(fluid);
        class_243 directionVec = class_243.method_24954((class_2382)this.side.method_10163());
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        FluidFX.spawnPouringLiquid(world, pos, amount, particle, 0.265625f, directionVec, flow.inbound);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isRenderEntityWithinDistance(class_2338 pos) {
        class_1297 renderViewEntity = class_310.method_1551().method_1560();
        if (renderViewEntity == null) {
            return false;
        }
        class_243 center = VecHelper.getCenterOf((class_2382)pos);
        return !(renderViewEntity.method_19538().method_1022(center) > 20.0);
    }

    public class Flow {
        public boolean complete;
        public boolean inbound;
        public LerpedFloat progress;
        public FluidStack fluid;

        public Flow(boolean inbound, FluidStack fluid) {
            this.inbound = inbound;
            this.fluid = fluid;
            this.progress = LerpedFloat.linear().startWithValue(0.0);
            this.complete = false;
        }
    }
}

