/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train.capability;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.WorldAttached;
import io.github.fabricators_of_create.porting_lib.util.INBTSerializable;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2818;

public class CapabilityMinecartController
implements INBTSerializable<class_2487> {
    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID = new WorldAttached<Map>($ -> new HashMap());
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling = new WorldAttached<Set>($ -> new HashSet());
    static WorldAttached<List<class_1688>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    static WorldAttached<List<UUID>> queuedUnloads = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    public final LazyOptional<MinecartController> cap;
    public MinecartController handler;

    public static void tick(class_1937 world) {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        List<class_1688> queued = queuedAdditions.get((class_1936)world);
        List<UUID> queuedRemovals = queuedUnloads.get((class_1936)world);
        Set<UUID> cartsWithCoupling = loadedMinecartsWithCoupling.get((class_1936)world);
        Set<UUID> keySet = carts.keySet();
        keySet.removeAll(queuedRemovals);
        cartsWithCoupling.removeAll(queuedRemovals);
        for (class_1688 class_16882 : queued) {
            class_1688 minecartEntity;
            MinecartController minecartController;
            UUID uniqueID = class_16882.method_5667();
            if (world.field_9236 && carts.containsKey(uniqueID) && (minecartController = carts.get(uniqueID)) != null && (minecartEntity = minecartController.cart()) != null && minecartEntity.method_5628() != class_16882.method_5628()) continue;
            cartsWithCoupling.remove(uniqueID);
            MinecartController controller = class_16882.getController();
            carts.put(uniqueID, controller);
            if (controller.isLeadingCoupling()) {
                cartsWithCoupling.add(uniqueID);
            }
            if (world.field_9236 || controller == null) continue;
            controller.sendData();
        }
        queuedRemovals.clear();
        queued.clear();
        for (Map.Entry entry : carts.entrySet()) {
            MinecartController controller = (MinecartController)entry.getValue();
            if (controller != null && controller.isPresent()) {
                controller.tick();
                continue;
            }
            toRemove.add((UUID)entry.getKey());
        }
        cartsWithCoupling.removeAll(toRemove);
        keySet.removeAll(toRemove);
    }

    public static void onChunkUnloaded(class_1937 world, class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        for (MinecartController minecartController : carts.values()) {
            class_1688 cart;
            if (minecartController == null || !minecartController.isPresent() || !(cart = minecartController.cart()).method_31476().equals((Object)chunkPos)) continue;
            queuedUnloads.get((class_1936)world).add(cart.method_5667());
        }
    }

    public static void onCartRemoved(class_1937 world, class_1688 entity) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        List<UUID> unloads = queuedUnloads.get((class_1936)world);
        UUID uniqueID = entity.method_5667();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID)) {
            return;
        }
        if (world.field_9236) {
            return;
        }
        CapabilityMinecartController.handleKilledMinecart(world, carts.get(uniqueID), entity.method_19538());
    }

    protected static void handleKilledMinecart(class_1937 world, MinecartController controller, class_243 removedPos) {
        if (controller == null) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            class_1688 cart;
            MinecartController next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next == null || next == MinecartController.EMPTY) continue;
            next.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward) || (cart = next.cart()) == null) continue;
            class_243 itemPos = cart.method_19538().method_1019(removedPos).method_1021(0.5);
            class_1542 itemEntity = new class_1542(world, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, AllItems.MINECART_COUPLING.asStack());
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(class_1937 world, UUID cartId) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        if (carts == null) {
            return null;
        }
        if (!carts.containsKey(cartId)) {
            return null;
        }
        return carts.get(cartId);
    }

    public static void attach(class_1688 entity) {
        CapabilityMinecartController capability = new CapabilityMinecartController(entity);
        entity.setCap(capability);
        queuedAdditions.get((class_1936)entity.method_5770()).add(entity);
    }

    public static void startTracking(class_1297 entity) {
        if (!(entity instanceof class_1688)) {
            return;
        }
        class_1688 cart = (class_1688)entity;
        cart.getController().sendData();
    }

    public CapabilityMinecartController(class_1688 minecart) {
        this.handler = new MinecartController(minecart);
        this.cap = LazyOptional.of(() -> this.handler);
    }

    public class_2487 serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(class_2487 nbt) {
        this.handler.deserializeNBT(nbt);
    }
}

