/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public abstract class AbstractPulleyRenderer
extends KineticTileEntityRenderer {
    private PartialModel halfRope;
    private PartialModel halfMagnet;

    public AbstractPulleyRenderer(class_5614.class_5615 context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean shouldRenderOffScreen(KineticTileEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        float offset = this.getOffset(te, partialTicks);
        boolean running = this.isRunning(te);
        class_2350.class_2351 rotationAxis = ((IRotate)te.method_11010().method_26204()).getRotationAxis(te.method_11010());
        AbstractPulleyRenderer.kineticRotationTransform(this.getRotatedCoil(te), te, rotationAxis, AngleHelper.rad(offset * 180.0f), light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        class_1937 world = te.method_10997();
        class_2680 blockState = te.method_11010();
        class_2338 pos = te.method_11016();
        SuperByteBuffer halfMagnet = CachedBufferer.partial(this.halfMagnet, blockState);
        SuperByteBuffer halfRope = CachedBufferer.partial(this.halfRope, blockState);
        SuperByteBuffer magnet = this.renderMagnet(te);
        SuperByteBuffer rope = this.renderRope(te);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (running || offset == 0.0f) {
            this.renderAt((class_1936)world, offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            this.renderAt((class_1936)world, halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            this.renderAt((class_1936)world, rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    private void renderAt(class_1936 world, SuperByteBuffer partial, float offset, class_2338 pulleyPos, class_4587 ms, class_4588 buffer) {
        class_2338 actualPos = pulleyPos.method_10087((int)offset);
        int light = class_761.method_23793((class_1920)world, (class_2680)world.method_8320(actualPos), (class_2338)actualPos);
        partial.translate(0.0, -offset, 0.0).light(light).renderInto(ms, buffer);
    }

    protected abstract class_2350.class_2351 getShaftAxis(KineticTileEntity var1);

    protected abstract PartialModel getCoil();

    protected abstract SuperByteBuffer renderRope(KineticTileEntity var1);

    protected abstract SuperByteBuffer renderMagnet(KineticTileEntity var1);

    protected abstract float getOffset(KineticTileEntity var1, float var2);

    protected abstract boolean isRunning(KineticTileEntity var1);

    @Override
    protected class_2680 getRenderedBlockState(KineticTileEntity te) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(te));
    }

    protected SuperByteBuffer getRotatedCoil(KineticTileEntity te) {
        class_2680 blockState = te.method_11010();
        return CachedBufferer.partialFacing(this.getCoil(), blockState, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.getShaftAxis(te)));
    }

    public int method_33893() {
        return 256;
    }
}

