/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.DirectionalExtenderScrollOptionSlot;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.LinearActuatorTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonContraption;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class MechanicalPistonTileEntity
extends LinearActuatorTileEntity {
    protected boolean hadCollisionWithOtherPiston;
    protected int extensionLength;

    public MechanicalPistonTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.extensionLength = compound.method_10550("ExtensionLength");
        super.read(compound, clientPacket);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        tag.method_10569("ExtensionLength", this.extensionLength);
        super.write(tag, clientPacket);
    }

    @Override
    public void assemble() throws AssemblyException {
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof MechanicalPistonBlock)) {
            return;
        }
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        PistonContraption contraption = new PistonContraption(direction, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.field_11863, this.field_11867)) {
            return;
        }
        class_2350 positive = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)direction.method_10166());
        class_2350 movementDirection = this.getSpeed() > 0.0f ^ direction.method_10166() != class_2350.class_2351.field_11051 ? positive : positive.method_10153();
        class_2338 anchor = contraption.anchor.method_10079(direction, contraption.initialExtensionProgress);
        if (ContraptionCollider.isCollidingWithWorld(this.field_11863, contraption, anchor.method_10093(movementDirection), movementDirection)) {
            return;
        }
        this.extensionLength = contraption.extensionLength;
        float resultingOffset = (float)contraption.initialExtensionProgress + Math.signum(this.getMovementSpeed()) * 0.5f;
        if (resultingOffset <= 0.0f || resultingOffset >= (float)this.extensionLength) {
            return;
        }
        this.running = true;
        this.offset = contraption.initialExtensionProgress;
        this.sendData();
        this.clientOffsetDiff = 0.0f;
        class_2338 startPos = class_2338.field_10980.method_10079(direction, contraption.initialExtensionProgress);
        contraption.removeBlocksFromWorld(this.field_11863, startPos);
        this.movedContraption = ControlledContraptionEntity.create(this.method_10997(), this, contraption);
        this.resetContraptionToOffset();
        this.forceMove = true;
        this.field_11863.method_8649((class_1297)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.field_11865) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.EXTENDED)), 19);
        }
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        }
        this.running = false;
        this.movedContraption = null;
        this.sendData();
        if (this.field_11865) {
            ((MechanicalPistonBlock)AllBlocks.MECHANICAL_PISTON.get()).method_9576(this.field_11863, this.field_11867, this.method_11010(), null);
        }
    }

    @Override
    protected void collided() {
        super.collided();
        if (!this.running && this.getMovementSpeed() > 0.0f) {
            this.assembleNextTick = true;
        }
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed = class_3532.method_15363((float)MechanicalPistonTileEntity.convertToLinear(this.getSpeed()), (float)-0.49f, (float)0.49f);
        if (this.field_11863.field_9236) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        class_2350 pistonDirection = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        int movementModifier = pistonDirection.method_10171().method_10181() * (pistonDirection.method_10166() == class_2350.class_2351.field_11051 ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff / 2.0f;
        int extensionRange = this.getExtensionRange();
        movementSpeed = class_3532.method_15363((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)extensionRange - this.offset));
        return movementSpeed;
    }

    @Override
    protected int getExtensionRange() {
        return this.extensionLength;
    }

    @Override
    protected void visitNewPosition() {
    }

    @Override
    protected class_243 toMotionVector(float speed) {
        class_2350 pistonDirection = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        return class_243.method_24954((class_2382)pistonDirection.method_10163()).method_1021((double)speed);
    }

    @Override
    protected class_243 toPosition(float offset) {
        class_243 position = class_243.method_24954((class_2382)((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525)).method_10163()).method_1021((double)offset);
        return position.method_1019(class_243.method_24954((class_2382)this.movedContraption.getContraption().anchor));
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> {
            class_2350.class_2351 axis = d.method_10166();
            class_2350.class_2351 extensionAxis = ((class_2350)state.method_11654((class_2769)MechanicalPistonBlock.FACING)).method_10166();
            class_2350.class_2351 shaftAxis = ((IRotate)state.method_26204()).getRotationAxis((class_2680)state);
            return extensionAxis != axis && shaftAxis != axis;
        });
    }

    @Override
    protected int getInitialOffset() {
        return this.movedContraption == null ? 0 : ((PistonContraption)this.movedContraption.getContraption()).initialExtensionProgress;
    }
}

