/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class MechanicalBearingTileEntity
extends GeneratingKineticTileEntity
implements IBearingTileEntity,
IDisplayAssemblyExceptions {
    protected ScrollOptionBehaviour<IControlContraption.RotationMode> movementMode;
    protected ControlledContraptionEntity movedContraption;
    protected float angle;
    protected boolean running;
    protected boolean assembleNextTick;
    protected float clientAngleDiff;
    protected AssemblyException lastException;
    private float prevAngle;

    public MechanicalBearingTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
    }

    @Override
    public boolean isWoodenTop() {
        return false;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour<IControlContraption.RotationMode>(IControlContraption.RotationMode.class, (class_2561)Lang.translateDirect("contraptions.movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        behaviours.add(this.movementMode);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void method_11012() {
        super.method_11012();
    }

    @Override
    protected void setRemovedNotDueToChunkUnload() {
        if (!this.field_11863.field_9236) {
            this.disassemble();
        }
        super.setRemovedNotDueToChunkUnload();
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Running", this.running);
        compound.method_10548("Angle", this.angle);
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        float angleBefore = this.angle;
        this.running = compound.method_10577("Running");
        this.angle = compound.method_10583("Angle");
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            if (this.movedContraption == null || !this.movedContraption.isStalled()) {
                this.clientAngleDiff = AngleHelper.getShortestAngleDiff(angleBefore, this.angle);
                this.angle = angleBefore;
            }
        } else {
            this.movedContraption = null;
        }
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)(partialTicks + 0.5f), (float)this.prevAngle, (float)this.angle);
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        return class_3532.method_16439((float)partialTicks, (float)this.angle, (float)(this.angle + this.getAngularSpeed()));
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            this.movedContraption.getContraption().stop(this.field_11863);
        }
    }

    public float getAngularSpeed() {
        float speed = MechanicalBearingTileEntity.convertToAngular(this.isWindmill() ? this.getGeneratedSpeed() : this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.field_11863.field_9236) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected boolean isWindmill() {
        return false;
    }

    @Override
    public class_2338 getBlockPosition() {
        return this.field_11867;
    }

    public void assemble() {
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof BearingBlock)) {
            return;
        }
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)BearingBlock.FACING);
        BearingContraption contraption = new BearingContraption(this.isWindmill(), direction);
        try {
            if (!contraption.assemble(this.field_11863, this.field_11867)) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (this.isWindmill()) {
            this.award(AllAdvancements.WINDMILL);
        }
        if (contraption.getSailBlocks() >= 128) {
            this.award(AllAdvancements.WINDMILL_MAXED);
        }
        contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
        this.movedContraption = ControlledContraptionEntity.create(this.field_11863, this, contraption);
        class_2338 anchor = this.field_11867.method_10093(direction);
        this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        this.movedContraption.setRotationAxis(direction.method_10166());
        this.field_11863.method_8649((class_1297)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        this.running = true;
        this.angle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.angle = 0.0f;
        if (this.isWindmill()) {
            this.applyRotation();
        }
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.prevAngle = this.angle;
        if (this.field_11863.field_9236) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.field_11863.field_9236 && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble;
                boolean bl = canDisassemble = this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE || this.isNearInitialAngle() && this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE_RETURNED;
                if (this.speed == 0.0f && (canDisassemble || this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.field_11863);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                if (this.speed == 0.0f && !this.isWindmill()) {
                    return;
                }
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.isStalled()) {
            float angularSpeed = this.getAngularSpeed();
            float newAngle = this.angle + angularSpeed;
            this.angle = newAngle % 360.0f;
        }
        this.applyRotation();
    }

    public boolean isNearInitialAngle() {
        return Math.abs(this.angle) < 45.0f || Math.abs(this.angle) > 315.0f;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_11863.field_9236) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.angle);
        class_2680 blockState = this.method_11010();
        if (blockState.method_28498((class_2769)class_2741.field_12525)) {
            this.movedContraption.setRotationAxis(((class_2350)blockState.method_11654((class_2769)class_2741.field_12525)).method_10166());
        }
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        class_2680 blockState = this.method_11010();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!blockState.method_28498((class_2769)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.method_5431();
        class_2338 anchor = this.field_11867.method_10093((class_2350)blockState.method_11654((class_2769)BearingBlock.FACING));
        this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        if (!this.field_11863.field_9236) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (!this.isWindmill() && this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.running) {
            return false;
        }
        class_2680 state = this.method_11010();
        if (!(state.method_26204() instanceof BearingBlock)) {
            return false;
        }
        class_2680 attachedState = this.field_11863.method_8320(this.field_11867.method_10093((class_2350)state.method_11654((class_2769)BearingBlock.FACING)));
        if (attachedState.method_26207().method_15800()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.empty_bearing", new Object[0]);
        return true;
    }

    @Override
    public void setAngle(float forcedAngle) {
        this.angle = forcedAngle;
    }
}

