/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingInventory;
import com.simibubi.create.content.logistics.block.inventories.BottomlessItemHandler;
import com.simibubi.create.content.logistics.block.vault.ItemVaultTileEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2627;
import net.minecraft.class_3719;

public class MountedStorage {
    private static final ItemStackHandler dummyHandler = new ItemStackHandler();
    ItemStackHandler handler;
    boolean noFuel;
    boolean valid;
    private class_2586 te;

    public static boolean canUseAsStorage(class_2586 te) {
        if (te == null) {
            return false;
        }
        if (te instanceof MechanicalCrafterTileEntity) {
            return false;
        }
        if (AllTileEntities.CREATIVE_CRATE.is(te)) {
            return true;
        }
        if (te instanceof class_2627) {
            return true;
        }
        if (te instanceof class_2595) {
            return true;
        }
        if (te instanceof class_3719) {
            return true;
        }
        if (te instanceof ItemVaultTileEntity) {
            return true;
        }
        Storage handler = TransferUtil.getItemStorage((class_2586)te);
        return handler instanceof ItemStackHandler && !(handler instanceof ProcessingInventory);
    }

    public MountedStorage(class_2586 te) {
        this.te = te;
        this.handler = dummyHandler;
        this.noFuel = te instanceof ItemVaultTileEntity;
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.te == null) {
            return;
        }
        if (this.te instanceof class_2595) {
            class_2487 tag = this.te.method_38242();
            if (tag.method_10573("LootTable", 8)) {
                return;
            }
            this.handler = new ItemStackHandler(((class_2595)this.te).method_5439());
            class_2371 items = class_2371.method_10213((int)this.handler.getSlots(), (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)tag, (class_2371)items);
            this.handler.stacks = (class_1799[])items.toArray(class_1799[]::new);
            this.valid = true;
            return;
        }
        Storage teHandler = TransferUtil.getItemStorage((class_2586)this.te);
        if (teHandler == null) {
            return;
        }
        if (this.te instanceof ItemVaultTileEntity) {
            this.handler = ((ItemVaultTileEntity)this.te).getInventoryOfBlock();
            this.valid = true;
            return;
        }
        if (teHandler instanceof ItemStackHandler) {
            this.handler = (ItemStackHandler)teHandler;
            this.valid = true;
            return;
        }
        if (teHandler instanceof InventoryStorage) {
            InventoryStorage inv = (InventoryStorage)teHandler;
            if (teHandler.supportsInsertion() && teHandler.supportsExtraction()) {
                try (Transaction t = TransferUtil.getTransaction();){
                    List slots = inv.getSlots();
                    class_1799[] stacks = new class_1799[slots.size()];
                    for (int i = 0; i < slots.size(); ++i) {
                        SingleSlotStorage slot = (SingleSlotStorage)slots.get(i);
                        if (slot.isResourceBlank()) {
                            stacks[i] = class_1799.field_8037;
                            continue;
                        }
                        long contained = slot.getAmount();
                        ItemVariant variant = (ItemVariant)slot.getResource();
                        long extracted = slot.extract((Object)variant, contained, (TransactionContext)t);
                        if (extracted != contained) {
                            return;
                        }
                        stacks[i] = variant.toStack((int)extracted);
                    }
                    this.handler = new ItemStackHandler(stacks);
                    this.valid = true;
                }
            }
        }
    }

    public void addStorageToWorld(class_2586 te) {
        if (this.handler instanceof BottomlessItemHandler) {
            return;
        }
        if (te instanceof class_2595) {
            class_2487 tag = te.method_38242();
            tag.method_10551("Items");
            class_2371 items = class_2371.method_10213((int)this.handler.getSlots(), (Object)class_1799.field_8037);
            for (int i = 0; i < items.size(); ++i) {
                items.set(i, (Object)this.handler.getStackInSlot(i));
            }
            class_1262.method_5426((class_2487)tag, (class_2371)items);
            te.method_11014(tag);
            return;
        }
        if (te instanceof ItemVaultTileEntity) {
            ((ItemVaultTileEntity)te).applyInventoryToBlock(this.handler);
            return;
        }
        Storage teHandler = TransferUtil.getItemStorage((class_2586)te);
        if (teHandler != null && teHandler.supportsInsertion()) {
            try (Transaction t = TransferUtil.getTransaction();){
                for (StorageView view : teHandler.iterable((TransactionContext)t)) {
                    if (view.isResourceBlank()) continue;
                    view.extract((Object)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)t);
                }
                for (class_1799 stack : this.handler.stacks) {
                    if (stack.method_7960()) continue;
                    teHandler.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
                }
                t.commit();
            }
        }
    }

    public Storage<ItemVariant> getItemHandler() {
        return this.handler;
    }

    public class_2487 serialize() {
        if (!this.valid) {
            return null;
        }
        class_2487 tag = this.handler.serializeNBT();
        if (this.noFuel) {
            NBTHelper.putMarker(tag, "NoFuel");
        }
        if (!(this.handler instanceof BottomlessItemHandler)) {
            return tag;
        }
        NBTHelper.putMarker(tag, "Bottomless");
        tag.method_10566("ProvidedStack", NBTSerializer.serializeNBT((Object)this.handler.getStackInSlot(0)));
        return tag;
    }

    public static MountedStorage deserialize(class_2487 nbt) {
        MountedStorage storage = new MountedStorage(null);
        storage.handler = new ItemStackHandler();
        if (nbt == null) {
            return storage;
        }
        storage.valid = true;
        storage.noFuel = nbt.method_10545("NoFuel");
        if (nbt.method_10545("Bottomless")) {
            class_1799 providedStack = class_1799.method_7915((class_2487)nbt.method_10562("ProvidedStack"));
            storage.handler = new BottomlessItemHandler(() -> providedStack);
            return storage;
        }
        storage.handler.deserializeNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean canUseForFuel() {
        return !this.noFuel;
    }
}

