/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ContraptionType {
    public static Map<String, ContraptionType> entries = new HashMap<String, ContraptionType>();
    public static ContraptionType PISTON = ContraptionType.register("piston", PistonContraption::new);
    public static ContraptionType BEARING = ContraptionType.register("bearing", BearingContraption::new);
    public static ContraptionType PULLEY = ContraptionType.register("pulley", PulleyContraption::new);
    public static ContraptionType CLOCKWORK = ContraptionType.register("clockwork", ClockworkContraption::new);
    public static ContraptionType MOUNTED = ContraptionType.register("mounted", MountedContraption::new);
    public static ContraptionType STABILIZED = ContraptionType.register("stabilized", StabilizedContraption::new);
    public static ContraptionType GANTRY = ContraptionType.register("gantry", GantryContraption::new);
    public static ContraptionType CARRIAGE = ContraptionType.register("carriage", CarriageContraption::new);
    Supplier<? extends Contraption> factory;
    String id;

    public static ContraptionType register(String id, Supplier<? extends Contraption> factory) {
        ContraptionType value = new ContraptionType(id, factory);
        entries.put(id, value);
        return value;
    }

    private ContraptionType(String id, Supplier<? extends Contraption> factory) {
        this.factory = factory;
        this.id = id;
    }

    public static Contraption fromType(String type) {
        for (Map.Entry<String, ContraptionType> allContraptionTypes : entries.entrySet()) {
            if (!type.equals(allContraptionTypes.getKey())) continue;
            return allContraptionTypes.getValue().factory.get();
        }
        return null;
    }
}

