/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.steam.whistle;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.steam.SteamJetParticleData;
import com.simibubi.create.content.contraptions.components.steam.whistle.WhistleBlock;
import com.simibubi.create.content.contraptions.components.steam.whistle.WhistleExtenderBlock;
import com.simibubi.create.content.contraptions.components.steam.whistle.WhistleSoundInstance;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.lang.ref.WeakReference;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class WhistleTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    public WeakReference<FluidTankTileEntity> source = new WeakReference<Object>(null);
    public LerpedFloat animation = LerpedFloat.linear();
    protected int pitch;
    @Environment(value=EnvType.CLIENT)
    protected WhistleSoundInstance soundInstance;

    public WhistleTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.STEAM_WHISTLE);
    }

    public void updatePitch() {
        class_2680 blockState;
        class_2338 currentPos = this.field_11867.method_10084();
        int prevPitch = this.pitch;
        this.pitch = 0;
        while (this.pitch <= 24 && AllBlocks.STEAM_WHISTLE_EXTENSION.has(blockState = this.field_11863.method_8320(currentPos))) {
            if (blockState.method_11654(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                ++this.pitch;
                break;
            }
            currentPos = currentPos.method_10084();
            this.pitch += 2;
        }
        if (prevPitch == this.pitch) {
            return;
        }
        this.notifyUpdate();
        FluidTankTileEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.method_8608()) {
            if (this.isPowered()) {
                this.award(AllAdvancements.STEAM_WHISTLE);
            }
            return;
        }
        FluidTankTileEntity tank = this.getTank();
        boolean powered = this.isPowered() && (tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || this.isVirtual());
        this.animation.chase(powered ? 1.0 : 0.0, powered ? 0.5 : (double)0.4f, powered ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.tickAudio(this.getOctave(), powered));
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        tag.method_10569("Pitch", this.pitch);
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        this.pitch = tag.method_10550("Pitch");
        super.read(tag, clientPacket);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        String[] pitches = Lang.translateDirect("generic.notes", new Object[0]).getString().split(";");
        class_5250 textComponent = Components.literal("    ");
        tooltip.add((class_2561)textComponent.method_10852((class_2561)Lang.translateDirect("generic.pitch", pitches[this.pitch % pitches.length])));
        return true;
    }

    protected boolean isPowered() {
        return this.method_11010().method_28500((class_2769)WhistleBlock.POWERED).orElse(false);
    }

    protected WhistleBlock.WhistleSize getOctave() {
        return this.method_11010().method_28500(WhistleBlock.SIZE).orElse(WhistleBlock.WhistleSize.MEDIUM);
    }

    @Environment(value=EnvType.CLIENT)
    protected void tickAudio(WhistleBlock.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.field_11863.method_8510() % 8L == 0L;
        class_243 eyePosition = class_310.method_1551().field_1719.method_33571();
        float maxVolume = (float)class_3532.method_15350((double)((64.0 - eyePosition.method_1022(class_243.method_24953((class_2382)this.field_11867))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.method_4793() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new WhistleSoundInstance(size, this.field_11867);
            class_310.method_1551().method_1483().method_4873((class_1113)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.field_11863, (class_2382)this.field_11867, maxVolume * 0.175f, size == WhistleBlock.WhistleSize.SMALL ? f + 0.75f : f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        class_2350 facing = this.method_11010().method_28500((class_2769)WhistleBlock.FACING).orElse(class_2350.field_11035);
        float angle = 180.0f + AngleHelper.horizontalAngle(facing);
        class_243 sizeOffset = VecHelper.rotate(new class_243(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), angle, class_2350.class_2351.field_11052);
        class_243 offset = VecHelper.rotate(new class_243(0.0, 1.0, 0.75), angle, class_2350.class_2351.field_11052);
        class_243 v = offset.method_1021((double)0.45f).method_1019(sizeOffset).method_1019(class_243.method_24953((class_2382)this.field_11867));
        class_243 m = offset.method_1020(class_243.method_24954((class_2382)facing.method_10163()).method_1021(0.75));
        this.field_11863.method_8406((class_2394)new SteamJetParticleData(1.0f), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
    }

    public int getPitchId() {
        return this.pitch + 100 * this.method_11010().method_28500(WhistleBlock.SIZE).orElse(WhistleBlock.WhistleSize.MEDIUM).ordinal();
    }

    public FluidTankTileEntity getTank() {
        FluidTankTileEntity tank = (FluidTankTileEntity)this.source.get();
        if (tank == null || tank.method_11015()) {
            class_2350 facing;
            class_2586 be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.field_11863.method_8321(this.field_11867.method_10093(facing = WhistleBlock.getAttachedDirection(this.method_11010())))) instanceof FluidTankTileEntity) {
                FluidTankTileEntity tankTe;
                tank = tankTe = (FluidTankTileEntity)be;
                this.source = new WeakReference<FluidTankTileEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerTE();
    }
}

