/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class SawRenderer
extends SafeTileEntityRenderer<SawTileEntity> {
    public SawRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SawTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        this.renderBlade(te, ms, buffer, light);
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        this.renderShaft(te, ms, buffer, light, overlay);
    }

    protected void renderBlade(SawTileEntity te, class_4587 ms, class_4597 buffer, int light) {
        PartialModel partial;
        class_2680 blockState = te.method_11010();
        float speed = te.getSpeed();
        boolean rotate = false;
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllBlockPartials.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllBlockPartials.SAW_BLADE_HORIZONTAL_REVERSED : AllBlockPartials.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = te.getSpeed() > 0.0f ? AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllBlockPartials.SAW_BLADE_VERTICAL_REVERSED : AllBlockPartials.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        SuperByteBuffer superBuffer = CachedBufferer.partialFacing(partial, blockState);
        if (rotate) {
            superBuffer.rotateCentered(class_2350.field_11036, AngleHelper.rad(90.0));
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    protected void renderShaft(SawTileEntity te, class_4587 ms, class_4597 buffer, int light, int overlay) {
        KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te), ms, buffer.getBuffer(class_1921.method_23577()), light);
    }

    protected void renderItems(SawTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = te.method_11010().method_11654((class_2769)SawBlock.FACING) == class_2350.field_11036;
        if (processingMode && !te.inventory.isEmpty()) {
            boolean alongZ = (Boolean)te.method_11010().method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            ms.method_22903();
            boolean moving = te.inventory.recipeDuration != 0.0f;
            float offset = moving ? te.inventory.remainingTime / te.inventory.recipeDuration : 0.0f;
            float processingSpeed = class_3532.method_15363((float)(Math.abs(te.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = class_3532.method_15363((float)(offset + (-partialTicks + 0.5f) * processingSpeed / te.inventory.recipeDuration), (float)0.125f, (float)1.0f);
                if (!te.inventory.appliedRecipe) {
                    offset += 1.0f;
                }
                offset /= 2.0f;
            }
            if (te.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (te.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < te.inventory.getSlots(); ++i) {
                class_1799 stack = te.inventory.getStackInSlot(i);
                if (stack.method_7960()) continue;
                class_918 itemRenderer = class_310.method_1551().method_1480();
                class_1087 modelWithOverrides = itemRenderer.method_4019(stack, te.method_10997(), null, 0);
                boolean blockItem = modelWithOverrides.method_4712();
                ms.method_22904(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.method_22905(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.method_22907(class_1160.field_20705.method_23214(90.0f));
                }
                ms.method_22907(class_1160.field_20703.method_23214(90.0f));
                itemRenderer.method_23178(stack, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                break;
            }
            ms.method_22909();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        class_2680 state = te.method_11010();
        if (((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166().method_10179()) {
            return CachedBufferer.partialFacing(AllBlockPartials.SHAFT_HALF, state.method_26186(class_2470.field_11464));
        }
        return CachedBufferer.block(KineticTileEntityRenderer.KINETIC_TILE, this.getRenderedBlockState(te));
    }

    protected class_2680 getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        boolean shouldAnimate;
        class_2680 state = context.state;
        class_2350 facing = (class_2350)state.method_11654((class_2769)SawBlock.FACING);
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)SawBlock.FACING)).method_10163());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_2350 closestToFacing = class_2350.method_10142((double)facingVec.field_1352, (double)facingVec.field_1351, (double)facingVec.field_1350);
        boolean horizontal = closestToFacing.method_10166().method_10179();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean bl = shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = SawBlock.isHorizontal(state) ? (shouldAnimate ? CachedBufferer.partial(AllBlockPartials.SAW_BLADE_HORIZONTAL_ACTIVE, state) : CachedBufferer.partial(AllBlockPartials.SAW_BLADE_HORIZONTAL_INACTIVE, state)) : (shouldAnimate ? CachedBufferer.partial(AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE, state) : CachedBufferer.partial(AllBlockPartials.SAW_BLADE_VERTICAL_INACTIVE, state));
        ((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel()).centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(AngleHelper.verticalAngle(facing));
        if (!SawBlock.isHorizontal(state)) {
            superBuffer.rotateZ((Boolean)state.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0 : 0.0);
        }
        ((SuperByteBuffer)superBuffer.unCentre()).light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23579()));
    }
}

