/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.motor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class CreativeMotorTileEntity
extends GeneratingKineticTileEntity {
    public static final int DEFAULT_SPEED = 16;
    protected ScrollValueBehaviour generatedSpeed;

    public CreativeMotorTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.SERVER.kinetics.maxMotorSpeed.get();
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.method_11654((class_2769)CreativeMotorBlock.FACING) == side.method_10153());
        this.generatedSpeed = new ScrollValueBehaviour((class_2561)Lang.translateDirect("generic.speed", new Object[0]), this, slot);
        this.generatedSpeed.between(-max.intValue(), max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.scrollableValue = 16;
        this.generatedSpeed.withUnit(i -> Lang.translateDirect("generic.unit.rpm", new Object[0]));
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        this.generatedSpeed.withStepFunction(CreativeMotorTileEntity::step);
        behaviours.add(this.generatedSpeed);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        if (!AllBlocks.CREATIVE_MOTOR.has(this.method_11010())) {
            return 0.0f;
        }
        return CreativeMotorTileEntity.convertToDirection(this.generatedSpeed.getValue(), (class_2350)this.method_11010().method_11654((class_2769)CreativeMotorBlock.FACING));
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return current + (context.forward ? step : -step) == 0 ? step + 1 : step;
    }
}

