/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_1160;
import net.minecraft.class_1747;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class DeployerRenderer
extends SafeTileEntityRenderer<DeployerTileEntity> {
    public DeployerRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(DeployerTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        this.renderItem(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        this.renderComponents(te, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(DeployerTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        boolean isBlockItem;
        if (te.heldItem.method_7960()) {
            return;
        }
        class_2680 deployerState = te.method_11010();
        class_243 offset = this.getHandOffset(te, partialTicks, deployerState).method_1019(VecHelper.getCenterOf((class_2382)class_2338.field_10980));
        ms.method_22903();
        ms.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        class_2350 facing = (class_2350)deployerState.method_11654((class_2769)DirectionalKineticBlock.FACING);
        boolean punching = te.mode == DeployerTileEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float xRot = facing == class_2350.field_11036 ? 90.0f : (facing == class_2350.field_11033 ? 270.0f : 0.0f);
        boolean displayMode = facing == class_2350.field_11036 && te.getSpeed() == 0.0f && !punching;
        ms.method_22907(class_1160.field_20705.method_23214(yRot));
        if (!displayMode) {
            ms.method_22907(class_1160.field_20703.method_23214(xRot));
            ms.method_22904(0.0, 0.0, -0.6875);
        }
        if (punching) {
            ms.method_22904(0.0, 0.125, -0.0625);
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_809.class_811 transform = class_809.class_811.field_4315;
        boolean bl = isBlockItem = te.heldItem.method_7909() instanceof class_1747 && itemRenderer.method_4019(te.heldItem, te.method_10997(), null, 0).method_4712();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            ms.method_22904(0.0, isBlockItem ? 0.5625 : 0.6875, 0.0);
            ms.method_22905(scale, scale, scale);
            transform = class_809.class_811.field_4318;
            ms.method_22907(class_1160.field_20705.method_23214(AnimationTickHolder.getRenderTime((class_1936)te.method_10997())));
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            ms.method_22905(scale, scale, scale);
            transform = punching ? class_809.class_811.field_4320 : class_809.class_811.field_4319;
        }
        itemRenderer.method_23178(te.heldItem, transform, light, overlay, ms, buffer, 0);
        ms.method_22909();
    }

    protected void renderComponents(DeployerTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (!Backend.canUseInstancing((class_1937)te.method_10997())) {
            KineticTileEntityRenderer.renderRotatingKineticBlock(te, this.getRenderedBlockState(te), ms, vb, light);
        }
        class_2680 blockState = te.method_11010();
        class_243 offset = this.getHandOffset(te, partialTicks, blockState);
        SuperByteBuffer pole = CachedBufferer.partial(AllBlockPartials.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBufferer.partial(te.getHandPose(), blockState);
        DeployerRenderer.transform(pole.translate(offset.field_1352, offset.field_1351, offset.field_1350), blockState, true).light(light).renderInto(ms, vb);
        DeployerRenderer.transform(hand.translate(offset.field_1352, offset.field_1351, offset.field_1350), blockState, false).light(light).renderInto(ms, vb);
    }

    protected class_243 getHandOffset(DeployerTileEntity te, float partialTicks, class_2680 blockState) {
        float distance = te.getHandOffset(partialTicks);
        return class_243.method_24954((class_2382)((class_2350)blockState.method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10163()).method_1021((double)distance);
    }

    protected class_2680 getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 deployerState, boolean axisDirectionMatters) {
        float xRot;
        class_2350 facing = (class_2350)deployerState.method_11654((class_2769)DirectionalKineticBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        float f = facing == class_2350.field_11036 ? 270.0f : (xRot = facing == class_2350.field_11033 ? 90.0f : 0.0f);
        float zRot = axisDirectionMatters && (Boolean)deployerState.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051 ? 90.0f : 0.0f;
        buffer.rotateCentered(class_2350.field_11036, (float)((double)(yRot / 180.0f) * Math.PI));
        buffer.rotateCentered(class_2350.field_11034, (float)((double)(xRot / 180.0f) * Math.PI));
        buffer.rotateCentered(class_2350.field_11035, (float)((double)(zRot / 180.0f) * Math.PI));
        return buffer;
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        double factor;
        class_4588 builder = buffer.getBuffer(class_1921.method_23577());
        class_2680 blockState = context.state;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        SuperByteBuffer shaft = CachedBufferer.block(AllBlocks.SHAFT.getDefaultState());
        SuperByteBuffer pole = CachedBufferer.partial(AllBlockPartials.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBufferer.partial(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            class_243 center = VecHelper.getCenterOf((class_2382)new class_2338(context.position));
            double distance = context.position.method_1022(center);
            double nextDistance = context.position.method_1019(context.motion).method_1022(center);
            factor = 0.5 - class_3532.method_15350((double)class_3532.method_16436((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        class_243 offset = class_243.method_24954((class_2382)((class_2350)blockState.method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10163()).method_1021(factor);
        class_4587 m = matrices.getModel();
        m.method_22903();
        m.method_22903();
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        if (context.state.method_26204() instanceof IRotate) {
            IRotate def = (IRotate)context.state.method_26204();
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime((class_1936)context.world) / 20.0f;
        float angle = time * speed % 360.0f;
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)m).centre()).rotateY(axis == class_2350.class_2351.field_11051 ? 90.0 : 0.0)).rotateZ(axis.method_10179() ? 90.0 : 0.0)).unCentre();
        shaft.transform(m);
        shaft.rotateCentered(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)class_2350.class_2351.field_11052), angle);
        m.method_22909();
        m.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        pole.transform(m);
        hand.transform(m);
        DeployerRenderer.transform(pole, blockState, true);
        DeployerRenderer.transform(hand, blockState, false);
        shaft.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        pole.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        hand.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        m.method_22909();
    }

    static PartialModel getHandPose(DeployerTileEntity.Mode mode) {
        return mode == DeployerTileEntity.Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : AllBlockPartials.DEPLOYER_HAND_POINTING;
    }
}

