/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1860;

public class DeployerRecipeSearchEvent {
    private boolean canceled = false;
    private final DeployerTileEntity tileEntity;
    private final RecipeWrapper inventory;
    @Nullable
    class_1860<? extends class_1263> recipe = null;
    private int maxPriority = 0;
    public static final Event<DeployerRecipeSearchCallback> EVENT = EventFactory.createArrayBacked(DeployerRecipeSearchCallback.class, callbacks -> event -> {
        for (DeployerRecipeSearchCallback callback : callbacks) {
            callback.handle(event);
        }
    });

    public DeployerRecipeSearchEvent(DeployerTileEntity tileEntity, RecipeWrapper inventory) {
        this.tileEntity = tileEntity;
        this.inventory = inventory;
    }

    public void cancel() {
        this.canceled = true;
    }

    public DeployerTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public RecipeWrapper getInventory() {
        return this.inventory;
    }

    public boolean shouldAddRecipeWithPriority(int priority) {
        return !this.canceled && priority > this.maxPriority;
    }

    @Nullable
    public class_1860<? extends class_1263> getRecipe() {
        if (this.canceled) {
            return null;
        }
        return this.recipe;
    }

    public void addRecipe(Supplier<Optional<? extends class_1860<? extends class_1263>>> recipeSupplier, int priority) {
        if (!this.shouldAddRecipeWithPriority(priority)) {
            return;
        }
        recipeSupplier.get().ifPresent(newRecipe -> {
            this.recipe = newRecipe;
            this.maxPriority = priority;
        });
    }

    @FunctionalInterface
    public static interface DeployerRecipeSearchCallback {
        public void handle(DeployerRecipeSearchEvent var1);
    }
}

