/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.ConnectedInputHandler;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.RecipeGridHandler;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MechanicalCrafterTileEntity
extends KineticTileEntity
implements ItemTransferable {
    protected Inventory inventory;
    protected RecipeGridHandler.GroupedItems groupedItems = new RecipeGridHandler.GroupedItems();
    protected ConnectedInputHandler.ConnectedInput input = new ConnectedInputHandler.ConnectedInput();
    protected boolean reRender;
    protected Phase phase;
    protected int countDown;
    protected boolean covered;
    protected boolean wasPoweredBefore;
    protected RecipeGridHandler.GroupedItems groupedItemsBeforeCraft;
    private InvManipulationBehaviour inserting;
    private EdgeInteractionBehaviour connectivity;
    private class_1799 scriptedResult = class_1799.field_8037;

    public MechanicalCrafterTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
        this.phase = Phase.IDLE;
        this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
        this.inventory = new Inventory(this);
        this.wasPoweredBefore = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        this.connectivity = new EdgeInteractionBehaviour(this, ConnectedInputHandler::toggleConnection).connectivity(ConnectedInputHandler::shouldConnect).require((class_1792)AllItems.WRENCH.get());
        behaviours.add(this.inserting);
        behaviours.add(this.connectivity);
        this.registerAwardables(behaviours, AllAdvancements.CRAFTER, AllAdvancements.CRAFTER_LAZY);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!class_3532.method_15347((float)this.getSpeed(), (float)0.0f)) {
            this.award(AllAdvancements.CRAFTER);
            if (Math.abs(this.getSpeed()) < 5.0f) {
                this.award(AllAdvancements.CRAFTER_LAZY);
            }
        }
    }

    public void blockChanged() {
        this.removeBehaviour(InvManipulationBehaviour.TYPE);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        this.attachBehaviourLate(this.inserting);
    }

    public BlockFace getTargetFace(class_1937 world, class_2338 pos, class_2680 state) {
        return new BlockFace(pos, MechanicalCrafterBlock.getTargetDirection(state));
    }

    public class_2350 getTargetDirection() {
        return MechanicalCrafterBlock.getTargetDirection(this.method_11010());
    }

    @Override
    public void writeSafe(class_2487 compound) {
        super.writeSafe(compound);
        if (this.input == null) {
            return;
        }
        class_2487 inputNBT = new class_2487();
        this.input.write(inputNBT);
        compound.method_10566("ConnectedInput", (class_2520)inputNBT);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        class_2487 inputNBT = new class_2487();
        this.input.write(inputNBT);
        compound.method_10566("ConnectedInput", (class_2520)inputNBT);
        class_2487 groupedItemsNBT = new class_2487();
        this.groupedItems.write(groupedItemsNBT);
        compound.method_10566("GroupedItems", (class_2520)groupedItemsNBT);
        compound.method_10582("Phase", this.phase.name());
        compound.method_10569("CountDown", this.countDown);
        compound.method_10556("Cover", this.covered);
        super.write(compound, clientPacket);
        if (clientPacket && this.reRender) {
            compound.method_10556("Redraw", true);
            this.reRender = false;
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        Phase phaseBefore = this.phase;
        RecipeGridHandler.GroupedItems before = this.groupedItems;
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.input.read(compound.method_10562("ConnectedInput"));
        this.groupedItems = RecipeGridHandler.GroupedItems.read(compound.method_10562("GroupedItems"));
        this.phase = Phase.IDLE;
        String name = compound.method_10558("Phase");
        for (Phase phase : Phase.values()) {
            if (!phase.name().equals(name)) continue;
            this.phase = phase;
        }
        this.countDown = compound.method_10550("CountDown");
        this.covered = compound.method_10577("Cover");
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (compound.method_10545("Redraw")) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
        if (phaseBefore != this.phase && this.phase == Phase.CRAFTING) {
            this.groupedItemsBeforeCraft = before;
        }
        if (phaseBefore == Phase.EXPORTING && this.phase == Phase.WAITING) {
            class_2350 facing = (class_2350)this.method_11010().method_11654(MechanicalCrafterBlock.HORIZONTAL_FACING);
            class_243 vec = class_243.method_24954((class_2382)facing.method_10163()).method_1021(0.75).method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(this.method_11010());
            vec = vec.method_1019(class_243.method_24954((class_2382)targetDirection.method_10163()).method_1021(1.0));
            this.field_11863.method_8406((class_2394)class_2398.field_11205, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void method_11012() {
        super.method_11012();
    }

    public int getCountDownSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed())), (int)4, (int)250);
    }

    @Override
    public void tick() {
        boolean runLogic;
        super.tick();
        if (this.phase == Phase.ACCEPTING) {
            return;
        }
        boolean onClient = this.field_11863.field_9236;
        boolean bl = runLogic = !onClient || this.isVirtual();
        if (this.wasPoweredBefore != this.field_11863.method_8479(this.field_11867)) {
            this.wasPoweredBefore = this.field_11863.method_8479(this.field_11867);
            if (this.wasPoweredBefore) {
                if (!runLogic) {
                    return;
                }
                this.checkCompletedRecipe(true);
            }
        }
        if (this.phase == Phase.ASSEMBLING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                class_1799 result;
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                if (RecipeGridHandler.getTargetingCrafter(this) != null) {
                    this.phase = Phase.EXPORTING;
                    this.countDown = 1000;
                    this.sendData();
                    return;
                }
                class_1799 class_17992 = result = this.isVirtual() ? this.scriptedResult : RecipeGridHandler.tryToApplyRecipe(this.field_11863, this.groupedItems);
                if (result != null) {
                    ArrayList containers = new ArrayList();
                    this.groupedItems.grid.values().forEach(stack -> {
                        if (stack.method_7909().method_7857()) {
                            containers.add(stack.method_7909().method_7858().method_7854());
                        }
                    });
                    if (this.isVirtual()) {
                        this.groupedItemsBeforeCraft = this.groupedItems;
                    }
                    this.groupedItems = new RecipeGridHandler.GroupedItems(result);
                    for (int i = 0; i < containers.size(); ++i) {
                        class_1799 stack2 = (class_1799)containers.get(i);
                        RecipeGridHandler.GroupedItems container = new RecipeGridHandler.GroupedItems();
                        container.grid.put((Pair<Integer, Integer>)Pair.of((Object)i, (Object)0), stack2);
                        container.mergeOnto(this.groupedItems, Pointing.LEFT);
                    }
                    this.phase = Phase.CRAFTING;
                    this.countDown = 2000;
                    this.sendData();
                    return;
                }
                this.ejectWholeGrid();
                return;
            }
        }
        if (this.phase == Phase.EXPORTING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                MechanicalCrafterTileEntity targetingCrafter = RecipeGridHandler.getTargetingCrafter(this);
                if (targetingCrafter == null) {
                    this.ejectWholeGrid();
                    return;
                }
                Pointing pointing = (Pointing)((Object)this.method_11010().method_11654(MechanicalCrafterBlock.POINTING));
                this.groupedItems.mergeOnto(targetingCrafter.groupedItems, pointing);
                this.groupedItems = new RecipeGridHandler.GroupedItems();
                float pitch = (float)(targetingCrafter.groupedItems.grid.size() * 1) / 16.0f + 0.5f;
                AllSoundEvents.CRAFTER_CLICK.playOnServer(this.field_11863, (class_2382)this.field_11867, 1.0f, pitch);
                this.phase = Phase.WAITING;
                this.countDown = 0;
                this.sendData();
                targetingCrafter.continueIfAllPrecedingFinished();
                targetingCrafter.sendData();
                return;
            }
        }
        if (this.phase == Phase.CRAFTING) {
            if (onClient) {
                class_2350 facing = (class_2350)this.method_11010().method_11654(MechanicalCrafterBlock.HORIZONTAL_FACING);
                float progress = (float)this.countDown / 2000.0f;
                class_243 facingVec = class_243.method_24954((class_2382)facing.method_10163());
                class_243 vec = facingVec.method_1021(0.65).method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
                class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.125f).method_18806(VecHelper.axisAlingedPlaneOf(facingVec)).method_1029().method_1021((double)(progress * 0.5f)).method_1019(vec);
                if (progress > 0.5f) {
                    this.field_11863.method_8406((class_2394)class_2398.field_11205, offset.field_1352, offset.field_1351, offset.field_1350, 0.0, 0.0, 0.0);
                }
                if (!this.groupedItemsBeforeCraft.grid.isEmpty() && progress < 0.5f && this.groupedItems.grid.containsKey(Pair.of((Object)0, (Object)0))) {
                    class_1799 stack3 = this.groupedItems.grid.get(Pair.of((Object)0, (Object)0));
                    this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
                    for (int i = 0; i < 10; ++i) {
                        class_243 randVec = VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.125f).method_18806(VecHelper.axisAlingedPlaneOf(facingVec)).method_1029().method_1021(0.25);
                        class_243 offset2 = randVec.method_1019(vec);
                        randVec = randVec.method_1021((double)0.35f);
                        this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, stack3), offset2.field_1352, offset2.field_1351, offset2.field_1350, randVec.field_1352, randVec.field_1351, randVec.field_1350);
                    }
                }
            }
            int prev = this.countDown;
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 1000 && prev >= 1000) {
                AllSoundEvents.CRAFTER_CLICK.playOnServer(this.field_11863, (class_2382)this.field_11867, 1.0f, 2.0f);
                AllSoundEvents.CRAFTER_CRAFT.playOnServer(this.field_11863, (class_2382)this.field_11867);
            }
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                this.tryInsert();
                return;
            }
        }
        if (this.phase == Phase.INSERTING) {
            if (runLogic && this.isTargetingBelt()) {
                this.tryInsert();
            }
            return;
        }
    }

    protected boolean isTargetingBelt() {
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        return behaviour != null && behaviour.canInsertFromSide(this.getTargetDirection());
    }

    protected DirectBeltInputBehaviour getTargetingBelt() {
        class_2338 targetPos = this.field_11867.method_10093(this.getTargetDirection());
        return TileEntityBehaviour.get((class_1922)this.field_11863, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public void tryInsert() {
        if (!this.inserting.hasInventory() && !this.isTargetingBelt()) {
            this.ejectWholeGrid();
            return;
        }
        boolean chagedPhase = this.phase != Phase.INSERTING;
        LinkedList<Pair<Integer, Integer>> inserted = new LinkedList<Pair<Integer, Integer>>();
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        for (Map.Entry<Pair<Integer, Integer>, class_1799> entry : this.groupedItems.grid.entrySet()) {
            class_1799 remainder;
            Pair<Integer, Integer> pair = entry.getKey();
            class_1799 stack = entry.getValue();
            BlockFace face = this.getTargetFace(this.field_11863, this.field_11867, this.method_11010());
            class_1799 class_17992 = remainder = behaviour == null ? this.inserting.insert(stack.method_7972()) : behaviour.handleInsertion(stack, face.getFace(), false);
            if (!remainder.method_7960()) {
                stack.method_7939(remainder.method_7947());
                continue;
            }
            inserted.add(pair);
        }
        inserted.forEach(this.groupedItems.grid::remove);
        if (this.groupedItems.grid.isEmpty()) {
            this.ejectWholeGrid();
        } else {
            this.phase = Phase.INSERTING;
        }
        if (!inserted.isEmpty() || chagedPhase) {
            this.sendData();
        }
    }

    public void ejectWholeGrid() {
        List<MechanicalCrafterTileEntity> chain = RecipeGridHandler.getAllCraftersOfChain(this);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterTileEntity::eject);
    }

    public void eject() {
        class_2680 blockState = this.method_11010();
        boolean present = AllBlocks.MECHANICAL_CRAFTER.has(blockState);
        class_243 vec = present ? class_243.method_24954((class_2382)((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10163()).method_1021(0.75) : class_243.field_1353;
        class_243 ejectPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(vec);
        this.groupedItems.grid.forEach((pair, stack) -> this.dropItem(ejectPos, (class_1799)stack));
        if (!this.inventory.method_5438(0).method_7960()) {
            this.dropItem(ejectPos, this.inventory.method_5438(0));
        }
        this.phase = Phase.IDLE;
        this.groupedItems = new RecipeGridHandler.GroupedItems();
        this.inventory.setStackInSlot(0, class_1799.field_8037);
        this.sendData();
    }

    public void dropItem(class_243 ejectPos, class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.field_11863, ejectPos.field_1352, ejectPos.field_1351, ejectPos.field_1350, stack);
        itemEntity.method_6988();
        this.field_11863.method_8649((class_1297)itemEntity);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (this.phase == Phase.IDLE && this.craftingItemPresent()) {
            this.checkCompletedRecipe(false);
        }
        if (this.phase == Phase.INSERTING) {
            this.tryInsert();
        }
    }

    public boolean craftingItemPresent() {
        return !this.inventory.method_5438(0).method_7960();
    }

    public boolean craftingItemOrCoverPresent() {
        return !this.inventory.method_5438(0).method_7960() || this.covered;
    }

    protected void checkCompletedRecipe(boolean poweredStart) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        List<MechanicalCrafterTileEntity> chain = RecipeGridHandler.getAllCraftersOfChainIf(this, poweredStart ? MechanicalCrafterTileEntity::craftingItemPresent : MechanicalCrafterTileEntity::craftingItemOrCoverPresent, poweredStart);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterTileEntity::begin);
    }

    protected void begin() {
        this.phase = Phase.ACCEPTING;
        this.groupedItems = new RecipeGridHandler.GroupedItems(this.inventory.method_5438(0));
        this.inventory.setStackInSlot(0, class_1799.field_8037);
        if (RecipeGridHandler.getPrecedingCrafters(this).isEmpty()) {
            this.phase = Phase.ASSEMBLING;
            this.countDown = 500;
        }
        this.sendData();
    }

    protected void continueIfAllPrecedingFinished() {
        List<MechanicalCrafterTileEntity> preceding = RecipeGridHandler.getPrecedingCrafters(this);
        if (preceding == null) {
            this.ejectWholeGrid();
            return;
        }
        for (MechanicalCrafterTileEntity mechanicalCrafterTileEntity : preceding) {
            if (mechanicalCrafterTileEntity.phase == Phase.WAITING) continue;
            return;
        }
        this.phase = Phase.ASSEMBLING;
        this.countDown = Math.max(100, this.getCountDownSpeed() + 1);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.input.getItemHandler(this.field_11863, this.field_11867);
    }

    public void connectivityChanged() {
        this.reRender = true;
        this.sendData();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setScriptedResult(class_1799 scriptedResult) {
        this.scriptedResult = scriptedResult;
    }

    static enum Phase {
        IDLE,
        ACCEPTING,
        ASSEMBLING,
        EXPORTING,
        WAITING,
        CRAFTING,
        INSERTING;

    }

    public static class Inventory
    extends SmartInventory {
        private MechanicalCrafterTileEntity te;

        public Inventory(MechanicalCrafterTileEntity te) {
            super(1, te, 1, false);
            this.te = te;
            this.forbidExtraction();
            this.whenContentsChanged(() -> {
                if (this.handler.stacks[0].method_7960()) {
                    return;
                }
                if (te.phase == Phase.IDLE) {
                    te.checkCompletedRecipe(false);
                }
            });
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (this.te.phase != Phase.IDLE) {
                return 0L;
            }
            if (this.te.covered) {
                return 0L;
            }
            long inserted = this.handler.insert(resource, maxAmount, transaction);
            if (inserted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, () -> this.te.method_10997().method_8396(null, this.te.method_11016(), class_3417.field_14667, class_3419.field_15245, 0.25f, 0.5f));
            }
            return inserted;
        }
    }
}

