/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.RecipeGridHandler;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;

public class MechanicalCrafterRenderer
extends SafeTileEntityRenderer<MechanicalCrafterTileEntity> {
    public MechanicalCrafterRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(MechanicalCrafterTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        ms.method_22903();
        class_2350 facing = (class_2350)te.method_11010().method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        class_243 vec = class_243.method_24954((class_2382)facing.method_10163()).method_1021(0.58).method_1031(0.5, 0.5, 0.5);
        if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING) {
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(te.method_11010());
            float progress = class_3532.method_15363((float)(((float)(1000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
            vec = vec.method_1019(class_243.method_24954((class_2382)targetDirection.method_10163()).method_1021((double)(progress * 0.75f)));
        }
        ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        ms.method_22905(0.5f, 0.5f, 0.5f);
        float yRot = AngleHelper.horizontalAngle(facing);
        ms.method_22907(class_1160.field_20705.method_23214(yRot));
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
        ms.method_22909();
        this.renderFast(te, partialTicks, ms, buffer, light);
    }

    public void renderItems(MechanicalCrafterTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (te.phase == MechanicalCrafterTileEntity.Phase.IDLE) {
            class_1799 stack2 = te.getInventory().method_5438(0);
            if (!stack2.method_7960()) {
                ms.method_22903();
                ms.method_22904(0.0, 0.0, -0.00390625);
                ms.method_22907(class_1160.field_20705.method_23214(180.0f));
                class_310.method_1551().method_1480().method_23178(stack2, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                ms.method_22909();
            }
        } else {
            RecipeGridHandler.GroupedItems items = te.groupedItems;
            float distance = 0.5f;
            ms.method_22903();
            if (te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING) {
                items = te.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = class_3532.method_15363((float)(((float)(2000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.method_22905(1.0f - lateProgress, 1.0f - lateProgress, 1.0f - lateProgress);
                class_243 centering = new class_243((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).method_1021((double)earlyProgress);
                ms.method_22904(centering.field_1352 * 0.5, centering.field_1351 * 0.5, 0.0);
                distance += (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
            }
            boolean onlyRenderFirst = te.phase == MechanicalCrafterTileEntity.Phase.INSERTING || te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING && te.countDown < 1000;
            float spacing = distance;
            items.grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0)) {
                    return;
                }
                ms.method_22903();
                Integer x = (Integer)pair.getKey();
                Integer y = (Integer)pair.getValue();
                ms.method_22904((double)((float)x.intValue() * spacing), (double)((float)y.intValue() * spacing), 0.0);
                int offset = 0;
                if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING && te.method_11010().method_28498(MechanicalCrafterBlock.POINTING)) {
                    Pointing value = (Pointing)((Object)((Object)te.method_11010().method_11654(MechanicalCrafterBlock.POINTING)));
                    offset = value == Pointing.UP ? -1 : (value == Pointing.LEFT ? 2 : (value == Pointing.RIGHT ? -2 : 1));
                }
                ((TransformStack)TransformStack.cast((class_4587)ms).rotateY(180.0)).translate(0.0, 0.0, (double)((float)(x + y * 3 + offset * 9) / 1024.0f));
                class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                ms.method_22909();
            });
            ms.method_22909();
            if (te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING) {
                items = te.groupedItems;
                float progress = class_3532.method_15363((float)(((float)(1000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.method_22907(class_1160.field_20707.method_23214(earlyProgress * 2.0f * 360.0f));
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1.0f + (1.0f - lateProgress) * 0.125f;
                ms.method_22905(upScaling, upScaling, upScaling);
                ms.method_22905(downScaling, downScaling, downScaling);
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                        return;
                    }
                    ms.method_22903();
                    ms.method_22907(class_1160.field_20705.method_23214(180.0f));
                    class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                    ms.method_22909();
                });
            }
        }
    }

    public void renderFast(MechanicalCrafterTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_2680 blockState = te.method_11010();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (!Backend.canUseInstancing((class_1937)te.method_10997())) {
            SuperByteBuffer superBuffer = CachedBufferer.partial(AllBlockPartials.SHAFTLESS_COGWHEEL, blockState);
            KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light);
            superBuffer.rotateCentered(class_2350.field_11036, (float)(((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() != class_2350.class_2351.field_11048 ? 0.0 : 1.5707963267948966));
            superBuffer.rotateCentered(class_2350.field_11034, 1.5707964f);
            superBuffer.renderInto(ms, vb);
        }
        class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        class_2338 pos = te.method_11016();
        if ((te.covered || te.phase != MechanicalCrafterTileEntity.Phase.IDLE) && te.phase != MechanicalCrafterTileEntity.Phase.CRAFTING && te.phase != MechanicalCrafterTileEntity.Phase.INSERTING) {
            SuperByteBuffer lidBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_LID, blockState);
            lidBuffer.light(light).renderInto(ms, vb);
        }
        if (MechanicalCrafterBlock.isValidTarget(te.method_10997(), pos.method_10093(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_BELT, blockState);
            SuperByteBuffer beltFrameBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_BELT_FRAME, blockState);
            if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)te.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                beltBuffer.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, (float)(textureIndex % 4) / 4.0f, 0.0f, 1);
            }
            beltBuffer.light(light).renderInto(ms, vb);
            beltFrameBuffer.light(light).renderInto(ms, vb);
        } else {
            SuperByteBuffer arrowBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_ARROW, blockState);
            arrowBuffer.light(light).renderInto(ms, vb);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, class_2680 crafterState) {
        SuperByteBuffer buffer = CachedBufferer.partial(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.method_11654(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((class_2350)crafterState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered(class_2350.field_11036, (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI));
        buffer.rotateCentered(class_2350.field_11034, (float)((double)(xRot / 180.0f) * Math.PI));
        return buffer;
    }
}

