/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;

public abstract class BlockBreakingKineticTileEntity
extends KineticTileEntity {
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected int destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected class_2338 breakingPos;

    public BlockBreakingKineticTileEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.destroyProgress == -1) {
            this.destroyNextTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.ticksUntilNextProgress == -1) {
            this.destroyNextTick();
        }
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    protected abstract class_2338 getBreakingPos();

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Progress", this.destroyProgress);
        compound.method_10569("NextTick", this.ticksUntilNextProgress);
        if (this.breakingPos != null) {
            compound.method_10566("Breaking", (class_2520)class_2512.method_10692((class_2338)this.breakingPos));
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.destroyProgress = compound.method_10550("Progress");
        this.ticksUntilNextProgress = compound.method_10550("NextTick");
        if (compound.method_10545("Breaking")) {
            this.breakingPos = class_2512.method_10691((class_2487)compound.method_10562("Breaking"));
        }
        super.read(compound, clientPacket);
    }

    @Override
    public void method_11012() {
        if (!this.field_11863.field_9236 && this.destroyProgress != 0) {
            this.field_11863.method_8517(this.breakerId, this.breakingPos, -1);
        }
        super.method_11012();
    }

    @Override
    public void tick() {
        float blockHardness;
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        if (!this.shouldRun()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.breakingPos = this.getBreakingPos();
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        class_2680 stateToBreak = this.field_11863.method_8320(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.method_26214((class_1922)this.field_11863, this.breakingPos))) {
            if (this.destroyProgress != 0) {
                this.destroyProgress = 0;
                this.field_11863.method_8517(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += class_3532.method_15340((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - this.destroyProgress));
        this.field_11863.method_8396(null, this.field_11867, stateToBreak.method_26231().method_10596(), class_3419.field_15254, 0.25f, 1.0f);
        if (this.destroyProgress >= 10) {
            this.onBlockBroken(stateToBreak);
            this.destroyProgress = 0;
            this.ticksUntilNextProgress = -1;
            this.field_11863.method_8517(this.breakerId, this.breakingPos, -1);
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        this.field_11863.method_8517(this.breakerId, this.breakingPos, this.destroyProgress);
    }

    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        return BlockBreakingKineticTileEntity.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(class_2680 stateToBreak, float blockHardness) {
        return !stateToBreak.method_26207().method_15797() && !(stateToBreak.method_26204() instanceof class_2189) && blockHardness != -1.0f;
    }

    public void onBlockBroken(class_2680 stateToBreak) {
        class_3610 FluidState = this.field_11863.method_8316(this.breakingPos);
        this.field_11863.method_20290(2001, this.breakingPos, class_2248.method_9507((class_2680)stateToBreak));
        class_2586 tileentity = stateToBreak.method_31709() ? this.field_11863.method_8321(this.breakingPos) : null;
        class_243 vec = VecHelper.offsetRandomly(VecHelper.getCenterOf((class_2382)this.breakingPos), this.field_11863.field_9229, 0.125f);
        class_2248.method_9562((class_2680)stateToBreak, (class_3218)((class_3218)this.field_11863), (class_2338)this.breakingPos, (class_2586)tileentity).forEach(stack -> {
            if (!stack.method_7960() && this.field_11863.method_8450().method_8355(class_1928.field_19392)) {
                class_1542 itementity = new class_1542(this.field_11863, vec.field_1352, vec.field_1351, vec.field_1350, stack);
                itementity.method_6988();
                itementity.method_18799(class_243.field_1353);
                this.field_11863.method_8649((class_1297)itementity);
            }
        });
        if (this.field_11863 instanceof class_3218) {
            stateToBreak.method_26180((class_3218)this.field_11863, this.breakingPos, class_1799.field_8037);
        }
        this.field_11863.method_8652(this.breakingPos, FluidState.method_15759(), 3);
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 100.0f);
    }
}

