/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import java.util.Collections;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class IoStorage<T>
implements Storage<T> {
    private final Storage<T> storage;
    private final boolean allowInsert;
    private final boolean allowExtract;

    public IoStorage(Storage<T> storage, boolean allowInsert, boolean allowExtract) {
        this.storage = storage;
        this.allowInsert = allowInsert;
        this.allowExtract = allowExtract;
    }

    public boolean supportsInsertion() {
        return this.allowInsert;
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        if (this.allowInsert) {
            return this.storage.insert(resource, maxAmount, transaction);
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        return this.allowExtract;
    }

    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        if (this.allowExtract) {
            return this.storage.extract(resource, maxAmount, transaction);
        }
        return 0L;
    }

    public Iterator<? extends StorageView<T>> iterator(TransactionContext transaction) {
        if (this.allowExtract) {
            return this.storage.iterator(transaction);
        }
        return Collections.emptyIterator();
    }
}

