/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures.coloramp;

import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.coloramp.Coloramp;
import java.util.function.Function;

public class MixedColoramp
implements Coloramp {
    private final Coloramp coloramp1;
    private final Coloramp coloramp2;
    private final Function<Double, Double> mixer;
    private final double meanMix;

    public MixedColoramp(Coloramp coloramp1, Coloramp coloramp2, Function<Double, Double> mixer, double meanMix) {
        this.coloramp1 = coloramp1;
        this.coloramp2 = coloramp2;
        this.mixer = mixer;
        this.meanMix = meanMix;
    }

    @Override
    public int getRGB(double luminance) {
        return TextureHelper.mixRGB(this.coloramp1.getRGB(luminance), this.coloramp2.getRGB(luminance), this.mixer.apply(luminance));
    }

    @Override
    public int getMeanRGB() {
        return TextureHelper.mixRGB(this.coloramp1.getMeanRGB(), this.coloramp2.getMeanRGB(), this.meanMix);
    }
}

