/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.textures.coloramp.BakableTargetColoramp;
import aztech.modern_industrialization.textures.coloramp.Coloramp;
import aztech.modern_industrialization.textures.coloramp.DefaultColoramp;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.function.BiConsumer;
import net.minecraft.class_1011;
import net.minecraft.class_3300;

public final class MITextures {
    private static final String[] LAYERS = new String[]{"_underlay", "", "_overlay"};

    public static void offerTextures(BiConsumer<class_1011, String> textureWriter, BiConsumer<JsonElement, String> mcMetaWriter, class_3300 manager) {
        TextureManager mtm = new TextureManager(manager, textureWriter, mcMetaWriter);
        for (BakableTargetColoramp coloramp : BakableTargetColoramp.bakableTargetColoramps) {
            coloramp.baked(mtm);
        }
        try {
            for (Material material : MaterialRegistry.getMaterials().values()) {
                for (MaterialPart part : material.getParts().values()) {
                    part.registerTextures(mtm);
                }
            }
            for (FluidDefinition fluid : MIFluids.FLUIDS.values()) {
                MITextures.registerFluidTextures(mtm, fluid);
            }
            MITextures.casingFromTexture(mtm, "lv", mtm.getAssetAsTexture("modern_industrialization:textures/block/basic_machine_hull.png"));
            MITextures.casingFromTexture(mtm, "mv", mtm.getAssetAsTexture("modern_industrialization:textures/block/advanced_machine_hull.png"));
            MITextures.casingFromTexture(mtm, "hv", mtm.getAssetAsTexture("modern_industrialization:textures/block/turbo_machine_hull.png"));
            MITextures.casingFromTexture(mtm, "ev", mtm.getAssetAsTexture("modern_industrialization:textures/block/highly_advanced_machine_hull.png"));
            MITextures.casingFromTexture(mtm, "superconductor", mtm.getAssetAsTexture("modern_industrialization:textures/block/quantum_machine_hull.png"));
            MITextures.casingFromTexture(mtm, "nuclear", mtm.getAssetAsTexture("modern_industrialization:textures/block/nuclear_machine_casing.png"));
            MITextures.casingFromTexture(mtm, "firebricks", mtm.getAssetAsTexture("modern_industrialization:textures/block/fire_clay_bricks.png"));
            MITextures.casingFromTexture(mtm, "bricks", mtm.getAssetAsTexture("minecraft:textures/block/bricks.png"));
            MITextures.casingFromTextureBricked(mtm, "bricked_bronze", mtm.getAssetAsTexture("modern_industrialization:textures/block/bronze_machine_casing.png"), mtm.getAssetAsTexture("modern_industrialization:textures/block/fire_clay_bricks.png"));
            MITextures.casingFromTextureBricked(mtm, "bricked_steel", mtm.getAssetAsTexture("modern_industrialization:textures/block/steel_machine_casing.png"), mtm.getAssetAsTexture("modern_industrialization:textures/block/fire_clay_bricks.png"));
            mtm.addTexture("modern_industrialization:textures/item/mixed_ingot_blastproof.png", TextureHelper.tripleTexture(mtm.getAssetAsTexture("modern_industrialization:textures/item/stainless_steel_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/titanium_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/tungsten_ingot.png")));
            mtm.addTexture("modern_industrialization:textures/item/mixed_plate_nuclear.png", TextureHelper.tripleTexture(mtm.getAssetAsTexture("modern_industrialization:textures/item/cadmium_plate.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/beryllium_plate.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/blastproof_alloy_plate.png"), 1, 2));
            mtm.addTexture("modern_industrialization:textures/item/mixed_ingot_iridium.png", TextureHelper.tripleTexture(mtm.getAssetAsTexture("modern_industrialization:textures/item/blastproof_alloy_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/iridium_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/blastproof_alloy_ingot.png")));
            mtm.onEnd();
        }
        catch (Throwable exception) {
            ModernIndustrialization.LOGGER.error("Failed to generate texture pack.", exception);
        }
        ModernIndustrialization.LOGGER.info("I used the png to destroy the png.");
    }

    private static String getTemplate(String materialSet, String part, String suffix) {
        return String.format("modern_industrialization:textures/materialsets/%s/%s%s.png", materialSet, part, suffix);
    }

    private static void colorizeLayer(class_1011 image, String layer, Coloramp coloramp) {
        if (layer.equals("")) {
            TextureHelper.colorize(image, coloramp);
        }
    }

    public static void generateItemPartTexture(TextureManager mtm, String partTemplate, String overlay, String materialSet, String path, boolean isBlock, Coloramp coloramp) {
        try {
            class_1011 texture = MITextures.generateTexture(mtm, partTemplate, materialSet, coloramp);
            if (overlay != null) {
                String overlayTemplate = MITextures.getTemplate("common", overlay, "");
                class_1011 overlayTexture = mtm.getAssetAsTexture(overlayTemplate);
                class_1011 oldTexture = texture;
                texture = TextureHelper.blend(oldTexture, overlayTexture);
                oldTexture.close();
                overlayTexture.close();
            }
            MITextures.appendTexture(mtm, texture, path, isBlock);
            texture.close();
        }
        catch (Throwable throwable) {
            MITextures.logTextureGenerationError(throwable, path, materialSet, partTemplate);
        }
    }

    public static void generateItemPartTexture(TextureManager mtm, String partTemplate, String materialSet, String path, boolean isBlock, Coloramp coloramp) {
        MITextures.generateItemPartTexture(mtm, partTemplate, null, materialSet, path, isBlock, coloramp);
    }

    public static void logTextureGenerationError(Throwable throwable, String path, String materialSet, String part) {
        ModernIndustrialization.LOGGER.warn(String.format("Failed to generate item part texture for path %s, material set %s, partTemplate %s", path, materialSet, part), throwable);
    }

    public static class_1011 generateTexture(TextureManager mtm, String partTemplate, String materialSet, Coloramp coloramp) throws IOException {
        class_1011 image = null;
        for (String layer : LAYERS) {
            String template = MITextures.getTemplate(materialSet, partTemplate, layer);
            if (!mtm.hasAsset(template)) {
                template = MITextures.getTemplate("common", partTemplate, layer);
            }
            if (!mtm.hasAsset(template)) continue;
            if (image == null) {
                image = mtm.getAssetAsTexture(template);
                MITextures.colorizeLayer(image, layer, coloramp);
                continue;
            }
            class_1011 topLayer = mtm.getAssetAsTexture(template);
            MITextures.colorizeLayer(topLayer, layer, coloramp);
            class_1011 oldImage = image;
            image = TextureHelper.blend(oldImage, topLayer);
            oldImage.close();
            topLayer.close();
        }
        return image;
    }

    public static void appendTexture(TextureManager mtm, class_1011 texture, String path, boolean isBlock) throws IOException {
        if (texture == null) {
            throw new RuntimeException("Could not find any texture!");
        }
        String texturePath = isBlock ? String.format("modern_industrialization:textures/block/%s.png", path) : String.format("modern_industrialization:textures/item/%s.png", path);
        mtm.addTexture(texturePath, texture);
        texture.close();
    }

    public static void generateDoubleIngot(TextureManager mtm, String materialName) throws IOException {
        String ingotTexture = String.format("modern_industrialization:textures/item/%s_ingot.png", materialName);
        if (materialName.equals("gold") || materialName.equals("iron") || materialName.equals("copper")) {
            ingotTexture = String.format("minecraft:textures/item/%s_ingot.png", materialName);
        }
        class_1011 image = mtm.getAssetAsTexture(ingotTexture);
        TextureHelper.doubleIngot(image);
        String itemPath = materialName + "_double_ingot";
        mtm.addTexture(String.format("modern_industrialization:textures/item/%s.png", itemPath), image);
        image.close();
    }

    public static void casingFromTexture(TextureManager tm, String casing, class_1011 texture) {
        for (String side : new String[]{"top", "side", "bottom"}) {
            try {
                String s = String.format("modern_industrialization:textures/block/casings/%s/%s.png", casing, side);
                tm.addTexture(s, TextureHelper.copy(texture));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void casingFromTextureBricked(TextureManager tm, String casing, class_1011 texture, class_1011 brick) {
        for (String side : new String[]{"top", "side", "bottom"}) {
            try {
                class_1011 target;
                if (side.equals("top")) {
                    target = TextureHelper.copy(texture);
                } else if (side.equals("bottom")) {
                    target = TextureHelper.copy(brick);
                } else {
                    if (texture.method_4307() != brick.method_4307() || texture.method_4323() != brick.method_4323()) {
                        throw new IllegalArgumentException("Texture and Brick must have same dimension");
                    }
                    class_1011 copy = TextureHelper.copy(texture);
                    for (int i = 0; i < copy.method_4307(); ++i) {
                        for (int j = copy.method_4323() / 2; j < copy.method_4323(); ++j) {
                            copy.method_4305(i, j, brick.method_4315(i, j));
                        }
                    }
                    target = copy;
                }
                String s = String.format("modern_industrialization:textures/block/casings/%s/%s.png", casing, side);
                tm.addTexture(s, target);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void registerFluidTextures(TextureManager tm, FluidDefinition fluid) {
        String path = "modern_industrialization:textures/fluid/";
        String bucket = path + "bucket.png";
        String bucket_content = path + "bucket_content.png";
        DefaultColoramp fluidColoramp = new DefaultColoramp(fluid.color);
        try {
            class_1011 bucket_image = tm.getAssetAsTexture(bucket);
            class_1011 bucket_content_image = tm.getAssetAsTexture(bucket_content);
            TextureHelper.colorize(bucket_content_image, fluidColoramp);
            class_1011 oldBucketImage = bucket_image;
            bucket_image = TextureHelper.blend(oldBucketImage, bucket_content_image);
            oldBucketImage.close();
            if (fluid.isGas) {
                TextureHelper.flip(bucket_image);
            }
            tm.addTexture(String.format("modern_industrialization:textures/item/bucket_%s.png", fluid.path()), bucket_image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String pathFluid = path + String.format("template/%s.png", fluid.fluidTexture.path);
        try {
            class_1011 fluidAnim = tm.getAssetAsTexture(pathFluid);
            TextureHelper.colorize(fluidAnim, fluidColoramp);
            TextureHelper.setAlpha(fluidAnim, fluid.opacity);
            tm.addTexture(String.format("modern_industrialization:textures/fluid/%s_still.png", fluid.path()), fluidAnim, true);
            tm.addMcMeta(String.format("modern_industrialization:textures/fluid/%s_still.png.mcmeta", fluid.path()), fluid.fluidTexture.mcMetaInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

